/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jpa.openjpa;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.executor.SpaceTask;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.utils.CollectionUtils;
import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.core.client.SQLQuery;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.kernel.AbstractStoreQuery;
import org.apache.openjpa.kernel.QueryContext;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.lib.rop.ListResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.UserException;
import org.openspaces.core.executor.DistributedTask;
import org.openspaces.core.executor.Task;
import org.openspaces.core.executor.internal.ExecutorMetaDataProvider;
import org.openspaces.core.executor.internal.InternalDistributedSpaceTaskWrapper;
import org.openspaces.core.executor.internal.InternalSpaceTaskWrapper;
import org.openspaces.jpa.StoreManager;
import org.openspaces.remoting.scripting.Script;
import org.openspaces.remoting.scripting.ScriptingExecutor;

public class StoreManagerSQLQuery
extends AbstractStoreQuery {
    private static final long serialVersionUID = 1L;
    private StoreManager _store;

    public StoreManagerSQLQuery(StoreManager store) {
        this._store = store;
    }

    public StoreManager getStore() {
        return this._store;
    }

    public boolean supportsParameterDeclarations() {
        return false;
    }

    public boolean supportsDataStoreExecution() {
        return true;
    }

    public StoreQuery.Executor newDataStoreExecutor(ClassMetaData meta, boolean subclasses) {
        return new SQLExecutor();
    }

    public boolean requiresCandidateType() {
        return false;
    }

    public boolean requiresParameterDeclarations() {
        return false;
    }

    public static String substituteParams(String sql, List<Integer> paramOrder) throws IOException {
        int ttype;
        if (sql.indexOf("?") == -1) {
            return sql;
        }
        paramOrder.clear();
        StreamTokenizer tok = new StreamTokenizer(new StringReader(sql));
        tok.resetSyntax();
        tok.quoteChar(39);
        tok.wordChars(48, 57);
        tok.wordChars(63, 63);
        StringBuilder buf = new StringBuilder(sql.length());
        block4: while ((ttype = tok.nextToken()) != -1) {
            switch (ttype) {
                case -3: {
                    if (tok.sval.startsWith("?")) {
                        buf.append("?");
                        String pIndex = tok.sval.substring(1);
                        if (pIndex.length() > 0) {
                            paramOrder.add(Integer.valueOf(pIndex));
                            continue block4;
                        }
                        paramOrder.add(paramOrder.size() + 1);
                        continue block4;
                    }
                    buf.append(tok.sval);
                    continue block4;
                }
                case 39: {
                    buf.append('\'');
                    if (tok.sval == null) continue block4;
                    buf.append(tok.sval);
                    buf.append('\'');
                    continue block4;
                }
            }
            buf.append((char)ttype);
        }
        return buf.toString();
    }

    protected static class SQLExecutor
    extends AbstractStoreQuery.AbstractExecutor {
        private final String _executeCommand = "execute ?";
        private final ExecutorMetaDataProvider _executorMetaDataProvider = new ExecutorMetaDataProvider();

        public int getOperation(StoreQuery q) {
            return q.getContext().getCandidateType() != null || q.getContext().getResultType() != null || q.getContext().getResultMappingName() != null || q.getContext().getResultMappingScope() != null ? 1 : 3;
        }

        public ResultObjectProvider executeQuery(StoreQuery storeQuery, Object[] params, StoreQuery.Range range) {
            if (storeQuery.getContext().getCandidateType() == null) {
                return this.executeTaskOrScript(storeQuery, params);
            }
            return this.executeSqlQuery(storeQuery, params);
        }

        private ResultObjectProvider executeSqlQuery(StoreQuery storeQuery, Object[] params) {
            try {
                String sql = StringUtils.trimToNull((String)storeQuery.getContext().getQueryString());
                if ("execute ?".equalsIgnoreCase(sql)) {
                    throw new UserException("When specifying a candidate type - SQLQuery syntax should be used. For task execution use the entityManager.createNativeQuery(String sql) method.");
                }
                QueryContext context = storeQuery.getContext();
                Class type = context.getCandidateType();
                SQLQuery sqlQuery = new SQLQuery(type, context.getQueryString());
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        sqlQuery.setParameter(i + 1, params[i]);
                    }
                }
                StoreManagerSQLQuery query = (StoreManagerSQLQuery)storeQuery;
                StoreManager store = query.getStore();
                Object[] result = store.getConfiguration().getSpace().readMultiple((Object)sqlQuery, store.getCurrentTransaction(), Integer.MAX_VALUE, store.getConfiguration().getReadModifier());
                return new ListResultObjectProvider(CollectionUtils.toList((Object[])result));
            }
            catch (Exception e) {
                throw new GeneralException((Throwable)e);
            }
        }

        private ResultObjectProvider executeTaskOrScript(StoreQuery storeQuery, Object[] params) {
            QueryContext ctx = storeQuery.getContext();
            String sql = StringUtils.trimToNull((String)ctx.getQueryString());
            if (!"execute ?".equalsIgnoreCase(sql)) {
                throw new UserException("Unsupported native query task/script execution syntax - " + sql);
            }
            StoreManagerSQLQuery query = (StoreManagerSQLQuery)storeQuery;
            if (params == null) {
                throw new UserException("Execute task/script is not supported for non-parametrized query.");
            }
            if (params.length != 1) {
                throw new UserException("Illegal number of arguments <" + params.length + "> should be <1>.");
            }
            if (params[0] instanceof Task) {
                return this.executeTask((Task)params[0], query);
            }
            if (params[0] instanceof Script) {
                return this.executeScript((Script)params[0], query);
            }
            throw new UserException("Illegal task/script execution parameter type - " + params[0].getClass().getName() + ". " + Task.class.getName() + " or " + Script.class.getName() + " is expected.");
        }

        private ResultObjectProvider executeScript(Script script, StoreManagerSQLQuery query) {
            try {
                ScriptingExecutor<?> executor = query.getStore().getConfiguration().getScriptingExecutorProxy();
                Object result = executor.execute(script);
                LinkedList<Object> resultList = new LinkedList<Object>();
                resultList.add(result);
                return new ListResultObjectProvider(resultList);
            }
            catch (Exception e) {
                throw new GeneralException((Throwable)e);
            }
        }

        private ResultObjectProvider executeTask(Task<?> task, StoreManagerSQLQuery query) {
            StoreContext context = query.getStore().getContext();
            context.getBroker().assertActiveTransaction();
            context.beginStore();
            ISpaceProxy space = (ISpaceProxy)query.getStore().getConfiguration().getSpace();
            Object routing = this._executorMetaDataProvider.findRouting(task);
            try {
                Object spaceTask = task instanceof DistributedTask ? new InternalDistributedSpaceTaskWrapper((DistributedTask)task) : new InternalSpaceTaskWrapper(task, routing);
                AsyncFuture future = space.execute((SpaceTask)spaceTask, routing, query.getStore().getCurrentTransaction(), null);
                Object taskResult = future.get();
                LinkedList<Object> resultList = new LinkedList<Object>();
                resultList.add(taskResult);
                return new ListResultObjectProvider(resultList);
            }
            catch (Exception e) {
                throw new GeneralException((Throwable)e);
            }
        }

        public String[] getDataStoreActions(StoreQuery q, Object[] params, StoreQuery.Range range) {
            return new String[]{q.getContext().getQueryString()};
        }

        public boolean isPacking(StoreQuery q) {
            return q.getContext().getCandidateType() == null;
        }

        public Object[] toParameterArray(StoreQuery q, Map userParams) {
            if (userParams == null || userParams.isEmpty()) {
                return StoreQuery.EMPTY_OBJECTS;
            }
            String sql = q.getContext().getQueryString();
            ArrayList<Integer> paramOrder = new ArrayList<Integer>();
            try {
                sql = StoreManagerSQLQuery.substituteParams(sql, paramOrder);
            }
            catch (IOException ex) {
                throw new UserException(ex.getLocalizedMessage());
            }
            Object[] result = new Object[paramOrder.size()];
            int idx = 0;
            for (Integer key : paramOrder) {
                if (!userParams.containsKey(key)) {
                    throw new UserException("Missing parameter " + key + " in " + sql);
                }
                result[idx++] = userParams.get(key);
            }
            q.getContext().getQuery().setQuery((Object)sql);
            return result;
        }
    }
}

