/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jpa.openjpa.query;

import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.meta.ClassMetaData;
import org.openspaces.jpa.openjpa.query.ExpressionNode;
import org.openspaces.jpa.openjpa.query.FieldPathNode;

public class AggregationFunction
implements Value,
ExpressionNode {
    private static final long serialVersionUID = 1L;
    private FieldPathNode _path;
    private AggregationType _aggregationType;

    public AggregationFunction(Value path, AggregationType type) {
        this._path = (FieldPathNode)path;
        this._aggregationType = type;
    }

    public Class getType() {
        return Long.TYPE;
    }

    public void setImplicitType(Class type) {
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isAggregate() {
        return true;
    }

    public boolean isXPath() {
        return false;
    }

    public ClassMetaData getMetaData() {
        return null;
    }

    public void setMetaData(ClassMetaData meta) {
    }

    public void acceptVisit(ExpressionVisitor visitor) {
        visitor.enter((Value)this);
    }

    public String getAlias() {
        return null;
    }

    public void setAlias(String alias) {
    }

    public Value getSelectAs() {
        return null;
    }

    public Path getPath() {
        return this._path;
    }

    public String getName() {
        switch (this._aggregationType) {
            case COUNT: {
                return "COUNT";
            }
            case AVERAGE: {
                return "AVG";
            }
            case SUM: {
                return "SUM";
            }
            case MINIMUM: {
                return "MIN";
            }
            case MAXIMUM: {
                return "MAX";
            }
        }
        return "";
    }

    public String toString() {
        return this.getName();
    }

    public AggregationType getAggregationType() {
        return this._aggregationType;
    }

    @Override
    public void appendSql(StringBuilder sql) {
        sql.append(this.getName());
        sql.append("(");
        String path = this.getPath().getName();
        if (path.length() == 0) {
            path = "*";
        }
        sql.append(path);
        sql.append(")");
    }

    @Override
    public ExpressionNode.NodeType getNodeType() {
        return ExpressionNode.NodeType.AGGREGATION_FUNCTION;
    }

    public static enum AggregationType {
        COUNT,
        AVERAGE,
        MINIMUM,
        MAXIMUM,
        SUM;

    }
}

