/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jpa.openjpa.query;

import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.apache.openjpa.kernel.exps.Value;
import org.openspaces.jpa.openjpa.query.ExpressionNode;

public class BinaryExpression
implements Expression,
ExpressionNode {
    private static final long serialVersionUID = 1L;
    private ExpressionNode _node1;
    private ExpressionNode _node2;
    private ExpressionType _expressionType;

    public BinaryExpression(Value value1, Value value2, ExpressionType expressionType) {
        this._node1 = (ExpressionNode)value1;
        this._node2 = (ExpressionNode)value2;
        this._expressionType = expressionType;
    }

    @Override
    public void appendSql(StringBuilder sql) {
        this._node1.appendSql(sql);
        sql.append(this.toString());
        this._node2.appendSql(sql);
    }

    public void acceptVisit(ExpressionVisitor visitor) {
    }

    public String toString() {
        switch (this._expressionType) {
            case EQUAL: {
                return this._node2.getNodeType() == ExpressionNode.NodeType.NULL_VALUE ? " IS " : " = ";
            }
            case NOT_EQUAL: {
                return this._node2.getNodeType() == ExpressionNode.NodeType.NULL_VALUE ? " IS NOT " : " <> ";
            }
            case GREATER_THAN: {
                return " > ";
            }
            case LESS_THAN: {
                return " < ";
            }
            case GREATER_THAN_OR_EQUAL: {
                return " >= ";
            }
            case LESS_THAN_OR_EQUAL: {
                return " <= ";
            }
        }
        return "";
    }

    @Override
    public ExpressionNode.NodeType getNodeType() {
        return ExpressionNode.NodeType.BINARY_EXPRESSION;
    }

    public static enum ExpressionType {
        EQUAL,
        NOT_EQUAL,
        GREATER_THAN,
        LESS_THAN,
        GREATER_THAN_OR_EQUAL,
        LESS_THAN_OR_EQUAL,
        AND,
        OR;

    }
}

