/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jpa.openjpa.query;

import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionVisitor;
import org.openspaces.jpa.openjpa.query.BinaryExpression;
import org.openspaces.jpa.openjpa.query.ExpressionNode;

public class LogicalExpression
implements Expression,
ExpressionNode {
    private static final long serialVersionUID = 1L;
    private ExpressionNode _expression1;
    private ExpressionNode _expression2;
    private BinaryExpression.ExpressionType _expressionType;

    public LogicalExpression(Expression expression1, Expression expression2, BinaryExpression.ExpressionType expressionType) {
        this._expression1 = (ExpressionNode)expression1;
        this._expression2 = (ExpressionNode)expression2;
        this._expressionType = expressionType;
    }

    @Override
    public void appendSql(StringBuilder sql) {
        boolean paren;
        boolean bl = paren = this._expressionType == BinaryExpression.ExpressionType.OR;
        if (paren) {
            sql.append("(");
        }
        this._expression1.appendSql(sql);
        if (this._expression2.getNodeType() != ExpressionNode.NodeType.VARIABLE_BINDING || this._expressionType != BinaryExpression.ExpressionType.AND) {
            sql.append(this.toString());
            this._expression2.appendSql(sql);
        }
        if (paren) {
            sql.append(")");
        }
    }

    public void acceptVisit(ExpressionVisitor visitor) {
    }

    public String toString() {
        switch (this._expressionType) {
            case AND: {
                return " AND ";
            }
            case OR: {
                return " OR ";
            }
        }
        return "";
    }

    @Override
    public ExpressionNode.NodeType getNodeType() {
        return ExpressionNode.NodeType.LOGICAL_EXPRESSION;
    }
}

