/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jpa.openjpa.query;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.kernel.exps.AggregateListener;
import org.apache.openjpa.kernel.exps.Arguments;
import org.apache.openjpa.kernel.exps.Expression;
import org.apache.openjpa.kernel.exps.ExpressionFactory;
import org.apache.openjpa.kernel.exps.FilterListener;
import org.apache.openjpa.kernel.exps.Literal;
import org.apache.openjpa.kernel.exps.Parameter;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.kernel.exps.Subquery;
import org.apache.openjpa.kernel.exps.Value;
import org.apache.openjpa.meta.ClassMetaData;
import org.openspaces.jpa.StoreManager;
import org.openspaces.jpa.openjpa.query.AggregationFunction;
import org.openspaces.jpa.openjpa.query.BinaryExpression;
import org.openspaces.jpa.openjpa.query.BindVariableExpression;
import org.openspaces.jpa.openjpa.query.ContainsExpression;
import org.openspaces.jpa.openjpa.query.EmptyExpression;
import org.openspaces.jpa.openjpa.query.FieldPathNode;
import org.openspaces.jpa.openjpa.query.InnerQuery;
import org.openspaces.jpa.openjpa.query.LiteralValueNode;
import org.openspaces.jpa.openjpa.query.LogicalExpression;
import org.openspaces.jpa.openjpa.query.MatchesExpression;
import org.openspaces.jpa.openjpa.query.NotMatchesExpression;
import org.openspaces.jpa.openjpa.query.NullValueNode;
import org.openspaces.jpa.openjpa.query.ParameterNode;
import org.openspaces.jpa.openjpa.query.Variable;

public class QueryExpressionFactory
implements ExpressionFactory {
    private final Map<String, String> _joinBindings = new HashMap<String, String>();
    private StoreManager _store;

    public QueryExpressionFactory(StoreManager store) {
        this._store = store;
    }

    public Expression emptyExpression() {
        return new EmptyExpression();
    }

    public Expression asExpression(Value bool) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Expression equal(Value v1, Value v2) {
        return new BinaryExpression(v1, v2, BinaryExpression.ExpressionType.EQUAL);
    }

    public Expression notEqual(Value v1, Value v2) {
        return new BinaryExpression(v1, v2, BinaryExpression.ExpressionType.NOT_EQUAL);
    }

    public Expression lessThan(Value v1, Value v2) {
        return new BinaryExpression(v1, v2, BinaryExpression.ExpressionType.LESS_THAN);
    }

    public Expression greaterThan(Value v1, Value v2) {
        return new BinaryExpression(v1, v2, BinaryExpression.ExpressionType.GREATER_THAN);
    }

    public Expression lessThanEqual(Value v1, Value v2) {
        return new BinaryExpression(v1, v2, BinaryExpression.ExpressionType.LESS_THAN_OR_EQUAL);
    }

    public Expression greaterThanEqual(Value v1, Value v2) {
        return new BinaryExpression(v1, v2, BinaryExpression.ExpressionType.GREATER_THAN_OR_EQUAL);
    }

    public Expression isEmpty(Value target) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Expression isNotEmpty(Value target) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Expression contains(Value fieldPath, Value value) {
        return new ContainsExpression(fieldPath, value);
    }

    public Expression containsKey(Value map, Value arg) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Expression containsValue(Value map, Value arg) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value getMapValue(Value map, Value arg) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Expression isInstance(Value obj, Class c) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Expression and(Expression exp1, Expression exp2) {
        return new LogicalExpression(exp1, exp2, BinaryExpression.ExpressionType.AND);
    }

    public Expression or(Expression exp1, Expression exp2) {
        return new LogicalExpression(exp1, exp2, BinaryExpression.ExpressionType.OR);
    }

    public Expression not(Expression exp) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Expression bindVariable(Value var, Value coll) {
        this._joinBindings.put(var.getName(), coll.getName());
        return new BindVariableExpression();
    }

    public Expression bindKeyVariable(Value var, Value map) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Expression bindValueVariable(Value var, Value map) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Expression endsWith(Value str1, Value str2) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Expression matches(Value str, Value regexp, String single, String multi, String escape) {
        if (escape != null) {
            throw new IllegalArgumentException("JPQL ESCAPE keyword is not supported.");
        }
        return new MatchesExpression(str, regexp);
    }

    public Expression notMatches(Value str, Value regexp, String single, String multi, String escape) {
        if (escape != null) {
            throw new IllegalArgumentException("JPQL ESCAPE keyword is not supported.");
        }
        return new NotMatchesExpression(str, regexp);
    }

    public Expression startsWith(Value str1, Value str2) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value stringLength(Value str) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value trim(Value str, Value trimChar, Boolean where) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Subquery newSubquery(ClassMetaData candidate, boolean subs, String alias) {
        return new InnerQuery(candidate);
    }

    public Path newPath() {
        return new FieldPathNode();
    }

    public Path newPath(Value val) {
        FieldPathNode fieldPathNode = new FieldPathNode();
        String binding = this._joinBindings.get(val.getName());
        if (binding != null) {
            fieldPathNode.setJoinedFieldName(binding);
            int classRelationStatus = this._store.getClassRelationStatus(val.getMetaData().getDescribedType());
            if (classRelationStatus == 2) {
                fieldPathNode.setCollection(true);
            }
        }
        return fieldPathNode;
    }

    public Literal newLiteral(Object val, int parseType) {
        return new LiteralValueNode(val, parseType);
    }

    public Value getThis() {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value getNull() {
        return new NullValueNode();
    }

    public <T extends Date> Value getCurrentDate(Class<T> dateType) {
        throw new RuntimeException("Unsupported operation.");
    }

    public <T extends Date> Value getCurrentTime(Class<T> timeType) {
        throw new RuntimeException("Unsupported operation.");
    }

    public <T extends Date> Value getCurrentTimestamp(Class<T> timestampType) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Parameter newParameter(Object name, Class type) {
        return new ParameterNode(type);
    }

    public Parameter newCollectionValuedParameter(Object name, Class type) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value newExtension(FilterListener listener, Value target, Value args) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value newAggregate(AggregateListener listener, Value args) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Arguments newArgumentList(Value arg1, Value arg2) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Arguments newArgumentList(Value ... values) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value newUnboundVariable(String name, Class type) {
        return this.newBoundVariable(name, type);
    }

    public Value newBoundVariable(String name, Class type) {
        return new Variable(name, type);
    }

    public Value cast(Value obj, Class cls) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value add(Value num1, Value num2) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value subtract(Value num1, Value num2) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value multiply(Value num1, Value num2) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value divide(Value num1, Value num2) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value mod(Value num1, Value num2) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value abs(Value num) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value indexOf(Value str, Value args) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value concat(Value str, Value args) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value sqrt(Value num) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value substring(Value str, Value args) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value toUpperCase(Value str) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value toLowerCase(Value str) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value avg(Value num) {
        return new AggregationFunction(num, AggregationFunction.AggregationType.AVERAGE);
    }

    public Value count(Value obj) {
        return new AggregationFunction(obj, AggregationFunction.AggregationType.COUNT);
    }

    public Value max(Value num) {
        return new AggregationFunction(num, AggregationFunction.AggregationType.MAXIMUM);
    }

    public Value min(Value num) {
        return new AggregationFunction(num, AggregationFunction.AggregationType.MINIMUM);
    }

    public Value sum(Value num) {
        return new AggregationFunction(num, AggregationFunction.AggregationType.SUM);
    }

    public Value any(Value target) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value all(Value target) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value size(Value target) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value index(Value target) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value type(Value target) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value mapEntry(Value key, Value val) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value mapKey(Value key, Value val) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value getKey(Value val) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value distinct(Value obj) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value getObjectId(Value val) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value simpleCaseExpression(Value caseOperand, Expression[] exp, Value val) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value generalCaseExpression(Expression[] exp, Value val) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Expression whenCondition(Expression exp, Value val) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Expression whenScalar(Value val1, Value val2) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value coalesceExpression(Value[] val) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value nullIfExpression(Value val1, Value val2) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Literal newTypeLiteral(Object val, int parseType) {
        throw new RuntimeException("Unsupported operation.");
    }

    public Value newFunction(String functionName, Class<?> resultType, Value ... args) {
        throw new RuntimeException("Unsupported operation.");
    }

    public boolean isVerticalType(Value val) {
        throw new RuntimeException("Unsupported operation.");
    }
}

