/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jpa.openjpa.query.executor;

import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.openspaces.jpa.StoreManager;
import org.openspaces.jpa.openjpa.query.ExpressionNode;
import org.openspaces.jpa.openjpa.query.executor.JpaQueryExecutor;

abstract class AbstractJpaQueryExecutor
implements JpaQueryExecutor {
    protected QueryExpressions _expression;
    protected ClassMetaData _classMetaData;
    protected Object[] _parameters;
    protected StringBuilder _sql;

    protected AbstractJpaQueryExecutor(QueryExpressions expression, ClassMetaData cm, Object[] parameters) {
        this._expression = expression;
        this._classMetaData = cm;
        this._parameters = parameters;
        this.build();
    }

    @Override
    public abstract ResultObjectProvider execute(StoreManager var1) throws Exception;

    protected void build() {
        this._sql = new StringBuilder();
        this.appendWhereSql();
        this.appendGroupBySql();
        this.appendOrderBySql();
    }

    protected void appendWhereSql() {
        ((ExpressionNode)this._expression.filter).appendSql(this._sql);
    }

    protected void appendOrderBySql() {
        if (this._expression.ordering.length > 0) {
            this._sql.append(" ORDER BY ");
            int i = 0;
            while (i < this._expression.ordering.length) {
                this._sql.append(this._expression.ordering[i].getName());
                this._sql.append(this._expression.ascending[i] ? " asc" : " desc");
                if (++i == this._expression.ordering.length) continue;
                this._sql.append(", ");
            }
        }
    }

    protected void appendGroupBySql() {
        if (this._expression.grouping.length > 0) {
            this._sql.append(" GROUP BY ");
            int i = 0;
            while (i < this._expression.grouping.length) {
                this._sql.append(this._expression.grouping[i].getName());
                if (++i == this._expression.grouping.length) continue;
                this._sql.append(", ");
            }
        }
    }

    @Override
    public StringBuilder getSqlBuffer() {
        return this._sql;
    }
}

