/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jpa.openjpa.query.executor;

import com.j_spaces.jdbc.driver.GConnection;
import com.j_spaces.jdbc.driver.GResultSet;
import java.sql.PreparedStatement;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.openspaces.jpa.StoreManager;
import org.openspaces.jpa.openjpa.query.ExpressionNode;
import org.openspaces.jpa.openjpa.query.SpaceProjectionResultObjectProvider;
import org.openspaces.jpa.openjpa.query.executor.AbstractJpaQueryExecutor;

public class JpaJdbcQueryExecutor
extends AbstractJpaQueryExecutor {
    public JpaJdbcQueryExecutor(QueryExpressions expression, ClassMetaData cm, Object[] parameters) {
        super(expression, cm, parameters);
    }

    @Override
    public ResultObjectProvider execute(StoreManager store) throws Exception {
        GConnection conn = store.getJdbcConnection();
        if (store.getCurrentTransaction() == null) {
            conn.setAutoCommit(true);
        } else {
            conn.setAutoCommit(false);
            conn.setTransaction(store.getCurrentTransaction());
        }
        PreparedStatement pstmt = conn.prepareStatement(this._sql.toString());
        for (int i = 0; i < this._parameters.length; ++i) {
            pstmt.setObject(i + 1, this._parameters[i]);
        }
        GResultSet rs = (GResultSet)pstmt.executeQuery();
        return new SpaceProjectionResultObjectProvider(rs.getResult().getFieldValues());
    }

    @Override
    protected void build() {
        this._sql = new StringBuilder();
        this.appendSelectFromSql();
        this.appendWhereSql();
        this.appendGroupBySql();
        this.appendOrderBySql();
    }

    @Override
    protected void appendWhereSql() {
        ExpressionNode node = (ExpressionNode)this._expression.filter;
        if (node.getNodeType() != ExpressionNode.NodeType.EMPTY_EXPRESSION) {
            this._sql.append("WHERE ");
            super.appendWhereSql();
        }
    }

    protected void appendSelectFromSql() {
        this._sql.append("SELECT ");
        for (int i = 0; i < this._expression.projections.length; ++i) {
            ExpressionNode node = (ExpressionNode)this._expression.projections[i];
            node.appendSql(this._sql);
            if (i + 1 == this._expression.projections.length) {
                this._sql.append(" ");
                continue;
            }
            this._sql.append(", ");
        }
        this._sql.append("FROM ");
        this._sql.append(this._classMetaData.getDescribedType().getName());
        this._sql.append(" ");
    }
}

