/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.jpa.openjpa.query.executor;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.client.SQLQuery;
import org.apache.openjpa.kernel.exps.QueryExpressions;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.meta.ClassMetaData;
import org.openspaces.jpa.StoreManager;
import org.openspaces.jpa.openjpa.query.SpaceResultObjectProvider;
import org.openspaces.jpa.openjpa.query.executor.AbstractJpaQueryExecutor;

class JpaSqlQueryExecutor
extends AbstractJpaQueryExecutor {
    protected SQLQuery<Object> _sqlQuery;

    public JpaSqlQueryExecutor(QueryExpressions expression, ClassMetaData cm, Object[] parameters) {
        super(expression, cm, parameters);
    }

    @Override
    public ResultObjectProvider execute(StoreManager store) throws Exception {
        ISpaceProxy proxy = (ISpaceProxy)store.getConfiguration().getSpace();
        Object[] result = proxy.readMultiple(this._sqlQuery, store.getCurrentTransaction(), Integer.MAX_VALUE);
        Object[] entries = new IEntryPacket[result.length];
        for (int i = 0; i < result.length; ++i) {
            entries[i] = proxy.getDirectProxy().getTypeManager().getEntryPacketFromObject(result[i], ObjectType.POJO);
        }
        return new SpaceResultObjectProvider(this._classMetaData, entries, store);
    }

    @Override
    protected void build() {
        super.build();
        this._sqlQuery = new SQLQuery(this._classMetaData.getDescribedType().getName(), this._sql.toString());
        for (int i = 0; i < this._parameters.length; ++i) {
            this._sqlQuery.setParameter(i + 1, this._parameters[i]);
        }
    }
}

