/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout;

import com.jgraph.algebra.JGraphAlgebra;
import com.jgraph.algebra.JGraphUnionFind;
import com.jgraph.algebra.cost.JGraphCostFunction;
import com.jgraph.algebra.cost.JGraphDistanceCostFunction;
import java.awt.Dimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public class JGraphFacade {
    protected boolean ignoresHiddenCells = true;
    protected boolean ignoresUnconnectedCells = true;
    protected boolean ignoresCellsInGroups = false;
    protected boolean directed;
    protected boolean edgePromotion = true;
    protected transient JGraph graph = null;
    protected transient GraphLayoutCache graphLayoutCache = null;
    protected transient Hashtable attributes = new Hashtable();
    protected transient Comparator order = new DefaultComparator();
    protected transient JGraphCostFunction distanceCostFunction;
    protected transient JGraphAlgebra algebra;
    protected transient List roots = new ArrayList();

    public JGraphFacade(JGraph jGraph) {
        this(jGraph, null);
    }

    public JGraphFacade(JGraph jGraph, Object[] objectArray) {
        this(jGraph, objectArray, true, false, true, true);
    }

    public JGraphFacade(JGraph jGraph, Object[] objectArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this(jGraph, objectArray, bl, bl2, bl3, bl4, (JGraphCostFunction)new JGraphDistanceCostFunction((CellMapper)jGraph.getGraphLayoutCache()), JGraphAlgebra.getSharedInstance());
    }

    public JGraphFacade(JGraph jGraph, Object[] objectArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, JGraphCostFunction jGraphCostFunction, JGraphAlgebra jGraphAlgebra) {
        this.graph = jGraph;
        this.ignoresHiddenCells = bl;
        this.ignoresCellsInGroups = bl2;
        this.ignoresUnconnectedCells = bl3;
        this.directed = bl4;
        this.distanceCostFunction = jGraphCostFunction;
        this.algebra = jGraphAlgebra;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.isVertex(objectArray[i])) continue;
                this.roots.add(objectArray[i]);
            }
        }
    }

    public JGraphFacade(GraphLayoutCache graphLayoutCache, Object[] objectArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, JGraphCostFunction jGraphCostFunction, JGraphAlgebra jGraphAlgebra) {
        this.graphLayoutCache = graphLayoutCache;
        this.ignoresHiddenCells = bl;
        this.ignoresCellsInGroups = bl2;
        this.ignoresUnconnectedCells = bl3;
        this.directed = bl4;
        this.distanceCostFunction = jGraphCostFunction;
        this.algebra = jGraphAlgebra;
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.isVertex(objectArray[i])) continue;
                this.roots.add(objectArray[i]);
            }
        }
    }

    public void resetControlPoints() {
        Iterator iterator = this.getEdges().iterator();
        while (iterator.hasNext()) {
            Map map;
            List list;
            Object e = iterator.next();
            if (!this.isMoveable(e) || (list = GraphConstants.getPoints((Map)(map = this.getAttributes(e)))) == null || list.size() <= 2) continue;
            ArrayList arrayList = new ArrayList();
            arrayList.add(list.get(0));
            arrayList.add(list.get(list.size() - 1));
            GraphConstants.setPoints((Map)map, arrayList);
        }
    }

    public boolean isVertex(Object object) {
        GraphModel graphModel = this.graph.getModel();
        if (!graphModel.isEdge(object) && !graphModel.isPort(object)) {
            CellView cellView;
            if (this.ignoresUnconnectedCells) {
                cellView = this.getEdges(object);
                if (cellView == null || ((Object[])cellView).length == 0) {
                    return false;
                }
                if (this.ignoresHiddenCells) {
                    boolean bl = false;
                    for (int i = 0; i < ((CellView)cellView).length; ++i) {
                        bl = bl || this.graph.getGraphLayoutCache().isVisible((Object)cellView[i]);
                    }
                    if (!bl) {
                        return false;
                    }
                }
            }
            if (this.ignoresHiddenCells) {
                cellView = this.graph.getGraphLayoutCache().getMapping(object, false);
                if (cellView != null) {
                    if (this.ignoresCellsInGroups) {
                        return cellView.isLeaf() && cellView.getParentView() == null;
                    }
                    return cellView.isLeaf();
                }
                return false;
            }
            if (this.ignoresCellsInGroups && graphModel.getParent(object) != null) {
                return false;
            }
            for (int i = 0; i < graphModel.getChildCount(object); ++i) {
                if (graphModel.isPort(graphModel.getChild(object, i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isEdge(Object object) {
        GraphModel graphModel = this.graph.getModel();
        if (graphModel.getSource(object) == null || graphModel.getTarget(object) == null) {
            return false;
        }
        if (this.ignoresHiddenCells) {
            if (!graphModel.isEdge(object)) {
                return false;
            }
            CellView cellView = this.graph.getGraphLayoutCache().getMapping(object, false);
            if (cellView != null) {
                if (this.ignoresCellsInGroups) {
                    return cellView.isLeaf() && cellView.getParentView() == null;
                }
                return cellView.isLeaf();
            }
            return false;
        }
        if (this.ignoresCellsInGroups && graphModel.getParent(object) != null) {
            return false;
        }
        return graphModel.isEdge(object);
    }

    public List getNeighbours(Object object, boolean bl) {
        return this.getNeighbours(object, null, bl);
    }

    public List getNeighbours(Object object, Set set, boolean bl) {
        GraphLayoutCache graphLayoutCache = this.graph.getGraphLayoutCache();
        GraphModel graphModel = this.graph.getModel();
        LinkedList linkedList = new LinkedList();
        if (graphLayoutCache != null && graphLayoutCache.isPartial() && this.edgePromotion) {
            HashSet<Object> hashSet;
            int n = graphModel.getChildCount(object);
            HashSet<Object> hashSet2 = new HashSet<Object>();
            hashSet2.add(object);
            for (int i = 0; i < n; ++i) {
                hashSet = graphModel.getChild(object, i);
                if (graphModel.isEdge(hashSet) || graphModel.isPort(hashSet) || graphLayoutCache.isVisible(hashSet)) continue;
                hashSet2.add(hashSet);
            }
            Iterator iterator = hashSet2.iterator();
            hashSet = new HashSet<Object>();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                List list = this.graph.getGraphLayoutCache().getNeighbours(e, set, this.directed, false);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    if (hashSet2.contains(e2)) continue;
                    if (graphLayoutCache.isVisible(e2)) {
                        hashSet.add(e2);
                        continue;
                    }
                    hashSet.add(graphModel.getParent(e2));
                }
            }
            linkedList.addAll(hashSet);
        } else {
            List list = this.graph.getGraphLayoutCache().getNeighbours(object, set, this.directed, this.ignoresHiddenCells);
            linkedList.addAll(list);
        }
        if (bl && this.order != null) {
            Collections.sort(linkedList, this.order);
        }
        return linkedList;
    }

    public double getLength(Object object) {
        return this.distanceCostFunction.getCost(object);
    }

    public double getDistance(Object object, Object object2, int n) {
        Object[] objectArray = this.getPath(object, object2, n, this.distanceCostFunction);
        return this.algebra.sum(objectArray, this.distanceCostFunction);
    }

    public Object[] getPath(Object object, Object object2, int n, JGraphCostFunction jGraphCostFunction) {
        return this.algebra.getShortestPath(this.graph.getModel(), object, object2, jGraphCostFunction, n, this.isDirected());
    }

    public JGraphUnionFind getConnectionComponents(Object[] objectArray, Object[] objectArray2) {
        return this.algebra.getConnectionComponents(this.graph.getModel(), objectArray, objectArray2);
    }

    public Object[] getMinimumSpanningTree(Object[] objectArray, JGraphCostFunction jGraphCostFunction) {
        return this.algebra.getMinimumSpanningTree(this.graph.getModel(), objectArray, jGraphCostFunction, this.directed);
    }

    public Collection getVertices() {
        return this.getCells(this.getAll(), false, false);
    }

    public Collection getEdges() {
        return this.getCells(this.getAll(), true, false);
    }

    public Object[] getEdges(Object object) {
        return DefaultGraphModel.getEdges((GraphModel)this.graph.getModel(), (Object[])new Object[]{object}).toArray();
    }

    public Object[] getEdges(Object object, boolean bl) {
        return DefaultGraphModel.getEdges((GraphModel)this.graph.getModel(), (Object)object, (boolean)bl);
    }

    public Object getSource(Object object) {
        GraphLayoutCache graphLayoutCache = this.graph.getGraphLayoutCache();
        GraphModel graphModel = this.graph.getModel();
        if (graphLayoutCache != null && graphLayoutCache.isPartial() && this.edgePromotion) {
            Object object2 = DefaultGraphModel.getSourceVertex((GraphModel)graphModel, (Object)object);
            if (graphLayoutCache.isVisible(object2)) {
                return object2;
            }
            return graphModel.getParent(object2);
        }
        return DefaultGraphModel.getSourceVertex((GraphModel)graphModel, (Object)object);
    }

    public Object getTarget(Object object) {
        GraphLayoutCache graphLayoutCache = this.graph.getGraphLayoutCache();
        GraphModel graphModel = this.graph.getModel();
        if (graphLayoutCache != null && graphLayoutCache.isPartial() && this.edgePromotion) {
            Object object2 = DefaultGraphModel.getTargetVertex((GraphModel)graphModel, (Object)object);
            if (graphLayoutCache.isVisible(object2)) {
                return object2;
            }
            return graphModel.getParent(object2);
        }
        return DefaultGraphModel.getTargetVertex((GraphModel)graphModel, (Object)object);
    }

    protected List getAll() {
        return DefaultGraphModel.getDescendants((GraphModel)this.graph.getModel(), (Object[])this.graph.getRoots());
    }

    protected Collection getCells(Collection collection, boolean bl, boolean bl2) {
        AbstractSet abstractSet = null;
        abstractSet = bl2 ? new TreeSet(this.order) : new LinkedHashSet();
        Iterator iterator = collection.iterator();
        GraphModel graphModel = this.graph.getModel();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (bl && this.isEdge(e) && graphModel.getSource(e) != null && graphModel.getTarget(e) != null) {
                abstractSet.add(e);
            }
            if (bl || !this.isVertex(e)) continue;
            abstractSet.add(e);
        }
        return abstractSet;
    }

    public Collection getVertices(Collection collection, boolean bl) {
        return this.getCells(collection, false, bl);
    }

    public List getOutgoingEdges(Object object, Set set, boolean bl, boolean bl2) {
        return this.graph.getGraphLayoutCache().getOutgoingEdges(object, set, bl, bl2);
    }

    public List getIncomingEdges(Object object, Set set, boolean bl, boolean bl2) {
        GraphLayoutCache graphLayoutCache = this.graph.getGraphLayoutCache();
        GraphModel graphModel = this.graph.getModel();
        LinkedList linkedList = new LinkedList();
        if (graphLayoutCache != null && graphLayoutCache.isPartial() && this.edgePromotion) {
            HashSet<Object> hashSet;
            int n = graphModel.getChildCount(object);
            HashSet<Object> hashSet2 = new HashSet<Object>();
            hashSet2.add(object);
            for (int i = 0; i < n; ++i) {
                hashSet = graphModel.getChild(object, i);
                if (graphModel.isEdge(hashSet) || graphModel.isPort(hashSet) || graphLayoutCache.isVisible(hashSet)) continue;
                hashSet2.add(hashSet);
            }
            Iterator iterator = hashSet2.iterator();
            hashSet = new HashSet<Object>();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                List list = graphLayoutCache.getIncomingEdges(e, set, false, false);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Object e2 = iterator2.next();
                    Object object2 = graphModel.getSource(e2);
                    Object object3 = null;
                    object3 = graphModel.isPort(object2) ? graphModel.getParent(object2) : object2;
                    if (hashSet2.contains(object3)) continue;
                    if (graphLayoutCache.isVisible(object3)) {
                        hashSet.add(object3);
                        continue;
                    }
                    hashSet.add(graphModel.getParent(object3));
                }
            }
            linkedList.addAll(hashSet);
        } else {
            List list = this.graph.getGraphLayoutCache().getIncomingEdges(object, set, bl, bl2);
            linkedList.addAll(list);
        }
        return linkedList;
    }

    public Map createNestedMap(Map map) {
        Map map2 = this.createNestedMap(false, false);
        return GraphConstants.merge((Map)map, (Map)map2);
    }

    public Map createNestedMap(boolean bl, boolean bl2) {
        return this.createNestedMap(bl, bl2 ? new Point2D.Double(0.0, 0.0) : null);
    }

    public Map createNestedMap(boolean bl, Point2D point2D) {
        Rectangle2D rectangle2D = this.getCellBounds();
        if (rectangle2D == null) {
            return null;
        }
        if (point2D != null) {
            this.translateCells(this.getAttributes().keySet(), -rectangle2D.getX() + point2D.getX(), -rectangle2D.getY() + point2D.getY());
        } else if (!this.graph.isMoveBelowZero() && (rectangle2D.getX() < 0.0 || rectangle2D.getY() < 0.0)) {
            this.scale(this.getAttributes().keySet(), 1.0, 1.0, rectangle2D.getX() < 0.0 ? Math.abs(rectangle2D.getX()) : 0.0, rectangle2D.getY() < 0.0 ? Math.abs(rectangle2D.getY()) : 0.0);
        }
        Hashtable hashtable = new Hashtable();
        Iterator iterator = this.getAttributes().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            Hashtable hashtable2 = new Hashtable((Map)entry.getValue());
            if (!bl) {
                this.graph.snap(GraphConstants.getBounds(hashtable2));
            }
            hashtable.put(k, hashtable2);
        }
        return hashtable;
    }

    public double norm(Point2D point2D) {
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = Math.sqrt(d * d + d2 * d2);
        return d3;
    }

    public Hashtable getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Hashtable hashtable) {
        this.attributes = hashtable;
    }

    public Map getAttributes(Object object) {
        AttributeMap attributeMap = (AttributeMap)this.getAttributes().get(object);
        if (attributeMap == null) {
            CellView cellView = this.graph.getGraphLayoutCache().getMapping(object, false);
            if (cellView != null) {
                attributeMap = cellView.getAllAttributes();
            }
            if (attributeMap == null) {
                attributeMap = this.graph.getModel().getAttributes(object);
            }
            if (attributeMap != null) {
                attributeMap = (AttributeMap)attributeMap.clone();
                this.getAttributes().put(object, attributeMap);
            }
        }
        return attributeMap;
    }

    public boolean isMoveable(Object object) {
        return GraphConstants.isMoveable((Map)this.getAttributes(object));
    }

    public void setAttributes(Object object, Map map) {
        this.getAttributes().put(object, map);
    }

    public Rectangle2D getBounds(List list) {
        Rectangle2D rectangle2D = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Rectangle2D rectangle2D2 = this.getBounds(iterator.next());
            if (rectangle2D2 == null) continue;
            if (rectangle2D == null) {
                rectangle2D = (Rectangle2D)rectangle2D2.clone();
                continue;
            }
            Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
        }
        return rectangle2D;
    }

    public Rectangle2D getGraphBounds() {
        return GraphLayoutCache.getBounds((CellView[])this.graph.getGraphLayoutCache().getCellViews());
    }

    public Point2D getGraphOrigin() {
        Rectangle2D rectangle2D = this.graph.getCellBounds(this.graph.getRoots());
        return new Point2D.Double(Math.max(0.0, rectangle2D.getX()), Math.max(0.0, rectangle2D.getY()));
    }

    public Rectangle2D getCellBounds() {
        Rectangle2D rectangle2D = null;
        Iterator iterator = this.getAttributes().values().iterator();
        while (iterator.hasNext()) {
            Rectangle2D rectangle2D2 = GraphConstants.getBounds((Map)((Map)iterator.next()));
            if (rectangle2D2 == null) continue;
            if (rectangle2D == null) {
                rectangle2D = (Rectangle2D)rectangle2D2.clone();
                continue;
            }
            Rectangle2D.union(rectangle2D, rectangle2D2, rectangle2D);
        }
        return rectangle2D;
    }

    public void translateCells(Collection collection, double d, double d2) {
        this.scale(collection, 1.0, 1.0, d, d2);
    }

    public void scale(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getCellBounds();
        double d = rectangle2D.getWidth() / rectangle2D2.getWidth();
        double d2 = rectangle2D.getHeight() / rectangle2D2.getHeight();
        double d3 = rectangle2D.getX() - rectangle2D2.getX();
        double d4 = rectangle2D.getY() - rectangle2D2.getY();
        this.scale(this.getAttributes().keySet(), d, d2, d3, d4);
    }

    public void scale(Collection collection, double d, double d2, double d3, double d4) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            List list;
            Object e = iterator.next();
            Point2D point2D = this.getLocation(e);
            if (point2D != null) {
                point2D.setLocation((point2D.getX() + d3) * d, (point2D.getY() + d4) * d2);
                this.setLocation(e, point2D.getX(), point2D.getY());
            }
            if (!this.isEdge(e) || (list = this.getPoints(e)) == null) continue;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                Object e2 = iterator2.next();
                if (!(e2 instanceof Point2D)) continue;
                Point2D point2D2 = (Point2D)e2;
                point2D2.setLocation((point2D2.getX() + d3) * d, (point2D2.getY() + d4) * d2);
            }
        }
    }

    public void randomize(Collection collection, int n, int n2) {
        Random random = new Random();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (n <= 0 || n2 <= 0) continue;
            int n3 = random.nextInt(n);
            int n4 = random.nextInt(n2);
            this.setLocation(iterator.next(), n3, n4);
        }
    }

    public void tilt(Collection collection, int n, int n2) {
        Random random = new Random();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n3 = random.nextInt(n);
            int n4 = random.nextInt(n2);
            this.translate(iterator.next(), n3, n4);
        }
    }

    public void circle(Collection collection) {
        Dimension dimension = this.getMaxSize(collection);
        double d = Math.max(dimension.width, dimension.height);
        Object[] objectArray = collection.toArray();
        int n = (int)Math.max((double)objectArray.length * d / Math.PI, 100.0);
        double d2 = Math.PI * 2 / (double)collection.size();
        for (int i = 0; i < objectArray.length; ++i) {
            this.setLocation(objectArray[i], (double)n + (double)n * Math.sin((double)i * d2), (double)n + (double)n * Math.cos((double)i * d2));
        }
    }

    public Rectangle2D getBounds(Object object) {
        Map map = this.getAttributes(object);
        return GraphConstants.getBounds((Map)map);
    }

    public void setBounds(Map map) {
        if (map != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Rectangle2D rectangle2D = GraphConstants.getBounds((Map)((Map)entry.getValue()));
                if (rectangle2D == null) continue;
                this.setBounds(entry.getKey(), (Rectangle2D)rectangle2D.clone());
            }
        }
    }

    public void setBounds(Object object, Rectangle2D rectangle2D) {
        Map map = this.getAttributes(object);
        GraphConstants.setBounds((Map)map, (Rectangle2D)rectangle2D);
    }

    public double[][] getLocations(Object[] objectArray) {
        double[][] dArray = new double[objectArray.length][2];
        for (int i = 0; i < objectArray.length; ++i) {
            Point2D point2D = this.getLocation(objectArray[i]);
            dArray[i][0] = point2D.getX();
            dArray[i][1] = point2D.getY();
        }
        return dArray;
    }

    public double[][] getBounds(Object[] objectArray) {
        double[][] dArray = new double[objectArray.length][4];
        for (int i = 0; i < objectArray.length; ++i) {
            Rectangle2D rectangle2D = this.getBounds(objectArray[i]);
            dArray[i][0] = rectangle2D.getX();
            dArray[i][1] = rectangle2D.getY();
            dArray[i][2] = rectangle2D.getWidth();
            dArray[i][3] = rectangle2D.getHeight();
        }
        return dArray;
    }

    public Point2D getLocation(Object object) {
        Rectangle2D rectangle2D = this.getBounds(object);
        if (rectangle2D != null) {
            return new Point2D.Double(rectangle2D.getX(), rectangle2D.getY());
        }
        return null;
    }

    public void setLocations(Object[] objectArray, double[][] dArray) {
        if (objectArray != null && dArray != null && objectArray.length == dArray.length) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.setLocation(objectArray[i], dArray[i][0], dArray[i][1]);
            }
        }
    }

    public void setBounds(Object[] objectArray, double[][] dArray) {
        if (objectArray != null && dArray != null && objectArray.length == dArray.length) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.setBounds(objectArray[i], new Rectangle2D.Double(dArray[i][0], dArray[i][1], dArray[i][2], dArray[i][3]));
            }
        }
    }

    public void setLocation(Object object, double d, double d2) {
        Rectangle2D rectangle2D = this.getBounds(object);
        if (this.isMoveable(object) && rectangle2D != null) {
            rectangle2D.setFrame(d, d2, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double(d, d2, 0.0, 0.0);
            this.setBounds(object, rectangle2D);
        }
    }

    public void translate(Object object, double d, double d2) {
        Rectangle2D rectangle2D = this.getBounds(object);
        if (this.isMoveable(object) && rectangle2D != null) {
            rectangle2D.setFrame(rectangle2D.getX() + d, rectangle2D.getY() + d2, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
    }

    public Dimension getMaxSize(Collection collection) {
        Dimension dimension = new Dimension(0, 0);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Dimension2D dimension2D = this.getSize(iterator.next());
            if (dimension2D == null) continue;
            dimension.setSize(Math.max(dimension.getWidth(), dimension2D.getWidth()), Math.max(dimension.getHeight(), dimension2D.getHeight()));
        }
        return dimension;
    }

    public void setSize(Object object, double d, double d2) {
        Rectangle2D rectangle2D = this.getBounds(object);
        rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY(), d, d2);
    }

    public Dimension2D getSize(Object object) {
        Rectangle2D rectangle2D = this.getBounds(object);
        return new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    public List getPoints(Object object) {
        Map map = this.getAttributes(object);
        return GraphConstants.getPoints((Map)map);
    }

    public void setPoints(Object object, List list) {
        Map map = this.getAttributes(object);
        GraphConstants.setPoints((Map)map, (List)list);
    }

    public void disableRouting(Object object) {
        Map map = this.getAttributes(object);
        GraphConstants.setRemoveAttributes((Map)map, (Object[])new Object[]{"routing"});
    }

    public Object[] getEdgesBetween(Object object, Object object2, boolean bl) {
        if (this.graph != null) {
            GraphLayoutCache graphLayoutCache = this.graph.getGraphLayoutCache();
            GraphModel graphModel = this.graph.getModel();
            if (graphLayoutCache != null && graphLayoutCache.isPartial() && this.edgePromotion) {
                Iterator iterator;
                HashSet<Object> hashSet;
                int n;
                int n2 = graphModel.getChildCount(object);
                HashSet<Object> hashSet2 = new HashSet<Object>();
                hashSet2.add(object);
                for (n = 0; n < n2; ++n) {
                    hashSet = graphModel.getChild(object, n);
                    if (graphModel.isEdge((Object)hashSet) || graphModel.isPort(hashSet) || graphLayoutCache.isVisible(hashSet)) continue;
                    hashSet2.add(hashSet);
                }
                n = graphModel.getChildCount(object2);
                hashSet = new HashSet<Object>();
                hashSet.add(object2);
                for (int i = 0; i < n; ++i) {
                    iterator = graphModel.getChild(object2, i);
                    if (graphModel.isEdge((Object)iterator) || graphModel.isPort(iterator) || graphLayoutCache.isVisible(iterator)) continue;
                    hashSet.add(iterator);
                }
                if (hashSet2.size() == 1 && hashSet.size() == 1) {
                    return DefaultGraphModel.getEdgesBetween((GraphModel)this.graph.getModel(), (Object)object, (Object)object2, (boolean)bl);
                }
                Object[] objectArray = null;
                iterator = hashSet2.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Iterator iterator2 = hashSet.iterator();
                    while (iterator2.hasNext()) {
                        Object e2 = iterator2.next();
                        Object[] objectArray2 = DefaultGraphModel.getEdgesBetween((GraphModel)graphModel, e, e2, (boolean)bl);
                        if (objectArray2.length <= 0) continue;
                        if (objectArray == null) {
                            objectArray = objectArray2;
                            continue;
                        }
                        Object[] objectArray3 = new Object[objectArray2.length + objectArray.length];
                        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
                        objectArray = objectArray3;
                    }
                }
                return objectArray;
            }
            return DefaultGraphModel.getEdgesBetween((GraphModel)graphModel, (Object)object, (Object)object2, (boolean)bl);
        }
        return null;
    }

    public int getRootCount() {
        return this.roots.size();
    }

    public Object getRootAt(int n) {
        return this.roots.get(n);
    }

    public boolean isRoot(Object object) {
        return this.roots.contains(object);
    }

    public List getRoots() {
        return this.roots;
    }

    public void setRoots(List list) {
        this.roots = list;
    }

    public boolean isDirected() {
        return this.directed;
    }

    public void setDirected(boolean bl) {
        this.directed = bl;
    }

    public Comparator getOrder() {
        return this.order;
    }

    public void setOrder(Comparator comparator) {
        this.order = comparator;
    }

    public boolean IsIgnoresCellsInGroups() {
        return this.ignoresCellsInGroups;
    }

    public void setIgnoresCellsInGroups(boolean bl) {
        this.ignoresCellsInGroups = bl;
    }

    public boolean isIgnoresHiddenCells() {
        return this.ignoresHiddenCells;
    }

    public void setIgnoresHiddenCells(boolean bl) {
        this.ignoresHiddenCells = bl;
    }

    public boolean isIgnoresUnconnectedCells() {
        return this.ignoresUnconnectedCells;
    }

    public void setIgnoresUnconnectedCells(boolean bl) {
        this.ignoresUnconnectedCells = bl;
    }

    public boolean isEdgePromotion() {
        return this.edgePromotion;
    }

    public void setEdgePromotion(boolean bl) {
        this.edgePromotion = bl;
    }

    public void dfs(Object object, CellVisitor cellVisitor) {
        if (this.isVertex(object)) {
            this.dfs(null, object, null, cellVisitor, new HashSet(), 0, 0);
        }
    }

    public void dfs(Object object, Object object2, Object object3, CellVisitor cellVisitor, Set set, int n, int n2) {
        if (object2 != null && !set.contains(object2)) {
            set.add(object2);
            cellVisitor.visit(object, object2, object3, n, n2, null);
            n2 = 0;
            Object var8_8 = null;
            Iterator iterator = this.getNeighbours(object2, set, true).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!this.isVertex(e) || this.isRoot(e)) continue;
                this.dfs(object2, e, var8_8, cellVisitor, set, n + 1, n2);
                var8_8 = e;
                ++n2;
            }
        }
    }

    public void dfs(Object object, Object object2, Object object3, CellVisitor cellVisitor, Set set, Set set2, int n, int n2) {
        if (object2 != null) {
            if (object != null) {
                set2.add(object);
            }
            cellVisitor.visit(object, object2, object3, n, n2, set2);
            if (!set.contains(object2)) {
                set.add(object2);
                n2 = 0;
                Object var9_9 = null;
                Iterator iterator = this.getNeighbours(object2, set, true).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!this.isVertex(e) || this.isRoot(e)) continue;
                    this.dfs(object2, e, var9_9, cellVisitor, set, new HashSet(set2), n + 1, n2);
                    var9_9 = e;
                    ++n2;
                }
            }
        }
    }

    public void bfs(Object object, CellVisitor cellVisitor) {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        Stack<Object> stack = new Stack<Object>();
        stack.push(object);
        HashSet<Object> hashSet = new HashSet<Object>();
        while (!stack.isEmpty()) {
            Object e = stack.pop();
            if (!hashSet.contains(e)) {
                hashSet.add(object);
                cellVisitor.visit(null, e, null, n3, 0, null);
                Iterator iterator = this.getNeighbours(e, hashSet, true).iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    if (hashSet.contains(e2)) continue;
                    stack.push(e2);
                    ++n2;
                }
            }
            --n;
            if (--n > 0) continue;
            n = n2;
            n2 = 0;
            ++n3;
        }
    }

    public void findTreeRoots() {
        GraphModel graphModel = this.graph.getModel();
        Object[] objectArray = this.graph.getGraphLayoutCache().getCells(false, true, false, false);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        Object object = null;
        for (int i = 0; i < objectArray.length; ++i) {
            int n2;
            int n3 = DefaultGraphModel.getEdges((GraphModel)graphModel, (Object)objectArray[i], (boolean)true).length;
            int n4 = DefaultGraphModel.getEdges((GraphModel)graphModel, (Object)objectArray[i], (boolean)false).length;
            if (n3 == 0 && n4 > 0) {
                arrayList.add(objectArray[i]);
            }
            if ((n2 = n4 - n3) < n) continue;
            object = objectArray[i];
            n = n2;
        }
        if (arrayList.isEmpty() && object != null) {
            arrayList.add(object);
        }
        this.roots = arrayList;
    }

    public class DefaultComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            GraphModel graphModel = JGraphFacade.this.graph.getModel();
            Object object3 = graphModel.getParent(object);
            Object object4 = graphModel.getParent(object2);
            int n = object3 == null ? graphModel.getIndexOfRoot(object) : graphModel.getIndexOfChild(object3, object);
            int n2 = object4 == null ? graphModel.getIndexOfRoot(object2) : graphModel.getIndexOfChild(object4, object2);
            return new Integer(n).compareTo(new Integer(n2));
        }
    }

    public static interface CellVisitor {
        public void visit(Object var1, Object var2, Object var3, int var4, int var5, Set var6);
    }
}

