/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.hierarchical;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import com.jgraph.layout.JGraphLayoutProgress;
import com.jgraph.layout.hierarchical.JGraphCoordinateAssignment;
import com.jgraph.layout.hierarchical.JGraphHierarchicalLayoutStep;
import com.jgraph.layout.hierarchical.JGraphLongestPathLayering;
import com.jgraph.layout.hierarchical.JGraphMedianHybridCrossingReduction;
import com.jgraph.layout.hierarchical.JGraphMinimumCycleRemover;
import com.jgraph.layout.hierarchical.model.JGraphHierarchyModel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

public class JGraphHierarchicalLayout
implements JGraphLayout,
JGraphLayout.Stoppable {
    private static final double INITIAL_X_POSITION = 100.0;
    protected double intraCellSpacing = 30.0;
    protected double interRankCellSpacing = 50.0;
    protected double interHierarchySpacing = 60.0;
    protected int orientation = 1;
    protected boolean fineTuning = true;
    protected JGraphHierarchyModel model = null;
    protected JGraphHierarchicalLayoutStep cycleStage = null;
    protected JGraphHierarchicalLayoutStep layeringStage = null;
    protected JGraphHierarchicalLayoutStep crossingStage = null;
    protected JGraphHierarchicalLayoutStep placementStage = null;
    protected JGraphLayoutProgress progress = new JGraphLayoutProgress();

    public JGraphHierarchicalLayout() {
        this(true);
    }

    public JGraphHierarchicalLayout(boolean bl) {
    }

    public void run(JGraphFacade jGraphFacade) {
        Object object;
        int n;
        int n2;
        Object[] objectArray;
        AbstractList abstractList;
        if (jGraphFacade.getRoots() == null || jGraphFacade.getRoots().size() == 0) {
            abstractList = new ArrayList();
            objectArray = jGraphFacade.getVertices().toArray();
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                n = jGraphFacade.getIncomingEdges(objectArray[n2], null, true, false).size();
                if (n != 0) continue;
                abstractList.add(objectArray[n2]);
            }
            if (abstractList.size() > 0) {
                jGraphFacade.setRoots(abstractList);
            } else {
                throw new RuntimeException("No candidate start nodes found in hierarchical layout");
            }
        }
        abstractList = new LinkedList();
        objectArray = jGraphFacade.getRoots().toArray();
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            n = 1;
            Iterator iterator = abstractList.iterator();
            while (n != 0 && iterator.hasNext()) {
                if (!((Set)iterator.next()).contains(objectArray[n2])) continue;
                n = 0;
            }
            if (n == 0) continue;
            object = new Stack<Object>();
            ((Stack)object).push(objectArray[n2]);
            HashSet hashSet = new HashSet();
            while (!((Vector)object).isEmpty()) {
                Object e = ((Stack)object).pop();
                if (hashSet.contains(e)) continue;
                hashSet.add(e);
                jGraphFacade.setDirected(false);
                Iterator iterator2 = jGraphFacade.getNeighbours(e, hashSet, false).iterator();
                jGraphFacade.setDirected(true);
                while (iterator2.hasNext()) {
                    ((Stack)object).push(iterator2.next());
                }
            }
            abstractList.add(hashSet);
        }
        this.progress.reset(abstractList.size() * 4 + 1);
        n2 = 1;
        double d = 100.0;
        object = abstractList.iterator();
        while (object.hasNext()) {
            this.model = new JGraphHierarchyModel(jGraphFacade, ((Set)object.next()).toArray(), false);
            this.cycleStage = new JGraphMinimumCycleRemover();
            this.model = this.cycleStage.run(jGraphFacade, this.model);
            if (this.model == null) {
                throw new RuntimeException("Could not remove cycles in hierarchical layout");
            }
            this.progress.setProgress(++n2);
            if (!this.progress.isStopped()) {
                this.layeringStage = new JGraphLongestPathLayering();
                this.model = this.layeringStage.run(jGraphFacade, this.model);
            }
            this.progress.setProgress(++n2);
            if (!this.progress.isStopped()) {
                this.crossingStage = new JGraphMedianHybridCrossingReduction();
                this.model = this.crossingStage.run(jGraphFacade, this.model);
            }
            this.progress.setProgress(++n2);
            if (!this.progress.isStopped()) {
                this.placementStage = new JGraphCoordinateAssignment(this.intraCellSpacing, this.interRankCellSpacing, this.orientation, d);
                ((JGraphCoordinateAssignment)this.placementStage).setIntraCellSpacing(this.intraCellSpacing);
                ((JGraphCoordinateAssignment)this.placementStage).setInterRankCellSpacing(this.interRankCellSpacing);
                ((JGraphCoordinateAssignment)this.placementStage).setOrientation(this.orientation);
                ((JGraphCoordinateAssignment)this.placementStage).setFineTuning(this.fineTuning);
                this.model = this.placementStage.run(jGraphFacade, this.model);
                d = ((JGraphCoordinateAssignment)this.placementStage).getLimitX() + this.interHierarchySpacing;
            }
            this.progress.setProgress(++n2);
        }
    }

    public String toString() {
        return "Hierarchical";
    }

    public JGraphLayoutProgress getProgress() {
        return this.progress;
    }

    public double getIntraCellSpacing() {
        return this.intraCellSpacing;
    }

    public void setIntraCellSpacing(double d) {
        this.intraCellSpacing = d;
    }

    public double getInterRankCellSpacing() {
        return this.interRankCellSpacing;
    }

    public void setInterRankCellSpacing(double d) {
        this.interRankCellSpacing = d;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public double getInterHierarchySpacing() {
        return this.interHierarchySpacing;
    }

    public void setInterHierarchySpacing(double d) {
        this.interHierarchySpacing = d;
    }

    public boolean isFineTuning() {
        return this.fineTuning;
    }

    public void setFineTuning(boolean bl) {
        this.fineTuning = bl;
    }
}

