/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.organic;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import com.jgraph.layout.JGraphLayoutProgress;
import java.awt.geom.RectangularShape;
import java.util.Hashtable;

public class JGraphFastOrganicLayout
implements JGraphLayout,
JGraphLayout.Stoppable {
    protected double forceConstant = 50.0;
    protected double forceConstantSquared = 0.0;
    protected double temperature = 0.0;
    protected double initialTemp = 200.0;
    protected int iteration = 0;
    protected int maxIterations = 0;
    protected Object[] vertexArray;
    protected double[] dispX;
    protected double[] dispY;
    protected double[][] cellLocation;
    protected double[] radius;
    protected double[] radiusSquared;
    protected boolean[] isMoveable;
    protected int[][] neighbours;
    protected JGraphLayoutProgress progress = new JGraphLayoutProgress();
    protected double minDistanceLimit = 2.0;
    protected double minDistanceLimitSquared = 4.0;

    public JGraphLayoutProgress getProgress() {
        return this.progress;
    }

    public void run(JGraphFacade jGraphFacade) {
        Object object;
        int n;
        boolean bl = jGraphFacade.isDirected();
        jGraphFacade.setDirected(false);
        this.vertexArray = jGraphFacade.getVertices().toArray();
        this.dispX = new double[this.vertexArray.length];
        this.dispY = new double[this.vertexArray.length];
        this.cellLocation = jGraphFacade.getLocations(this.vertexArray);
        this.isMoveable = new boolean[this.vertexArray.length];
        this.neighbours = new int[this.vertexArray.length][];
        this.radius = new double[this.vertexArray.length];
        this.radiusSquared = new double[this.vertexArray.length];
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>(this.vertexArray.length);
        if (this.forceConstant < 0.001) {
            this.forceConstant = 0.001;
        }
        this.forceConstantSquared = this.forceConstant * this.forceConstant;
        for (n = 0; n < this.vertexArray.length; ++n) {
            hashtable.put(this.vertexArray[n], new Integer(n));
            object = jGraphFacade.getBounds(this.vertexArray[n]);
            double d = ((RectangularShape)object).getWidth();
            double d2 = ((RectangularShape)object).getHeight();
            double[] dArray = this.cellLocation[n];
            dArray[0] = dArray[0] + d / 2.0;
            double[] dArray2 = this.cellLocation[n];
            dArray2[1] = dArray2[1] + d2 / 2.0;
            this.radius[n] = Math.min(d, d2);
            this.radiusSquared[n] = this.radius[n] * this.radius[n];
        }
        for (n = 0; n < this.vertexArray.length; ++n) {
            this.dispX[n] = 0.0;
            this.dispY[n] = 0.0;
            this.isMoveable[n] = jGraphFacade.isMoveable(this.vertexArray[n]);
            object = jGraphFacade.getNeighbours(this.vertexArray[n], null, false).toArray();
            this.neighbours[n] = new int[((Object[])object).length];
            for (int i = 0; i < ((Object[])object).length; ++i) {
                int n2;
                Integer n3 = (Integer)hashtable.get(object[i]);
                this.neighbours[n][i] = n3 != null ? (n2 = n3.intValue()) : n;
            }
        }
        this.temperature = this.initialTemp;
        if (this.maxIterations == 0) {
            this.maxIterations = 20 * (int)Math.sqrt(this.vertexArray.length);
        }
        this.progress.reset(this.maxIterations);
        this.iteration = 0;
        while (this.iteration < this.maxIterations && !this.progress.isStopped()) {
            this.progress.setProgress(this.iteration);
            this.calcRepulsion();
            this.calcAttraction();
            this.calcPositions();
            this.reduceTemperature();
            ++this.iteration;
        }
        for (n = 0; n < this.vertexArray.length; ++n) {
            object = jGraphFacade.getBounds(this.vertexArray[n]);
            double[] dArray = this.cellLocation[n];
            dArray[0] = dArray[0] - ((RectangularShape)object).getWidth() / 2.0;
            double[] dArray3 = this.cellLocation[n];
            dArray3[1] = dArray3[1] - ((RectangularShape)object).getHeight() / 2.0;
        }
        jGraphFacade.setLocations(this.vertexArray, this.cellLocation);
        jGraphFacade.setDirected(bl);
    }

    public void calcPositions() {
        for (int i = 0; i < this.vertexArray.length; ++i) {
            if (!this.isMoveable[i]) continue;
            double d = Math.sqrt(this.dispX[i] * this.dispX[i] + this.dispY[i] * this.dispY[i]);
            if (d < 0.001) {
                d = 0.001;
            }
            double d2 = this.dispX[i] / d * Math.min(d, this.temperature);
            double d3 = this.dispY[i] / d * Math.min(d, this.temperature);
            this.dispX[i] = 0.0;
            this.dispY[i] = 0.0;
            double[] dArray = this.cellLocation[i];
            dArray[0] = dArray[0] + d2;
            double[] dArray2 = this.cellLocation[i];
            dArray2[1] = dArray2[1] + d3;
        }
    }

    public void calcAttraction() {
        for (int i = 0; i < this.vertexArray.length; ++i) {
            for (int j = 0; j < this.neighbours[i].length; ++j) {
                if (this.progress.isStopped()) {
                    return;
                }
                int n = this.neighbours[i][j];
                if (i == n) continue;
                double d = this.cellLocation[i][0] - this.cellLocation[n][0];
                double d2 = this.cellLocation[i][1] - this.cellLocation[n][1];
                double d3 = d * d + d2 * d2 - this.radiusSquared[i] - this.radiusSquared[n];
                if (d3 < this.minDistanceLimitSquared) {
                    d3 = this.minDistanceLimitSquared;
                }
                double d4 = Math.sqrt(d3);
                double d5 = d3 / this.forceConstant;
                double d6 = d / d4 * d5;
                double d7 = d2 / d4 * d5;
                if (this.isMoveable[i]) {
                    int n2 = i;
                    this.dispX[n2] = this.dispX[n2] - d6;
                    int n3 = i;
                    this.dispY[n3] = this.dispY[n3] - d7;
                }
                if (!this.isMoveable[n]) continue;
                int n4 = n;
                this.dispX[n4] = this.dispX[n4] + d6;
                int n5 = n;
                this.dispY[n5] = this.dispY[n5] + d7;
            }
        }
    }

    public void calcRepulsion() {
        for (int i = 0; i < this.vertexArray.length; ++i) {
            for (int j = i; j < this.vertexArray.length; ++j) {
                if (this.progress.isStopped()) {
                    return;
                }
                if (j == i) continue;
                double d = this.cellLocation[i][0] - this.cellLocation[j][0];
                double d2 = this.cellLocation[i][1] - this.cellLocation[j][1];
                double d3 = Math.sqrt(d * d + d2 * d2);
                double d4 = d3 - this.radius[i] - this.radius[j];
                if (d4 < this.minDistanceLimit) {
                    d4 = this.minDistanceLimit;
                }
                double d5 = this.forceConstantSquared / d4;
                double d6 = d / d3 * d5;
                double d7 = d2 / d3 * d5;
                if (this.isMoveable[i]) {
                    int n = i;
                    this.dispX[n] = this.dispX[n] + d6;
                    int n2 = i;
                    this.dispY[n2] = this.dispY[n2] + d7;
                }
                if (!this.isMoveable[j]) continue;
                int n = j;
                this.dispX[n] = this.dispX[n] - d6;
                int n3 = j;
                this.dispY[n3] = this.dispY[n3] - d7;
            }
        }
    }

    private void reduceTemperature() {
        this.temperature = this.initialTemp * (1.0 - (double)this.iteration / (double)this.maxIterations);
    }

    public double getForceConstant() {
        return this.forceConstant;
    }

    public void setForceConstant(double d) {
        this.forceConstant = d;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public void setMaxIterations(int n) {
        this.maxIterations = n;
    }

    public double getInitialTemp() {
        return this.initialTemp;
    }

    public void setInitialTemp(double d) {
        this.initialTemp = d;
    }

    public String toString() {
        return "Fast Organic";
    }
}

