/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.routing;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;

public class JGraphParallelRouter
extends DefaultEdge.LoopRouting {
    private static final JGraphParallelRouter sharedInstance = new JGraphParallelRouter();
    private static final GraphModel emptyModel = new DefaultGraphModel();
    private static double edgeSeparation = 10.0;
    private static double edgeDeparture = 10.0;

    public static JGraphParallelRouter getSharedInstance() {
        return sharedInstance;
    }

    public List routeEdge(EdgeView edgeView) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (null == edgeView.getSource() || null == edgeView.getTarget() || null == edgeView.getSource().getParentView() || null == edgeView.getTarget().getParentView()) {
            return null;
        }
        arrayList.add(edgeView.getSource());
        Object[] objectArray = this.getParallelEdges(edgeView);
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length >= 2) {
            Object object;
            int n = 0;
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                if (object != edgeView.getCell()) continue;
                n = i + 1;
            }
            VertexView vertexView = (VertexView)edgeView.getSource().getParentView();
            object = (VertexView)edgeView.getTarget().getParentView();
            Point2D point2D = AbstractCellView.getCenterPoint((CellView)vertexView);
            Point2D point2D2 = AbstractCellView.getCenterPoint((CellView)object);
            if (point2D != null && point2D2 != null) {
                double d = point2D.getY() - point2D2.getY();
                double d2 = point2D.getX() - point2D2.getX();
                double d3 = d / d2;
                double d4 = Math.atan(-1.0 / d3);
                double d5 = d2 / Math.sqrt(d2 * d2 + d * d);
                double d6 = d / Math.sqrt(d2 * d2 + d * d);
                double d7 = Math.max(vertexView.getBounds().getWidth(), vertexView.getBounds().getHeight()) / 2.0;
                double d8 = Math.max(object.getBounds().getWidth(), object.getBounds().getHeight()) / 2.0;
                double d9 = (Math.sqrt(d2 * d2 + d * d) - d7 - d8) / 2.0 + d7;
                double d10 = edgeDeparture + d7;
                double d11 = edgeDeparture + d8;
                double d12 = edgeSeparation * Math.floor(n / 2);
                if (0 == n % 2) {
                    d12 = -d12;
                }
                double d13 = d12 * Math.cos(d4);
                double d14 = d12 * Math.sin(d4);
                if (d9 <= d10) {
                    double d15 = point2D.getX() - d5 * d9;
                    double d16 = point2D.getY() - d6 * d9;
                    Point2D.Double double_ = new Point2D.Double(d13 + d15, d14 + d16);
                    arrayList.add(double_);
                } else {
                    double d17 = point2D.getX() - d5 * d10;
                    double d18 = point2D.getY() - d6 * d10;
                    double d19 = point2D2.getX() + d5 * d11;
                    double d20 = point2D2.getY() + d6 * d11;
                    Point2D.Double double_ = new Point2D.Double(d13 + d17, d14 + d18);
                    Point2D.Double double_2 = new Point2D.Double(d13 + d19, d14 + d20);
                    arrayList.add(double_);
                    arrayList.add(double_2);
                }
            }
        }
        arrayList.add(edgeView.getTarget());
        return arrayList;
    }

    public static double getEdgeSeparation() {
        return edgeSeparation;
    }

    public static void setEdgeSeparation(double d) {
        edgeSeparation = d;
    }

    public static double getEdgeDeparture() {
        return edgeDeparture;
    }

    public static void setEdgeDeparture(double d) {
        edgeDeparture = d;
    }

    private Object[] getParallelEdges(EdgeView edgeView) {
        return DefaultGraphModel.getEdgesBetween((GraphModel)emptyModel, (Object)edgeView.getSource().getParentView().getCell(), (Object)edgeView.getTarget().getParentView().getCell(), (boolean)false);
    }
}

