/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.tree;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JGraphCompactTreeLayout
implements JGraphLayout {
    public static final int LEFT_TO_RIGHT = 7;
    public static final int UP_TO_DOWN = 1;
    public static final int DEFAULT_ORIENTATION = 7;
    protected int orientation = 7;
    protected double childParentDistance = 30.0;
    protected double nodeBorder = 5.0;
    protected transient Map nodes = new Hashtable();

    public void run(final JGraphFacade jGraphFacade) {
        if (jGraphFacade.getRootCount() == 0) {
            jGraphFacade.findTreeRoots();
        }
        for (int i = 0; i < jGraphFacade.getRootCount(); ++i) {
            this.nodes.clear();
            jGraphFacade.dfs(jGraphFacade.getRootAt(i), new JGraphFacade.CellVisitor(){

                public void visit(Object object, Object object2, Object object3, int n, int n2, Set set) {
                    TreeLayoutNode treeLayoutNode = JGraphCompactTreeLayout.this.getTreeLayoutNode(jGraphFacade, object);
                    TreeLayoutNode treeLayoutNode2 = JGraphCompactTreeLayout.this.getTreeLayoutNode(jGraphFacade, object2);
                    if (treeLayoutNode != null) {
                        if (object3 == null) {
                            treeLayoutNode.child = treeLayoutNode2;
                        } else {
                            TreeLayoutNode treeLayoutNode3 = JGraphCompactTreeLayout.this.getTreeLayoutNode(jGraphFacade, object3);
                            treeLayoutNode3.sibling = treeLayoutNode2;
                        }
                    }
                }
            });
            this.layoutTree(jGraphFacade, this.getTreeLayoutNode(jGraphFacade, jGraphFacade.getRootAt(i)));
            this.dispatchResult(jGraphFacade, this.nodes.values());
        }
    }

    protected void layoutTree(JGraphFacade jGraphFacade, TreeLayoutNode treeLayoutNode) {
        this.layout(treeLayoutNode);
        Rectangle2D rectangle2D = jGraphFacade.getBounds(treeLayoutNode.getCell());
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        switch (this.orientation) {
            case 7: {
                this.leftRightNodeLayout(treeLayoutNode, d, d2);
                break;
            }
            case 1: {
                this.upDownNodeLayout(treeLayoutNode, null, d, d2);
                break;
            }
            default: {
                this.leftRightNodeLayout(treeLayoutNode, d, d2);
            }
        }
    }

    protected TreeLayoutNode getTreeLayoutNode(JGraphFacade jGraphFacade, Object object) {
        if (object != null) {
            return this.getTreeLayoutNode(jGraphFacade, object, true);
        }
        return null;
    }

    protected TreeLayoutNode getTreeLayoutNode(JGraphFacade jGraphFacade, Object object, boolean bl) {
        TreeLayoutNode treeLayoutNode = (TreeLayoutNode)this.nodes.get(object);
        if (treeLayoutNode == null && bl) {
            Dimension2D dimension2D = jGraphFacade.getSize(object);
            treeLayoutNode = new TreeLayoutNode(object, dimension2D.getWidth(), dimension2D.getHeight());
            this.nodes.put(object, treeLayoutNode);
        }
        return treeLayoutNode;
    }

    protected void dispatchResult(JGraphFacade jGraphFacade, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TreeLayoutNode treeLayoutNode = (TreeLayoutNode)iterator.next();
            jGraphFacade.setLocation(treeLayoutNode.getCell(), treeLayoutNode.posX, treeLayoutNode.posY);
        }
    }

    protected void layout(TreeLayoutNode treeLayoutNode) {
        if (treeLayoutNode == null) {
            return;
        }
        TreeLayoutNode treeLayoutNode2 = treeLayoutNode.child;
        while (treeLayoutNode2 != null) {
            this.layout(treeLayoutNode2);
            treeLayoutNode2 = treeLayoutNode2.sibling;
        }
        if (treeLayoutNode.child != null) {
            this.attachParent(treeLayoutNode, this.join(treeLayoutNode));
        } else {
            this.layoutLeaf(treeLayoutNode);
        }
    }

    protected void attachParent(TreeLayoutNode treeLayoutNode, double d) {
        double d2 = this.nodeBorder + this.childParentDistance;
        double d3 = (d - treeLayoutNode.height) / 2.0 - this.nodeBorder;
        double d4 = d3 + treeLayoutNode.height + 2.0 * this.nodeBorder - d;
        treeLayoutNode.child.offsetX = d2 + treeLayoutNode.width;
        treeLayoutNode.child.offsetY = d4;
        treeLayoutNode.contour.upperHead = new PolyLine(treeLayoutNode.width, 0.0, new PolyLine(d2, d4, treeLayoutNode.contour.upperHead));
        treeLayoutNode.contour.lowerHead = new PolyLine(treeLayoutNode.width, 0.0, new PolyLine(d2, d3, treeLayoutNode.contour.lowerHead));
    }

    protected void layoutLeaf(TreeLayoutNode treeLayoutNode) {
        treeLayoutNode.contour.upperHead = treeLayoutNode.contour.upperTail = new PolyLine(treeLayoutNode.width + 2.0 * this.nodeBorder, 0.0, null);
        treeLayoutNode.contour.lowerTail = new PolyLine(0.0, -treeLayoutNode.height - 2.0 * this.nodeBorder, null);
        treeLayoutNode.contour.lowerHead = new PolyLine(treeLayoutNode.width + 2.0 * this.nodeBorder, 0.0, treeLayoutNode.contour.lowerTail);
    }

    protected double join(TreeLayoutNode treeLayoutNode) {
        double d;
        TreeLayoutNode treeLayoutNode2 = treeLayoutNode.child;
        treeLayoutNode.contour = treeLayoutNode2.contour;
        double d2 = d = treeLayoutNode2.height + 2.0 * this.nodeBorder;
        treeLayoutNode2 = treeLayoutNode2.sibling;
        while (treeLayoutNode2 != null) {
            double d3 = this.merge(treeLayoutNode.contour, treeLayoutNode2.contour);
            treeLayoutNode2.offsetY = d3 + d;
            treeLayoutNode2.offsetX = 0.0;
            d = treeLayoutNode2.height + 2.0 * this.nodeBorder;
            d2 += d3 + d;
            treeLayoutNode2 = treeLayoutNode2.sibling;
        }
        return d2;
    }

    protected double merge(Polygon polygon, Polygon polygon2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        PolyLine polyLine = polygon.lowerHead;
        PolyLine polyLine2 = polygon2.upperHead;
        while (polyLine2 != null && polyLine != null) {
            double d4 = this.offset(d3, d2, polyLine2.dx, polyLine2.dy, polyLine.dx, polyLine.dy);
            d2 += d4;
            d += d4;
            if (d3 + polyLine2.dx <= polyLine.dx) {
                d2 += polyLine2.dy;
                d3 += polyLine2.dx;
                polyLine2 = polyLine2.link;
                continue;
            }
            d2 -= polyLine.dy;
            d3 -= polyLine.dx;
            polyLine = polyLine.link;
        }
        if (polyLine2 != null) {
            PolyLine polyLine3 = this.bridge(polygon.upperTail, 0.0, 0.0, polyLine2, d3, d2);
            polygon.upperTail = polyLine3.link != null ? polygon2.upperTail : polyLine3;
            polygon.lowerTail = polygon2.lowerTail;
        } else {
            PolyLine polyLine4 = this.bridge(polygon2.lowerTail, d3, d2, polyLine, 0.0, 0.0);
            if (polyLine4.link == null) {
                polygon.lowerTail = polyLine4;
            }
        }
        polygon.lowerHead = polygon2.lowerHead;
        return d;
    }

    protected double offset(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (d5 <= d || d + d3 <= 0.0) {
            return 0.0;
        }
        double d8 = d5 * d4 - d3 * d6;
        if (d8 > 0.0) {
            if (d < 0.0) {
                double d9 = d * d4;
                d7 = d9 / d3 - d2;
            } else if (d > 0.0) {
                double d10 = d * d6;
                d7 = d10 / d5 - d2;
            } else {
                d7 = -d2;
            }
        } else if (d5 < d + d3) {
            double d11 = (d5 - d) * d4;
            d7 = d6 - (d2 + d11 / d3);
        } else if (d5 > d + d3) {
            double d12 = (d3 + d) * d6;
            d7 = d12 / d5 - (d2 + d4);
        } else {
            d7 = d6 - (d2 + d4);
        }
        if (d7 > 0.0) {
            return d7;
        }
        return 0.0;
    }

    protected PolyLine bridge(PolyLine polyLine, double d, double d2, PolyLine polyLine2, double d3, double d4) {
        double d5;
        double d6 = d3 + polyLine2.dx - d;
        if (polyLine2.dx == 0.0) {
            d5 = polyLine2.dy;
        } else {
            double d7 = d6 * polyLine2.dy;
            d5 = d7 / polyLine2.dx;
        }
        PolyLine polyLine3 = new PolyLine(d6, d5, polyLine2.link);
        polyLine.link = new PolyLine(0.0, d4 + polyLine2.dy - d5 - d2, polyLine3);
        return polyLine3;
    }

    protected void branch(TreeLayoutNode treeLayoutNode, TreeLayoutNode treeLayoutNode2, TreeLayoutNode treeLayoutNode3) {
        this.unzip(treeLayoutNode);
        treeLayoutNode2.parent = treeLayoutNode;
        if (treeLayoutNode3 != null) {
            treeLayoutNode2.sibling = treeLayoutNode3.sibling;
            treeLayoutNode3.sibling = treeLayoutNode2;
        } else {
            treeLayoutNode2.sibling = treeLayoutNode.child;
            treeLayoutNode.child = treeLayoutNode2;
        }
        this.zip(treeLayoutNode);
    }

    protected void unzip(TreeLayoutNode treeLayoutNode) {
        if (treeLayoutNode.parent != null) {
            this.unzip(treeLayoutNode.parent);
        }
        if (treeLayoutNode.child != null) {
            // empty if block
        }
    }

    protected void zip(TreeLayoutNode treeLayoutNode) {
        if (treeLayoutNode.child != null) {
            this.attachParent(treeLayoutNode, this.join(treeLayoutNode));
        } else {
            this.layoutLeaf(treeLayoutNode);
        }
        if (treeLayoutNode.parent != null) {
            this.zip(treeLayoutNode.parent);
        }
    }

    protected void leftRightNodeLayout(TreeLayoutNode treeLayoutNode, double d, double d2) {
        treeLayoutNode.posX += d + treeLayoutNode.offsetX;
        treeLayoutNode.posY += d2 + treeLayoutNode.offsetY;
        TreeLayoutNode treeLayoutNode2 = treeLayoutNode.child;
        if (treeLayoutNode2 != null) {
            this.leftRightNodeLayout(treeLayoutNode2, treeLayoutNode.posX, treeLayoutNode.posY);
            TreeLayoutNode treeLayoutNode3 = treeLayoutNode2.sibling;
            double d3 = treeLayoutNode.posY + treeLayoutNode2.offsetY;
            while (treeLayoutNode3 != null) {
                this.leftRightNodeLayout(treeLayoutNode3, treeLayoutNode.posX + treeLayoutNode2.offsetX, d3);
                d3 += treeLayoutNode3.offsetY;
                treeLayoutNode3 = treeLayoutNode3.sibling;
            }
        }
    }

    protected void upDownNodeLayout(TreeLayoutNode treeLayoutNode, TreeLayoutNode treeLayoutNode2, double d, double d2) {
        double d3 = 0.0;
        if (treeLayoutNode2 != null) {
            d3 = treeLayoutNode2.height - treeLayoutNode.height;
        }
        treeLayoutNode.posX += d - treeLayoutNode.offsetY + d3;
        treeLayoutNode.posY += d2 + treeLayoutNode.offsetX;
        TreeLayoutNode treeLayoutNode3 = treeLayoutNode.child;
        if (treeLayoutNode3 != null) {
            this.upDownNodeLayout(treeLayoutNode3, treeLayoutNode, treeLayoutNode.posX, treeLayoutNode.posY);
            TreeLayoutNode treeLayoutNode4 = treeLayoutNode3.sibling;
            double d4 = treeLayoutNode.posX - treeLayoutNode3.offsetY;
            while (treeLayoutNode4 != null) {
                this.upDownNodeLayout(treeLayoutNode4, treeLayoutNode, d4, treeLayoutNode.posY + treeLayoutNode3.offsetX);
                d4 -= treeLayoutNode4.offsetY;
                treeLayoutNode4 = treeLayoutNode4.sibling;
            }
        }
    }

    public void setOrientation(int n) {
        if (n != 1 && n != 7) {
            throw new IllegalArgumentException("Orientation must be NORTH (1), or WEST (7)");
        }
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setChildParentDistance(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.childParentDistance = d;
    }

    public double getNodeBorder() {
        return this.nodeBorder;
    }

    public void setNodeBorder(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.nodeBorder = d;
    }

    public String toString() {
        return "Compact Tree";
    }

    public double getChildParentDistance() {
        return this.childParentDistance;
    }

    private static class PolyLine {
        final double dx;
        final double dy;
        PolyLine link;

        PolyLine(double d, double d2, PolyLine polyLine) {
            this.dx = d;
            this.dy = d2;
            this.link = polyLine;
        }
    }

    private static class Polygon {
        PolyLine lowerHead;
        PolyLine lowerTail;
        PolyLine upperHead;
        PolyLine upperTail;

        private Polygon() {
        }
    }

    private class TreeLayoutNode {
        TreeLayoutNode parent;
        TreeLayoutNode child;
        TreeLayoutNode sibling;
        protected double width;
        protected double height;
        protected double posX = 0.0;
        protected double posY = 0.0;
        protected double offsetX = 0.0;
        protected double offsetY = 0.0;
        Polygon contour;
        protected Object cell;

        public TreeLayoutNode(Object object, double d, double d2) {
            this.cell = object;
            if (JGraphCompactTreeLayout.this.orientation == 1) {
                this.width = d2;
                this.height = d;
            }
            if (JGraphCompactTreeLayout.this.orientation == 7) {
                this.width = d;
                this.height = d2;
            }
            this.contour = new Polygon();
        }

        public Object getCell() {
            return this.cell;
        }
    }
}

