/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.tree;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.JGraphLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JGraphTreeLayout
implements JGraphLayout {
    protected transient Map nodes = new Hashtable();
    protected int alignment = 1;
    protected int orientation = 1;
    protected int levelDistance = 30;
    protected int nodeDistance = 20;
    protected boolean combineLevelNodes = true;
    protected boolean positionMultipleTrees = false;
    protected int treeDistance = 30;
    protected double treeBoundary = -200000.0;
    protected JGraphFacade graph;

    public void run(JGraphFacade jGraphFacade) {
        this.graph = jGraphFacade;
        if (jGraphFacade.getRootCount() == 0) {
            jGraphFacade.findTreeRoots();
        }
        this.treeBoundary = -20000.0;
        for (int i = 0; i < jGraphFacade.getRootCount(); ++i) {
            this.nodes.clear();
            jGraphFacade.dfs(jGraphFacade.getRootAt(i), new JGraphFacade.CellVisitor(){

                public void visit(Object object, Object object2, Object object3, int n, int n2, Set set) {
                    TreeNode treeNode = JGraphTreeLayout.this.getTreeNode(object);
                    TreeNode treeNode2 = JGraphTreeLayout.this.getTreeNode(object2);
                    if (treeNode != null) {
                        treeNode.children.add(treeNode2);
                    }
                }
            });
            TreeNode treeNode = this.getTreeNode(jGraphFacade.getRootAt(i));
            this.layout(treeNode);
            if (this.combineLevelNodes) {
                this.setLevelHeights(treeNode);
            }
            if (this.positionMultipleTrees) {
                this.spaceMultipleTrees(treeNode);
            }
            treeNode.setPosition(null, 0);
        }
    }

    protected TreeNode getTreeNode(Object object) {
        if (object != null) {
            TreeNode treeNode = (TreeNode)this.nodes.get(object);
            if (treeNode == null) {
                treeNode = new TreeNode(object);
                this.nodes.put(object, treeNode);
            }
            return treeNode;
        }
        return null;
    }

    protected void layout(TreeNode treeNode) {
        if (treeNode.children.size() != 0) {
            if (treeNode.children.size() == 1) {
                TreeNode treeNode2 = (TreeNode)treeNode.children.get(0);
                treeNode2.depth = treeNode.depth + 1;
                this.layout(treeNode2);
                treeNode2.leftContour.dx = (treeNode2.width - treeNode.width) / 2;
                treeNode2.rightContour.dx = (treeNode2.width - treeNode.width) / 2;
                treeNode.leftContour.next = treeNode2.leftContour;
                treeNode.rightContour.next = treeNode2.rightContour;
            } else {
                Iterator iterator = treeNode.children.iterator();
                while (iterator.hasNext()) {
                    TreeNode treeNode3 = (TreeNode)iterator.next();
                    treeNode3.depth = treeNode.depth + 1;
                    this.layout(treeNode3);
                }
                this.join(treeNode);
            }
        }
    }

    protected void join(TreeNode treeNode) {
        TreeNode treeNode2;
        int n;
        TreeNode treeNode3;
        int n2;
        Object object;
        int n3;
        int n4 = 0;
        for (n3 = 0; n3 < treeNode.children.size(); ++n3) {
            object = (TreeNode)treeNode.children.get(n3);
            for (n2 = n3 + 1; n2 < treeNode.children.size(); ++n2) {
                treeNode3 = (TreeNode)treeNode.children.get(n2);
                n = this.distance(((TreeNode)object).rightContour, treeNode3.leftContour) / (n2 - n3);
                n4 = Math.max(n4, n);
            }
        }
        n3 = treeNode.children.size() % 2 == 0 ? (treeNode.children.size() / 2 - 1) * n4 + n4 / 2 : treeNode.children.size() / 2 * (n4 += this.nodeDistance);
        object = treeNode.children.iterator();
        n2 = 0;
        while (object.hasNext()) {
            ((TreeNode)object.next()).x = -n3 + n2 * n4;
            ++n2;
        }
        TreeNode treeNode4 = this.getLeftMostX(treeNode);
        treeNode3 = this.getRightMostX(treeNode);
        treeNode.leftContour.next = treeNode4.leftContour;
        treeNode.rightContour.next = treeNode3.rightContour;
        for (n = 1; n < treeNode.children.size(); ++n) {
            treeNode2 = (TreeNode)treeNode.children.get(n);
            this.merge(treeNode.leftContour.next, treeNode2.leftContour, n * n4 + treeNode.width);
        }
        for (n = treeNode.children.size() - 2; n >= 0; --n) {
            treeNode2 = (TreeNode)treeNode.children.get(n);
            this.merge(treeNode.rightContour.next, treeNode2.rightContour, n * n4 + treeNode.width);
        }
        n4 = (treeNode.children.size() - 1) * n4 / 2;
        treeNode.leftContour.next.dx += n4 - treeNode.width / 2;
        treeNode.rightContour.next.dx += n4 - treeNode.width / 2;
    }

    protected TreeNode getLeftMostX(TreeNode treeNode) {
        int n = Integer.MAX_VALUE;
        boolean bl = false;
        TreeNode treeNode2 = null;
        Iterator iterator = treeNode.getChildren();
        while (iterator.hasNext()) {
            TreeNode treeNode3 = (TreeNode)iterator.next();
            int n2 = treeNode3.x - treeNode3.getLeftWidth();
            if (n2 < n) {
                treeNode2 = treeNode3;
                n = n2;
            }
            bl = true;
        }
        if (treeNode2 != null) {
            return treeNode2;
        }
        return bl ? (TreeNode)treeNode.children.get(0) : treeNode;
    }

    protected TreeNode getRightMostX(TreeNode treeNode) {
        int n = Integer.MIN_VALUE;
        boolean bl = false;
        TreeNode treeNode2 = null;
        Iterator iterator = treeNode.getChildren();
        while (iterator.hasNext()) {
            TreeNode treeNode3 = (TreeNode)iterator.next();
            int n2 = treeNode3.x + treeNode3.getRightWidth();
            if (n2 > n) {
                treeNode2 = treeNode3;
                n = n2;
            }
            bl = true;
        }
        if (treeNode2 != null) {
            return treeNode2;
        }
        return bl ? (TreeNode)treeNode.children.get(0) : treeNode;
    }

    protected void merge(PolyLine polyLine, PolyLine polyLine2, int n) {
        while (polyLine != null) {
            if (polyLine2.next == null) {
                return;
            }
            if (polyLine.next == null) {
                polyLine2 = polyLine2.next;
                break;
            }
            n += polyLine.dx - polyLine2.dx;
            polyLine = polyLine.next;
            polyLine2 = polyLine2.next;
        }
        polyLine2.dx += -n;
        polyLine.next = polyLine2;
    }

    protected int distance(PolyLine polyLine, PolyLine polyLine2) {
        int n = 0;
        int n2 = 0;
        while (polyLine != null && polyLine2 != null) {
            if ((n2 += polyLine.dx + polyLine2.dx) > 0) {
                n += n2;
                n2 = 0;
            }
            polyLine = polyLine.next;
            polyLine2 = polyLine2.next;
        }
        return n;
    }

    protected void setPosition(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((TreeNode)iterator.next()).setPosition(null, 0);
        }
    }

    protected void setLevelHeights(TreeNode treeNode) {
        List list = treeNode.getNodesByLevel();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            int n2;
            List list2 = (List)list.get(i);
            for (n2 = 0; n2 < list2.size(); ++n2) {
                n = Math.max(n, ((TreeNode)list2.get((int)n2)).height);
            }
            for (n2 = 0; n2 < list2.size(); ++n2) {
                ((TreeNode)list2.get((int)n2)).levelheight = n;
            }
            n = 0;
        }
    }

    protected void spaceMultipleTrees(TreeNode treeNode) {
        int n;
        double d;
        int n2;
        Point2D point2D = this.graph.getLocation(treeNode.cell);
        double d2 = 0.0;
        double d3 = 0.0;
        if (point2D != null) {
            d2 = this.graph.getLocation(treeNode.cell).getX();
            d3 = this.graph.getLocation(treeNode.cell).getY();
        }
        if (this.orientation == 1) {
            n2 = treeNode.getLeftWidth();
            d = d2 - (double)n2;
            if (d < this.treeBoundary + (double)this.treeDistance) {
                d2 = this.treeBoundary + (double)this.treeDistance + (double)n2;
                this.graph.setLocation(treeNode.cell, d2, d3);
            }
            n = treeNode.getRightWidth();
            this.treeBoundary = d2 + (double)n;
        }
        if (this.orientation == 5) {
            n2 = treeNode.getRightWidth();
            d = d2 - (double)n2;
            if (d < this.treeBoundary + (double)this.treeDistance) {
                d2 = this.treeBoundary + (double)this.treeDistance + d;
                this.graph.setLocation(treeNode.cell, d2, d3);
            }
            n = treeNode.getLeftWidth();
            this.treeBoundary = d2 + (double)n;
        }
        if (this.orientation == 7) {
            n2 = treeNode.getRightWidth();
            d = d3 - (double)n2;
            if (d < this.treeBoundary + (double)this.treeDistance) {
                d3 = this.treeBoundary + (double)this.treeDistance + d;
                this.graph.setLocation(treeNode.cell, d2, d3);
            }
            n = treeNode.getLeftWidth();
            this.treeBoundary = d3 + (double)n;
        }
        if (this.orientation == 3) {
            n2 = treeNode.getLeftWidth();
            d = d3 - (double)n2;
            if (d < this.treeBoundary + (double)this.treeDistance) {
                d3 = this.treeBoundary + (double)this.treeDistance + d;
                this.graph.setLocation(treeNode.cell, d2, d3);
            }
            n = treeNode.getRightWidth();
            this.treeBoundary = d3 + (double)n + (double)this.getRightMostX((TreeNode)treeNode).height;
        }
    }

    public void setAlignment(int n) {
        if (n != 1 && n != 0 && n != 3) {
            throw new IllegalArgumentException("Alignment must be one of TOP, CENTER or BOTTOM");
        }
        this.alignment = n;
    }

    public void setOrientation(int n) {
        if (n != 1 && n != 3 && n != 5 && n != 7) {
            throw new IllegalArgumentException("Orientation must be one of NORTH (1), EAST (3), SOUTH (5) or WEST (7)");
        }
        this.orientation = n;
    }

    public void setLevelDistance(int n) {
        this.levelDistance = n;
    }

    public void setNodeDistance(int n) {
        this.nodeDistance = n;
    }

    public boolean isCombineLevelNodes() {
        return this.combineLevelNodes;
    }

    public void setCombineLevelNodes(boolean bl) {
        this.combineLevelNodes = bl;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getLevelDistance() {
        return this.levelDistance;
    }

    public int getNodeDistance() {
        return this.nodeDistance;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public String toString() {
        return "Tree";
    }

    public boolean isPositionMultipleTrees() {
        return this.positionMultipleTrees;
    }

    public void setPositionMultipleTrees(boolean bl) {
        this.positionMultipleTrees = bl;
    }

    public int getTreeDistance() {
        return this.treeDistance;
    }

    public void setTreeDistance(int n) {
        this.treeDistance = n;
    }

    protected class PolyLine {
        int dx;
        PolyLine next;

        public PolyLine(int n) {
            this.dx = n;
        }
    }

    protected class TreeNode {
        List children;
        int width;
        int height;
        int x;
        int y;
        int levelheight;
        PolyLine leftContour;
        PolyLine rightContour;
        int depth;
        Object cell;

        public TreeNode(Object object) {
            this.cell = object;
            Rectangle2D rectangle2D = JGraphTreeLayout.this.graph.getBounds(object);
            if (rectangle2D != null) {
                if (JGraphTreeLayout.this.orientation == 1 || JGraphTreeLayout.this.orientation == 5) {
                    this.width = (int)rectangle2D.getWidth();
                    this.height = (int)rectangle2D.getHeight();
                } else {
                    this.width = (int)rectangle2D.getHeight();
                    this.height = (int)rectangle2D.getWidth();
                }
            }
            this.children = new ArrayList();
            this.leftContour = new PolyLine(this.width / 2);
            this.rightContour = new PolyLine(this.width / 2);
            this.depth = 0;
        }

        public Iterator getChildren() {
            return this.children.iterator();
        }

        public int getLeftWidth() {
            int n = 0;
            PolyLine polyLine = this.leftContour;
            int n2 = 0;
            while (polyLine != null) {
                if ((n2 += polyLine.dx) > 0) {
                    n += n2;
                    n2 = 0;
                }
                polyLine = polyLine.next;
            }
            return n;
        }

        public int getRightWidth() {
            int n = 0;
            PolyLine polyLine = this.rightContour;
            int n2 = 0;
            while (polyLine != null) {
                if ((n2 += polyLine.dx) > 0) {
                    n += n2;
                    n2 = 0;
                }
                polyLine = polyLine.next;
            }
            return n;
        }

        public int getHeight() {
            if (this.children.isEmpty()) {
                return this.levelheight;
            }
            int n = 0;
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                n = Math.max(n, ((TreeNode)iterator.next()).getHeight());
            }
            return n + JGraphTreeLayout.this.levelDistance + this.levelheight;
        }

        public void setPosition(Point2D point2D, int n) {
            int n2 = 0;
            Object object = this.children.iterator();
            while (object.hasNext()) {
                n2 = Math.max(n2, ((TreeNode)object.next()).height);
            }
            object = JGraphTreeLayout.this.graph.getLocation(this.cell);
            if (object == null) {
                object = new Point2D.Double(0.0, 0.0);
            }
            if (point2D == null) {
                if (JGraphTreeLayout.this.orientation == 7 || JGraphTreeLayout.this.orientation == 3) {
                    ((Point2D)object).setLocation(((Point2D)object).getY(), ((Point2D)object).getX());
                }
                if (JGraphTreeLayout.this.orientation == 1 || JGraphTreeLayout.this.orientation == 7) {
                    point2D = new Point2D.Double(((Point2D)object).getX() + (double)(this.width / 2), ((Point2D)object).getY() + (double)this.height);
                } else if (JGraphTreeLayout.this.orientation == 5 || JGraphTreeLayout.this.orientation == 3) {
                    point2D = new Point2D.Double(((Point2D)object).getX() + (double)(this.width / 2), ((Point2D)object).getY());
                }
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    ((TreeNode)iterator.next()).setPosition(point2D, n2);
                }
                return;
            }
            if (JGraphTreeLayout.this.combineLevelNodes) {
                n = this.levelheight;
            }
            object = new Point2D.Double(this.width, this.height);
            if (JGraphTreeLayout.this.orientation == 1 || JGraphTreeLayout.this.orientation == 7) {
                ((Point2D)object).setLocation((double)this.x + point2D.getX() - (double)(this.width / 2), point2D.getY() + (double)JGraphTreeLayout.this.levelDistance);
            } else {
                ((Point2D)object).setLocation((double)this.x + point2D.getX() - (double)(this.width / 2), point2D.getY() - (double)JGraphTreeLayout.this.levelDistance - (double)this.levelheight);
            }
            if (JGraphTreeLayout.this.alignment == 0) {
                ((Point2D)object).setLocation(((Point2D)object).getX(), ((Point2D)object).getY() + (double)((n - this.height) / 2));
            } else if (JGraphTreeLayout.this.alignment == 3) {
                ((Point2D)object).setLocation(((Point2D)object).getX(), ((Point2D)object).getY() + (double)n - (double)this.height);
            }
            if (JGraphTreeLayout.this.orientation == 7 || JGraphTreeLayout.this.orientation == 3) {
                ((Point2D)object).setLocation(((Point2D)object).getY(), ((Point2D)object).getX());
            }
            JGraphTreeLayout.this.graph.setLocation(this.cell, ((Point2D)object).getX(), ((Point2D)object).getY());
            this.y = JGraphTreeLayout.this.orientation == 1 || JGraphTreeLayout.this.orientation == 7 ? (int)(point2D.getY() + (double)JGraphTreeLayout.this.levelDistance + (double)n) : (int)(point2D.getY() - (double)JGraphTreeLayout.this.levelDistance - (double)n);
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((TreeNode)iterator.next()).setPosition(new Point2D.Double((double)this.x + point2D.getX(), this.y), n2);
            }
        }

        public List getNodesByLevel() {
            ArrayList arrayList = new ArrayList<Object>();
            Object object = this.children.iterator();
            while (object.hasNext()) {
                ArrayList<Object> arrayList2 = ((TreeNode)object.next()).getNodesByLevel();
                if (arrayList.size() < arrayList2.size()) {
                    ArrayList<Object> arrayList3 = arrayList;
                    arrayList = arrayList2;
                    arrayList2 = arrayList3;
                }
                for (int i = 0; i < arrayList2.size(); ++i) {
                    ((List)arrayList.get(i)).addAll((List)arrayList2.get(i));
                }
            }
            object = new ArrayList();
            ((ArrayList)object).add(this);
            arrayList.add(0, object);
            return arrayList;
        }
    }
}

