/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core;

import com.gigaspaces.client.IsolationLevelModifiers;
import com.j_spaces.javax.cache.CacheEntry;
import com.j_spaces.javax.cache.CacheException;
import com.j_spaces.javax.cache.CacheListener;
import com.j_spaces.map.IMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.jini.core.transaction.Transaction;
import org.openspaces.core.GigaMap;
import org.openspaces.core.exception.ExceptionTranslator;
import org.openspaces.core.map.LockHandle;
import org.openspaces.core.map.LockManager;
import org.openspaces.core.transaction.TransactionProvider;

public class DefaultGigaMap
implements GigaMap {
    private final IMap map;
    private final TransactionProvider txProvider;
    private final ExceptionTranslator exTranslator;
    private long defaultWaitForResponse = 0L;
    private long defaultTimeToLive = Long.MAX_VALUE;
    private long defaultLockTimeToLive = 60000L;
    private long defaultWaitingForLockTimeout = 10000L;
    private int defaultIsolationLevel;
    private final LockManager lockManager;

    public DefaultGigaMap(IMap map, TransactionProvider txProvider, ExceptionTranslator exTranslator, int defaultIsolationLevel) {
        this.map = map;
        this.lockManager = new LockManager(map);
        this.txProvider = txProvider;
        this.exTranslator = exTranslator;
        switch (defaultIsolationLevel) {
            case -1: {
                this.defaultIsolationLevel = 0;
                break;
            }
            case 1: {
                this.defaultIsolationLevel = 32;
                break;
            }
            case 2: {
                this.defaultIsolationLevel = 8192;
                break;
            }
            case 4: {
                this.defaultIsolationLevel = 0;
                break;
            }
            case 8: {
                throw new IllegalArgumentException("GigaMap does not support serializable isolation level");
            }
        }
    }

    public void setDefaultWaitForResponse(long defaultWaitForResponse) {
        this.defaultWaitForResponse = defaultWaitForResponse;
    }

    public void setDefaultTimeToLive(long defaultTimeToLive) {
        this.defaultTimeToLive = defaultTimeToLive;
    }

    public void setDefaultLockTimeToLive(long defaultLockTimeToLive) {
        this.defaultLockTimeToLive = defaultLockTimeToLive;
    }

    public void setDefaultWaitingForLockTimeout(long defaultWaitingForLockTimeout) {
        this.defaultWaitingForLockTimeout = defaultWaitingForLockTimeout;
    }

    @Override
    public IMap getMap() {
        return this.map;
    }

    @Override
    public TransactionProvider getTxProvider() {
        return this.txProvider;
    }

    @Override
    public int size() {
        try {
            return this.map.size();
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            return this.map.isEmpty();
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    @Override
    public boolean containsKey(Object key) {
        try {
            return this.map.containsKey(key);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        try {
            return this.map.containsValue(value);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public Object get(Object key) {
        return this.get(key, this.defaultWaitForResponse);
    }

    @Override
    public Object get(Object key, long waitForResponse) {
        return this.get(key, waitForResponse, this.getModifiersForIsolationLevel());
    }

    @Override
    public Object get(Object key, long waitForResponse, int modifiers) {
        try {
            return this.map.get(key, this.getCurrentTransaction(), waitForResponse, modifiers);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public Object put(Object key, Object value) {
        return this.put(key, value, this.defaultTimeToLive);
    }

    @Override
    public Object put(Object key, Object value, long timeToLive) {
        return this.put(key, value, timeToLive, this.defaultWaitForResponse);
    }

    @Override
    public Object put(Object key, Object value, long timeToLive, long timeout) {
        try {
            return this.map.put(key, value, this.getCurrentTransaction(), timeToLive, timeout);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    @Override
    public Object put(Object key, Object value, LockHandle lockHandle) {
        return this.put(key, value, this.defaultTimeToLive, lockHandle);
    }

    @Override
    public Object put(Object key, Object value, long timeToLive, LockHandle lockHandle) {
        try {
            return this.map.put(key, value, lockHandle.getTransaction(), timeToLive);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public Object remove(Object key) {
        return this.remove(key, this.defaultWaitForResponse);
    }

    @Override
    public Object remove(Object key, long waitForResponse) {
        try {
            return this.map.remove(key, this.getCurrentTransaction(), waitForResponse);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    @Override
    public Object remove(Object key, long waitForResponse, LockHandle lockHandle) {
        try {
            return this.map.remove(key, lockHandle.getTransaction(), waitForResponse);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public void putAll(Map t) {
        this.putAll(t, this.defaultTimeToLive);
    }

    @Override
    public void putAll(Map t, long timeToLive) {
        try {
            this.map.putAll(t, this.getCurrentTransaction(), timeToLive);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    @Override
    public void clear() {
        try {
            this.map.clear();
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    @Override
    public void clear(boolean clearMaster) {
        try {
            this.map.clear(clearMaster);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public Set keySet() {
        try {
            return this.map.keySet();
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public Collection values() {
        try {
            return this.map.values();
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public Set entrySet() {
        try {
            return this.map.entrySet();
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public void addListener(CacheListener cacheListener) {
        this.map.addListener(cacheListener);
    }

    public boolean evict(Object key) {
        try {
            return this.map.evict(key);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public Map getAll(Collection keys) throws CacheException {
        try {
            return this.map.getAll(keys);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public CacheEntry getCacheEntry(Object key) {
        try {
            return this.map.getCacheEntry(key);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public void load(Object key) throws CacheException {
        try {
            this.map.load(key);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public void loadAll(Collection keys) throws CacheException {
        try {
            this.map.load((Object)keys);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public Object peek(Object key) {
        try {
            return this.map.peek(key);
        }
        catch (Exception e) {
            throw this.exTranslator.translate((Throwable)e);
        }
    }

    public void removeListener(CacheListener cacheListener) {
        this.map.removeListener(cacheListener);
    }

    @Override
    public Transaction getCurrentTransaction() {
        return this.txProvider.getCurrentTransaction();
    }

    @Override
    public LockHandle lock(Object key) {
        return this.lock(key, this.defaultLockTimeToLive, this.defaultWaitingForLockTimeout);
    }

    @Override
    public LockHandle lock(Object key, long lockTimeToLive, long waitingForLockTimeout) {
        return this.lockManager.lock(key, lockTimeToLive, waitingForLockTimeout);
    }

    @Override
    public void unlock(Object key) {
        this.lockManager.unlock(key);
    }

    @Override
    public boolean isLocked(Object key) {
        return this.lockManager.islocked(key);
    }

    @Override
    public void putAndUnlock(Object key, Object value) {
        this.lockManager.putAndUnlock(key, value);
    }

    @Override
    public long getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    @Override
    public long getDefaultWaitForResponse() {
        return this.defaultWaitForResponse;
    }

    public int getModifiersForIsolationLevel() {
        IsolationLevelModifiers modifiers = this.txProvider.getCurrentTransactionIsolationLevel();
        return modifiers != null ? modifiers.getCode() : this.defaultIsolationLevel;
    }

    public String toString() {
        return this.map.toString();
    }
}

