/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core;

import com.j_spaces.map.IMap;
import org.openspaces.core.DefaultGigaMap;
import org.openspaces.core.GigaMap;
import org.openspaces.core.exception.DefaultExceptionTranslator;
import org.openspaces.core.exception.ExceptionTranslator;
import org.openspaces.core.transaction.DefaultTransactionProvider;
import org.openspaces.core.transaction.TransactionProvider;
import org.openspaces.core.transaction.manager.JiniPlatformTransactionManager;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.util.Assert;

public class GigaMapFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean,
BeanNameAware {
    public static final String PREFIX_ISOLATION = "ISOLATION_";
    private static final Constants constants = new Constants(TransactionDefinition.class);
    private IMap map;
    private TransactionProvider txProvider;
    private DefaultTransactionProvider defaultTxProvider;
    private ExceptionTranslator exTranslator;
    private PlatformTransactionManager transactionManager;
    private long defaultWaitForResponse = 0L;
    private long defaultTimeToLive = Long.MAX_VALUE;
    private long defaultLockTimeToLive = 60000L;
    private long defaultWaitingForLockTimeout = 10000L;
    private int defaultIsolationLevel = -1;
    private String beanName;
    private DefaultGigaMap gigaMap;

    public void setMap(IMap map) {
        this.map = map;
    }

    public void setTxProvider(TransactionProvider txProvider) {
        this.txProvider = txProvider;
    }

    public void setExTranslator(ExceptionTranslator exTranslator) {
        this.exTranslator = exTranslator;
    }

    public void setDefaultWaitForResponse(long defaultWaitForResponse) {
        this.defaultWaitForResponse = defaultWaitForResponse;
    }

    public void setDefaultTimeToLive(long defaultTimeToLive) {
        this.defaultTimeToLive = defaultTimeToLive;
    }

    public void setDefaultLockTimeToLive(long defaultLockTimeToLive) {
        this.defaultLockTimeToLive = defaultLockTimeToLive;
    }

    public void setDefaultWaitingForLockTimeout(long defaultWaitingForLockTimeout) {
        this.defaultWaitingForLockTimeout = defaultWaitingForLockTimeout;
    }

    public final void setDefaultIsolationLevelName(String constantName) throws IllegalArgumentException {
        if (constantName == null || !constantName.startsWith(PREFIX_ISOLATION)) {
            throw new IllegalArgumentException("Only isolation constants allowed");
        }
        this.setDefaultIsolationLevel(constants.asNumber(constantName).intValue());
    }

    public void setDefaultIsolationLevel(int defaultIsolationLevel) {
        if (!constants.getValues(PREFIX_ISOLATION).contains(defaultIsolationLevel)) {
            throw new IllegalArgumentException("Only values of isolation constants allowed");
        }
        this.defaultIsolationLevel = defaultIsolationLevel;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.map, (String)"map property is required");
        if (this.exTranslator == null) {
            this.exTranslator = new DefaultExceptionTranslator();
        }
        if (this.txProvider == null) {
            Object transactionalContext = null;
            if (this.transactionManager != null && this.transactionManager instanceof JiniPlatformTransactionManager) {
                transactionalContext = ((JiniPlatformTransactionManager)this.transactionManager).getTransactionalContext();
            }
            if (transactionalContext == null) {
                transactionalContext = this.map.getMasterSpace();
            }
            this.defaultTxProvider = new DefaultTransactionProvider(this.map.getMasterSpace(), transactionalContext, this.transactionManager);
            this.txProvider = this.defaultTxProvider;
        }
        this.gigaMap = new DefaultGigaMap(this.map, this.txProvider, this.exTranslator, this.defaultIsolationLevel);
        this.gigaMap.setDefaultTimeToLive(this.defaultTimeToLive);
        this.gigaMap.setDefaultWaitForResponse(this.defaultWaitForResponse);
        this.gigaMap.setDefaultLockTimeToLive(this.defaultLockTimeToLive);
        this.gigaMap.setDefaultWaitingForLockTimeout(this.defaultWaitingForLockTimeout);
    }

    public Object getObject() {
        return this.gigaMap;
    }

    public Class<? extends GigaMap> getObjectType() {
        return this.gigaMap == null ? GigaMap.class : this.gigaMap.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.defaultTxProvider != null) {
            this.defaultTxProvider.destroy();
        }
    }
}

