/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import org.openspaces.core.GigaMapFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class GigaMapBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String DEFAULT_ISOLATION = "default-isolation";
    public static final String MAP = "map";
    public static final String TX_MANAGER = "tx-manager";

    protected Class<GigaMapFactoryBean> getBeanClass(Element element) {
        return GigaMapFactoryBean.class;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            String name = attribute.getLocalName();
            if ("id".equals(name)) continue;
            String propertyName = this.extractPropertyName(name);
            if (DEFAULT_ISOLATION.equals(name)) {
                builder.addPropertyValue("defaultIsolationLevelName", (Object)("ISOLATION_" + attribute.getValue()));
                continue;
            }
            if (MAP.equals(name)) {
                builder.addPropertyReference(MAP, attribute.getValue());
                continue;
            }
            if (TX_MANAGER.equals(name)) {
                builder.addPropertyReference("transactionManager", attribute.getValue());
                continue;
            }
            Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            builder.addPropertyValue(propertyName, (Object)attribute.getValue());
        }
    }

    protected String extractPropertyName(String attributeName) {
        return Conventions.attributeNameToPropertyName((String)attributeName);
    }
}

