/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import org.openspaces.core.map.MapFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MapBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    public static final String SPACE = "space";

    protected Class getBeanClass(Element element) {
        return MapFactoryBean.class;
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return super.isEligibleAttribute(attributeName) && !SPACE.equals(attributeName);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element localCacheSettingEle;
        String compression;
        super.doParse(element, parserContext, builder);
        String space = element.getAttribute(SPACE);
        if (StringUtils.hasLength((String)space)) {
            builder.addPropertyReference(SPACE, space);
        }
        if (StringUtils.hasLength((String)(compression = element.getAttribute("compression")))) {
            builder.addPropertyValue("compression", (Object)compression);
        }
        if ((localCacheSettingEle = DomUtils.getChildElementByTagName((Element)element, (String)"local-cache-support")) != null) {
            Object template = parserContext.getDelegate().parsePropertySubElement(localCacheSettingEle, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("localCacheSupport", template);
        }
    }
}

