/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.map;

import com.gigaspaces.client.transaction.DistributedTransactionManagerProvider;
import com.j_spaces.core.IJSpace;
import com.j_spaces.map.IMap;
import com.j_spaces.map.MapEntryFactory;
import com.j_spaces.map.SpaceMapEntry;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.server.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.SpaceTimeoutException;
import org.openspaces.core.map.LockHandle;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.transaction.CannotCreateTransactionException;

public class LockManager {
    public static final Object EMPTY_LOCK_VALUE = "";
    private static Log logger = LogFactory.getLog(LockManager.class);
    private final IMap map;
    private final ConcurrentHashMap<String, Transaction> lockedUIDHashMap = new ConcurrentHashMap();
    private final IJSpace masterSpace;
    private final BlockingQueue<SpaceMapEntry> templatePool;
    private final DistributedTransactionManagerProvider transactionManagerProvider;

    public static boolean isEmptyLockValue(Object value) {
        return value instanceof String && ((String)value).length() == 0;
    }

    public LockManager(IMap map) {
        this.map = map;
        this.masterSpace = map.getMasterSpace();
        try {
            this.transactionManagerProvider = new DistributedTransactionManagerProvider();
        }
        catch (TransactionException e) {
            throw new CannotCreateTransactionException("Failed to obtain transaction lock manager", (Throwable)e);
        }
        this.templatePool = new ArrayBlockingQueue<SpaceMapEntry>(1000);
        for (int i = 0; i < 1000; ++i) {
            this.templatePool.add(MapEntryFactory.create());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockHandle lock(Object key, long lockTimeToLive, long timeoutWaitingForLock) {
        String uid = String.valueOf(key);
        Transaction tr = null;
        try {
            tr = this.getTransaction(lockTimeToLive);
        }
        finally {
            if (tr == null) {
                this.lockedUIDHashMap.remove(uid);
                return null;
            }
        }
        SpaceMapEntry ee = this.getTemplate(key);
        try {
            Object retTake = this.masterSpace.readIfExists((Object)ee, tr, timeoutWaitingForLock, 512);
            if (retTake == null) {
                this.map.put(key, EMPTY_LOCK_VALUE, tr, Integer.MAX_VALUE);
            }
        }
        catch (SpaceTimeoutException e) {
            try {
                tr.abort();
            }
            catch (Exception re) {
                logger.warn((Object)"Failed to abort transaction", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable t) {
            try {
                tr.abort();
            }
            catch (Exception re) {
                logger.warn((Object)"Failed to abort transaction", t);
            }
            this.lockedUIDHashMap.remove(uid);
            throw new DataAccessResourceFailureException("Failed to obtain lock for key [" + key + "]", t);
        }
        finally {
            this.releaseTemplate(ee);
        }
        this.lockedUIDHashMap.put(uid, tr);
        return new LockHandle(this, tr, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAndUnlock(Object key, Object value) {
        String uid = String.valueOf(key);
        Transaction tr = this.lockedUIDHashMap.get(uid);
        if (tr == null) {
            this.map.put(key, value, null, Integer.MAX_VALUE);
            return;
        }
        try {
            this.map.put(key, value, tr, Integer.MAX_VALUE);
            tr.commit();
        }
        catch (Throwable t) {
            logger.warn((Object)("Failed to commit transaction and unlock the key [" + key + "], ignoring"), t);
        }
        finally {
            this.lockedUIDHashMap.remove(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean islocked(Object key) {
        String uid = String.valueOf(key);
        if (this.lockedUIDHashMap.containsKey(uid)) {
            return true;
        }
        SpaceMapEntry ee = this.getTemplate(key);
        try {
            Object lockEntry = this.masterSpace.readIfExists((Object)ee, null, 0L);
            boolean bl = lockEntry == null;
            return bl;
        }
        catch (Exception e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseTemplate(ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Object key) {
        String uid = String.valueOf(key);
        Transaction tr = this.lockedUIDHashMap.get(uid);
        if (tr == null) {
            return;
        }
        try {
            tr.commit();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to commit transaction and unlocking the object, ignoring", (Throwable)e);
        }
        finally {
            this.lockedUIDHashMap.remove(uid);
        }
    }

    private Transaction getTransaction(long timeout) throws CannotCreateTransactionException {
        Transaction.Created tCreated;
        try {
            tCreated = TransactionFactory.create((TransactionManager)this.transactionManagerProvider.getTransactionManager(), (long)timeout);
        }
        catch (Exception e) {
            throw new CannotCreateTransactionException("Failed to create lock transaction", (Throwable)e);
        }
        return tCreated.transaction;
    }

    private SpaceMapEntry getTemplate(Object key) {
        SpaceMapEntry ee;
        try {
            ee = this.templatePool.poll(100L, TimeUnit.MILLISECONDS);
            if (ee == null) {
                ee = MapEntryFactory.create();
            }
        }
        catch (InterruptedException e) {
            throw new DataAccessResourceFailureException("Failed to take resource from pool", (Throwable)e);
        }
        ee.setKey(key);
        return ee;
    }

    private void releaseTemplate(SpaceMapEntry ee) {
        if (ee != null) {
            this.templatePool.offer(ee);
        }
    }
}

