/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.map;

import com.j_spaces.core.IJSpace;
import com.j_spaces.javax.cache.EvictionStrategy;
import com.j_spaces.map.IMap;
import org.openspaces.core.map.LocalCacheSupport;
import org.openspaces.core.map.MapFactoryBean;

public class MapConfigurer {
    private MapFactoryBean mapFactoryBean = new MapFactoryBean();
    private IMap map;
    private LocalCacheSupport localCacheSupport;

    public MapConfigurer(IJSpace space) {
        this.mapFactoryBean.setSpace(space);
    }

    public MapConfigurer clustered(boolean clustered) {
        this.mapFactoryBean.setClustered(clustered);
        return this;
    }

    public MapConfigurer compression(int compression) {
        this.mapFactoryBean.setCompression(compression);
        return this;
    }

    public MapConfigurer useLocalCache() {
        if (this.localCacheSupport == null) {
            this.localCacheSupport = new LocalCacheSupport();
        }
        return this;
    }

    public MapConfigurer localCacheVersioned(boolean versioned) {
        if (this.localCacheSupport == null) {
            this.localCacheSupport = new LocalCacheSupport();
        }
        this.localCacheSupport.setVersioned(versioned);
        return this;
    }

    public MapConfigurer localCacheEvictionStrategy(EvictionStrategy evictionStrategy) {
        if (this.localCacheSupport == null) {
            this.localCacheSupport = new LocalCacheSupport();
        }
        this.localCacheSupport.setEvictionStrategy(evictionStrategy);
        return this;
    }

    public MapConfigurer localCacheUpdateMode(UpdateMode updateMode) {
        if (this.localCacheSupport == null) {
            this.localCacheSupport = new LocalCacheSupport();
        }
        if (updateMode == UpdateMode.PULL) {
            this.localCacheSupport.setUpdateModeName("pull");
        } else if (updateMode == UpdateMode.PUSH) {
            this.localCacheSupport.setUpdateModeName("push");
        }
        return this;
    }

    public MapConfigurer localCachePutFirst(boolean putFirst) {
        if (this.localCacheSupport == null) {
            this.localCacheSupport = new LocalCacheSupport();
        }
        this.localCacheSupport.setPutFirst(putFirst);
        return this;
    }

    public MapConfigurer localCacheSizeLimit(int sizeLimit) {
        if (this.localCacheSupport == null) {
            this.localCacheSupport = new LocalCacheSupport();
        }
        this.localCacheSupport.setSizeLimit(sizeLimit);
        return this;
    }

    public IMap createMap() {
        if (this.map == null) {
            if (this.localCacheSupport != null) {
                this.mapFactoryBean.setLocalCacheSupport(this.localCacheSupport);
            }
            this.mapFactoryBean.afterPropertiesSet();
            this.map = (IMap)this.mapFactoryBean.getObject();
        }
        return this.map;
    }

    public IMap map() {
        return this.createMap();
    }

    public static enum UpdateMode {
        PULL,
        PUSH;

    }
}

