/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.map;

import com.gigaspaces.internal.client.cache.ISpaceCache;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.cache.map.MapCache;
import com.j_spaces.map.GSMapImpl;
import com.j_spaces.map.IMap;
import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.map.LocalCacheSupport;
import org.openspaces.core.space.CannotCreateSpaceException;
import org.openspaces.core.util.SpaceUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class MapFactoryBean
implements InitializingBean,
FactoryBean,
BeanNameAware {
    protected Log logger = LogFactory.getLog(this.getClass());
    private IJSpace space;
    private Boolean clustered;
    private String beanName;
    private IMap map;
    private int compression = 0;
    private LocalCacheSupport localCacheSupport;

    public void setSpace(IJSpace space) {
        this.space = space;
    }

    protected IJSpace getSpace() {
        return this.space;
    }

    public void setClustered(Boolean clustered) {
        this.clustered = clustered;
    }

    public void setCompression(int compression) {
        this.compression = compression;
    }

    public void setLocalCacheSupport(LocalCacheSupport localCacheSupport) {
        this.localCacheSupport = localCacheSupport;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.space, (String)"space property must be set");
        if (this.clustered == null) {
            if (this.space instanceof ISpaceCache) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Clustered flag automatically set to [" + this.clustered + "] since the space is a local cache space for bean [" + this.beanName + "]"));
                }
                this.clustered = true;
            } else {
                this.clustered = SpaceUtils.isRemoteProtocol((IJSpace)this.space);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Clustered flag automatically set to [" + this.clustered + "] for bean [" + this.beanName + "]"));
                }
            }
        }
        if (!this.clustered.booleanValue()) {
            this.space = SpaceUtils.getClusterMemberSpace((IJSpace)this.space);
        }
        this.map = this.createMap();
    }

    protected IMap createMap() {
        if (this.localCacheSupport == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Creating simple map over Space [" + this.getSpace() + "] with compression [" + this.compression + "]"));
            }
            return new GSMapImpl(this.getSpace(), this.compression);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating local cache map over Space [" + this.getSpace() + "] with compression [" + this.compression + "]"));
        }
        try {
            return new MapCache(this.getSpace(), this.localCacheSupport.isVersioned(), this.localCacheSupport.getLocalCacheUpdateMode(), this.localCacheSupport.getEvictionStrategy(), this.localCacheSupport.isPutFirst(), this.localCacheSupport.getSizeLimit(), this.compression);
        }
        catch (RemoteException e) {
            throw new CannotCreateSpaceException("Failed to create map using space [" + this.getSpace() + "]", (Throwable)e);
        }
    }

    public Object getObject() {
        return this.map;
    }

    public Class getObjectType() {
        return this.map == null ? IMap.class : this.map.getClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

