/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.archive;

import org.openspaces.archive.Archive;
import org.openspaces.archive.ArchiveOperationHandler;
import org.openspaces.archive.ArchivePollingContainerConfigurer;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.util.AnnotationUtils;
import org.openspaces.events.DynamicEventTemplateProvider;
import org.openspaces.events.TransactionalEvent;
import org.openspaces.events.support.AnnotationProcessorUtils;
import org.openspaces.events.support.EventContainersBus;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public class ArchivePollingAnnotationPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean == null) {
            return bean;
        }
        Class<?> beanClass = this.getBeanClass(bean);
        if (beanClass == null) {
            return bean;
        }
        Archive archive = AnnotationUtils.findAnnotation(beanClass, Archive.class);
        if (archive == null) {
            return bean;
        }
        GigaSpace gigaSpace = AnnotationProcessorUtils.findGigaSpace(bean, archive.gigaSpace(), this.applicationContext, beanName);
        ArchiveOperationHandler archiveHandler = AnnotationProcessorUtils.findArchiveHandler(bean, archive.archiveHandler(), this.applicationContext, beanName);
        EventContainersBus eventContainersBus = AnnotationProcessorUtils.findBus(this.applicationContext);
        ArchivePollingContainerConfigurer archiveContainerConfigurer = new ArchivePollingContainerConfigurer(gigaSpace).archiveHandler(archiveHandler).name(beanName).concurrentConsumers(archive.concurrentConsumers()).maxConcurrentConsumers(archive.maxConcurrentConsumers()).receiveTimeout(archive.receiveTimeout()).performSnapshot(archive.performSnapshot()).recoveryInterval(archive.recoveryInterval()).autoStart(archive.autoStart()).batchSize(archive.batchSize()).useFifoGrouping(archive.useFifoGrouping());
        Object staticTemplateProvider = AnnotationProcessorUtils.findTemplateFromProvider(bean);
        if (staticTemplateProvider != null) {
            archiveContainerConfigurer.template(staticTemplateProvider);
        } else {
            DynamicEventTemplateProvider templateProvider = AnnotationProcessorUtils.findDynamicEventTemplateProvider(bean);
            if (templateProvider != null) {
                archiveContainerConfigurer.dynamicTemplate(templateProvider);
            }
        }
        TransactionalEvent transactionalEvent = AnnotationUtils.findAnnotation(beanClass, TransactionalEvent.class);
        Transactional transactional = AnnotationUtils.findAnnotation(beanClass, Transactional.class);
        if (transactionalEvent != null || transactional != null) {
            if (transactionalEvent != null) {
                archiveContainerConfigurer.transactionManager(AnnotationProcessorUtils.findTxManager(transactionalEvent.transactionManager(), this.applicationContext, beanName));
            } else {
                archiveContainerConfigurer.transactionManager(AnnotationProcessorUtils.findTxManager("", this.applicationContext, beanName));
            }
            Isolation isolation = Isolation.DEFAULT;
            if (transactional != null && transactional.isolation() != Isolation.DEFAULT) {
                isolation = transactional.isolation();
            }
            if (transactionalEvent != null && transactionalEvent.isolation() != Isolation.DEFAULT) {
                isolation = transactionalEvent.isolation();
            }
            archiveContainerConfigurer.transactionIsolationLevel(isolation.value());
            int timeout = -1;
            if (transactional != null && transactional.timeout() != -1) {
                timeout = transactional.timeout();
            }
            if (transactionalEvent != null && transactionalEvent.timeout() != -1) {
                timeout = transactionalEvent.timeout();
            }
            archiveContainerConfigurer.transactionTimeout(timeout);
        }
        eventContainersBus.registerContainer(beanName, archiveContainerConfigurer.create());
        return bean;
    }

    private Class<?> getBeanClass(Object bean) {
        return AopUtils.getTargetClass((Object)bean);
    }
}

