/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.archive;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import org.openspaces.archive.ArchiveOperationHandler;
import org.openspaces.archive.DefaultArchivePollingContainerExceptionHandler;
import org.openspaces.core.GigaSpace;
import org.openspaces.events.SpaceDataEventListener;
import org.openspaces.events.polling.SimplePollingEventListenerContainer;
import org.openspaces.events.polling.receive.MultiTakeReceiveOperationHandler;
import org.openspaces.events.polling.receive.SingleTakeReceiveOperationHandler;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.transaction.TransactionStatus;

public class ArchivePollingContainer
extends SimplePollingEventListenerContainer
implements SpaceDataEventListener<Object> {
    private ArchiveOperationHandler archiveHandler;
    private int batchSize = 50;
    private long nonBlockingSleep = 100L;
    private boolean useFifoGrouping = false;

    public ArchivePollingContainer() {
        super.setEventListener(this);
    }

    @Required
    public void setArchiveHandler(ArchiveOperationHandler archiveHandler) {
        this.archiveHandler = archiveHandler;
    }

    @Override
    protected void validateConfiguration() {
        super.validateConfiguration();
        if (this.archiveHandler == null) {
            throw new IllegalStateException("Archive handler cannot be null");
        }
    }

    @Override
    public void initialize() {
        ISpaceProxy space = (ISpaceProxy)this.getGigaSpace().getSpace();
        boolean clustered = space.isClustered();
        if (this.archiveHandler.supportsBatchArchiving()) {
            MultiTakeReceiveOperationHandler receiveHandler = new MultiTakeReceiveOperationHandler();
            receiveHandler.setMaxEntries(this.batchSize);
            if (clustered) {
                receiveHandler.setNonBlocking(true);
                receiveHandler.setNonBlockingFactor(this.calcNonBlockingFactor());
            }
            receiveHandler.setUseFifoGrouping(this.isUseFifoGrouping());
            super.setReceiveOperationHandler(receiveHandler);
            super.setPassArrayAsIs(true);
        } else {
            SingleTakeReceiveOperationHandler receiveHandler = new SingleTakeReceiveOperationHandler();
            if (clustered) {
                receiveHandler.setNonBlocking(true);
                receiveHandler.setNonBlockingFactor(this.calcNonBlockingFactor());
                receiveHandler.setUseFifoGrouping(this.isUseFifoGrouping());
            }
            super.setReceiveOperationHandler(receiveHandler);
        }
        if (this.getExceptionHandler() == null) {
            this.setExceptionHandler(new DefaultArchivePollingContainerExceptionHandler());
        }
        super.initialize();
    }

    private int calcNonBlockingFactor() {
        long nonblockingFactor = this.getReceiveTimeout() / this.getNonBlockingSleep();
        return (int)Math.max(1L, nonblockingFactor);
    }

    @Override
    public void onEvent(Object data, GigaSpace gigaSpace, TransactionStatus txStatus, Object source) {
        if (this.isPassArrayAsIs()) {
            this.archiveHandler.archive((Object[])data);
        } else {
            this.archiveHandler.archive(data);
        }
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public long getNonBlockingSleep() {
        return this.nonBlockingSleep;
    }

    public void setNonBlockingSleep(long nonBlockingSleepMilliseconds) {
        this.nonBlockingSleep = nonBlockingSleepMilliseconds;
    }

    public boolean isUseFifoGrouping() {
        return this.useFifoGrouping;
    }

    public void setUseFifoGrouping(boolean useFifoGrouping) {
        this.useFifoGrouping = useFifoGrouping;
    }
}

