/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.archive;

import com.gigaspaces.time.SystemTime;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.GigaSpace;
import org.openspaces.events.EventExceptionHandler;
import org.openspaces.events.ListenerExecutionFailedException;
import org.springframework.transaction.TransactionStatus;

public class DefaultArchivePollingContainerExceptionHandler
implements EventExceptionHandler<Object> {
    private static final long DEFAULT_TIME_WINDOW_MILLIS = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
    private final Log logger = LogFactory.getLog(this.getClass());
    private Class<? extends Throwable> lastExceptionClass;
    private String lastExceptionMessage;
    private long lastExceptionTimestamp;
    private final long timeWindowMillis;

    public DefaultArchivePollingContainerExceptionHandler() {
        this(DEFAULT_TIME_WINDOW_MILLIS);
    }

    public DefaultArchivePollingContainerExceptionHandler(long timeWindowsMillis) {
        this.timeWindowMillis = timeWindowsMillis;
    }

    @Override
    public void onSuccess(Object data, GigaSpace gigaSpace, TransactionStatus txStatus, Object source) throws RuntimeException {
    }

    @Override
    public void onException(ListenerExecutionFailedException exception, Object data, GigaSpace gigaSpace, TransactionStatus txStatus, Object source) throws RuntimeException {
        long now = SystemTime.timeMillis();
        if (this.logger.isWarnEnabled() && this.shouldLog(exception, now)) {
            this.logger.warn((Object)"Failed to archive data", (Throwable)((Object)exception));
            this.storeLastException(exception, now);
        }
        throw exception;
    }

    public void storeLastException(ListenerExecutionFailedException exception, long now) {
        Throwable cause = exception.getCause();
        this.lastExceptionClass = cause == null ? null : cause.getClass();
        this.lastExceptionTimestamp = now;
        this.lastExceptionMessage = cause == null ? null : cause.getMessage();
    }

    public boolean shouldLog(ListenerExecutionFailedException exception, long now) {
        Throwable cause = exception.getCause();
        return !this.isSameExecptionType(cause) || !this.isSameMessage(cause) || !this.isSameTime(now);
    }

    private boolean isSameMessage(Throwable cause) {
        return cause == null && this.lastExceptionMessage == null || cause != null && cause.getMessage() == null && this.lastExceptionMessage == null || cause != null && this.lastExceptionMessage != null && this.lastExceptionMessage.equals(cause.getMessage());
    }

    private boolean isSameExecptionType(Throwable cause) {
        return cause == null && this.lastExceptionClass == null || cause != null && this.lastExceptionClass != null && this.lastExceptionClass.equals(cause.getClass());
    }

    private boolean isSameTime(long now) {
        return now - this.lastExceptionTimestamp < this.getTimeWindowMillis();
    }

    public long getTimeWindowMillis() {
        return this.timeWindowMillis;
    }
}

