/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.archive.config;

import org.openspaces.archive.ArchivePollingContainer;
import org.openspaces.events.config.AbstractTemplateEventContainerBeanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ArchivePollingContainerBeanDefinitionParser
extends AbstractTemplateEventContainerBeanDefinitionParser {
    private static final String RECEIVE_TIMEOUT = "receive-timeout";
    private static final String RECOVERY_INTERVAL = "recovery-interval";
    private static final String CONCURRENT_CONSUMERS = "concurrent-consumers";
    private static final String MAX_CONCURRENT_CONSUMERS = "max-concurrent-consumers";
    private static final String IDLE_TASK_EXECUTION_LIMIT = "idle-task-execution-limit";
    private static final String PERFORM_SNAPSHOT = "perform-snapshot";
    private static final String ARCHIVE_HANDLER = "archive-handler";
    private static final String BATCH_SIZE = "batch-size";
    private static final String CASSANDRA_USE_FIFO_GROUPING = "use-fifo-grouping";

    protected Class<ArchivePollingContainer> getBeanClass(Element element) {
        return ArchivePollingContainer.class;
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String useFifoGrouping;
        String batchSize;
        String performSnapshot;
        String idleTaskExecutionLimit;
        String maxConcurrentConsumers;
        String concurrentConsumers;
        String recoveryInterval;
        super.doParse(element, parserContext, builder);
        String archiveHandler = element.getAttribute(ARCHIVE_HANDLER);
        builder.addPropertyReference("archiveHandler", archiveHandler);
        String receiveTimeout = element.getAttribute(RECEIVE_TIMEOUT);
        if (StringUtils.hasLength((String)receiveTimeout)) {
            builder.addPropertyValue("receiveTimeout", (Object)receiveTimeout);
        }
        if (StringUtils.hasLength((String)(recoveryInterval = element.getAttribute(RECOVERY_INTERVAL)))) {
            builder.addPropertyValue("recoveryInterval", (Object)recoveryInterval);
        }
        if (StringUtils.hasLength((String)(concurrentConsumers = element.getAttribute(CONCURRENT_CONSUMERS)))) {
            builder.addPropertyValue("concurrentConsumers", (Object)concurrentConsumers);
        }
        if (StringUtils.hasLength((String)(maxConcurrentConsumers = element.getAttribute(MAX_CONCURRENT_CONSUMERS)))) {
            builder.addPropertyValue("maxConcurrentConsumers", (Object)maxConcurrentConsumers);
        }
        if (StringUtils.hasLength((String)(idleTaskExecutionLimit = element.getAttribute(IDLE_TASK_EXECUTION_LIMIT)))) {
            builder.addPropertyValue("idleTaskExecutionLimit", (Object)idleTaskExecutionLimit);
        }
        if (StringUtils.hasLength((String)(performSnapshot = element.getAttribute(PERFORM_SNAPSHOT)))) {
            builder.addPropertyValue("performSnapshot", (Object)performSnapshot);
        }
        if (StringUtils.hasLength((String)(batchSize = element.getAttribute(BATCH_SIZE)))) {
            builder.addPropertyValue("batchSize", (Object)batchSize);
        }
        if (StringUtils.hasLength((String)(useFifoGrouping = element.getAttribute(CASSANDRA_USE_FIFO_GROUPING)))) {
            builder.addPropertyValue("useFifoGrouping", (Object)useFifoGrouping);
        }
    }
}

