/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core;

import com.gigaspaces.client.ChangedEntryDetails;
import com.gigaspaces.client.FailedChangedEntryDetails;
import com.gigaspaces.internal.client.FailedChangedEntryDetailsImpl;
import java.util.ArrayList;
import java.util.Collection;
import org.openspaces.core.exception.ExceptionTranslator;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

public class ChangeException
extends InvalidDataAccessResourceUsageException {
    private static final long serialVersionUID = 1L;
    private final Collection<ChangedEntryDetails<?>> changedEntries;
    private final Collection<FailedChangedEntryDetails> translatedEntriesFailedToChange;
    private final Collection<Throwable> translatedErrors;
    private final int numChangedEntries;

    public ChangeException(com.gigaspaces.client.ChangeException changeException, ExceptionTranslator exceptionTranslator) {
        super(changeException.getMessage(), (Throwable)changeException);
        this.numChangedEntries = changeException.getNumSuccesfullChanges();
        this.changedEntries = changeException.getSuccesfullChanges();
        this.translatedEntriesFailedToChange = new ArrayList<FailedChangedEntryDetails>(changeException.getFailedChanges().size());
        for (FailedChangedEntryDetails failedChangeEntryResult : changeException.getFailedChanges()) {
            this.translatedEntriesFailedToChange.add((FailedChangedEntryDetails)new FailedChangedEntryDetailsImpl(failedChangeEntryResult.getTypeName(), failedChangeEntryResult.getId(), failedChangeEntryResult.getVersion(), (Throwable)ChangeException.translateException(exceptionTranslator, failedChangeEntryResult.getCause())));
        }
        this.translatedErrors = new ArrayList<Throwable>(changeException.getErrors().size());
        for (Throwable error : changeException.getErrors()) {
            this.translatedErrors.add(ChangeException.translateException(exceptionTranslator, error));
        }
    }

    private static Exception translateException(ExceptionTranslator exceptionTranslator, Throwable error) {
        Object translatedException;
        try {
            translatedException = exceptionTranslator.translate(error);
        }
        catch (Exception e) {
            translatedException = e;
        }
        return translatedException;
    }

    public Collection<ChangedEntryDetails<?>> getSuccesfullChanges() {
        if (this.changedEntries == null) {
            throw new UnsupportedOperationException(" no detailed information available: operation modifier not set to return detailed change result");
        }
        return this.changedEntries;
    }

    public int getNumSuccesfullChanges() {
        return this.numChangedEntries;
    }

    public Collection<FailedChangedEntryDetails> getFailedChanges() {
        return this.translatedEntriesFailedToChange;
    }

    public Collection<Throwable> getErrors() {
        return this.translatedErrors;
    }
}

