/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core;

import com.gigaspaces.admin.quiesce.QuiesceToken;
import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResultFilter;
import com.gigaspaces.async.AsyncResultsReducer;
import com.gigaspaces.async.FutureFactory;
import com.gigaspaces.client.ChangeModifiers;
import com.gigaspaces.client.ChangeResult;
import com.gigaspaces.client.ChangeSet;
import com.gigaspaces.client.ClearModifiers;
import com.gigaspaces.client.CountModifiers;
import com.gigaspaces.client.IsolationLevelModifiers;
import com.gigaspaces.client.ReadByIdsResult;
import com.gigaspaces.client.ReadByIdsResultImpl;
import com.gigaspaces.client.ReadModifiers;
import com.gigaspaces.client.TakeByIdsResult;
import com.gigaspaces.client.TakeByIdsResultImpl;
import com.gigaspaces.client.TakeModifiers;
import com.gigaspaces.client.WriteModifiers;
import com.gigaspaces.client.iterator.SpaceIterator;
import com.gigaspaces.events.DataEventSession;
import com.gigaspaces.events.DataEventSessionFactory;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.cache.ISpaceCache;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.utils.ObjectUtils;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.query.ISpaceQuery;
import com.gigaspaces.query.IdQuery;
import com.gigaspaces.query.IdsQuery;
import com.gigaspaces.query.QueryResultType;
import com.gigaspaces.query.aggregators.AggregationResult;
import com.gigaspaces.query.aggregators.AggregationSet;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.LeaseContext;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.concurrent.Future;
import net.jini.core.transaction.Transaction;
import org.openspaces.core.DefaultGigaSpaceTypeManager;
import org.openspaces.core.ExecutorBuilder;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.GigaSpaceTypeManager;
import org.openspaces.core.IsolationLevelHelpers;
import org.openspaces.core.IteratorBuilder;
import org.openspaces.core.exception.DefaultExceptionTranslator;
import org.openspaces.core.exception.ExceptionTranslator;
import org.openspaces.core.executor.DistributedTask;
import org.openspaces.core.executor.Task;
import org.openspaces.core.executor.TaskRoutingProvider;
import org.openspaces.core.executor.internal.ExecutorMetaDataProvider;
import org.openspaces.core.executor.internal.InternalDistributedSpaceTaskWrapper;
import org.openspaces.core.executor.internal.InternalSpaceTaskWrapper;
import org.openspaces.core.internal.InternalGigaSpace;
import org.openspaces.core.transaction.DefaultTransactionProvider;
import org.openspaces.core.transaction.TransactionProvider;
import org.openspaces.core.transaction.internal.InternalAsyncFuture;
import org.openspaces.core.transaction.internal.InternalAsyncFutureListener;
import org.openspaces.core.util.SpaceUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.util.Assert;

public class DefaultGigaSpace
implements GigaSpace,
InternalGigaSpace {
    private String name;
    private final ISpaceProxy space;
    private final TransactionProvider txProvider;
    private final boolean implicitTxProvider;
    private final ExceptionTranslator exTranslator;
    private final GigaSpaceTypeManager typeManager;
    private long defaultReadTimeout = 0L;
    private long defaultTakeTimeout = 0L;
    private long defaultWriteLease = Long.MAX_VALUE;
    private final int springIsolationLevel;
    private final int defaultIsolationLevel;
    private WriteModifiers defaultWriteModifiers;
    private ReadModifiers defaultReadModifiers;
    private TakeModifiers defaultTakeModifiers;
    private CountModifiers defaultCountModifiers;
    private ClearModifiers defaultClearModifiers;
    private ChangeModifiers defaultChangeModifiers;
    private final ExecutorMetaDataProvider executorMetaDataProvider = new ExecutorMetaDataProvider();
    private DefaultGigaSpace clusteredGigaSpace;

    public DefaultGigaSpace(GigaSpaceConfigurer configurer) {
        this.space = DefaultGigaSpace.initSpace(configurer);
        this.txProvider = configurer.getTxProvider() != null ? configurer.getTxProvider() : new DefaultTransactionProvider((IJSpace)this.space, configurer.getTransactionManager());
        this.implicitTxProvider = configurer.getTxProvider() == null;
        this.name = configurer.getName() != null ? configurer.getName() : this.space.getName();
        this.exTranslator = configurer.getExTranslator() != null ? configurer.getExTranslator() : new DefaultExceptionTranslator();
        this.typeManager = new DefaultGigaSpaceTypeManager(this.space, this.exTranslator);
        this.springIsolationLevel = configurer.getDefaultIsolationLevel();
        this.defaultIsolationLevel = IsolationLevelHelpers.convertSpringToSpaceIsolationLevel(this.springIsolationLevel, this.space.getReadModifiers());
        this.defaultCountModifiers = IsolationLevelHelpers.toCountModifiers(this.defaultIsolationLevel);
        this.defaultReadModifiers = IsolationLevelHelpers.toReadModifiers(this.defaultIsolationLevel);
        this.setDefaultReadTimeout(configurer.getDefaultReadTimeout());
        this.setDefaultTakeTimeout(configurer.getDefaultTakeTimeout());
        this.setDefaultWriteLease(configurer.getDefaultWriteLease());
        this.setDefaultWriteModifiers(configurer.getDefaultWriteModifiers());
        this.setDefaultReadModifiers(configurer.getDefaultReadModifiers());
        this.setDefaultTakeModifiers(configurer.getDefaultTakeModifiers());
        this.setDefaultCountModifiers(configurer.getDefaultCountModifiers());
        this.setDefaultClearModifiers(configurer.getDefaultClearModifiers());
        this.setDefaultChangeModifiers(configurer.getDefaultChangeModifiers());
    }

    private DefaultGigaSpace(IJSpace space, DefaultGigaSpace other) {
        this.space = (ISpaceProxy)space;
        this.txProvider = other.txProvider;
        this.implicitTxProvider = other.implicitTxProvider;
        this.exTranslator = other.exTranslator;
        this.typeManager = new DefaultGigaSpaceTypeManager(this.space, this.exTranslator);
        this.defaultIsolationLevel = other.defaultIsolationLevel;
        this.springIsolationLevel = other.springIsolationLevel;
        this.name = other.name;
        this.defaultReadTimeout = other.defaultReadTimeout;
        this.defaultTakeTimeout = other.defaultTakeTimeout;
        this.defaultWriteLease = other.defaultWriteLease;
        this.defaultChangeModifiers = other.defaultChangeModifiers;
        this.defaultClearModifiers = other.defaultClearModifiers;
        this.defaultCountModifiers = other.defaultCountModifiers;
        this.defaultReadModifiers = other.defaultReadModifiers;
        this.defaultWriteModifiers = other.defaultWriteModifiers;
        this.defaultTakeModifiers = other.defaultTakeModifiers;
    }

    private static ISpaceProxy initSpace(GigaSpaceConfigurer configurer) {
        ISpaceProxy space = (ISpaceProxy)configurer.getSpace();
        Assert.notNull((Object)space, (String)"space property is required");
        boolean clustered = configurer.getClustered() != null ? configurer.getClustered() : space instanceof ISpaceCache || SpaceUtils.isRemoteProtocol((IJSpace)space);
        return !clustered && space.isClustered() ? (ISpaceProxy)SpaceUtils.getClusterMemberSpace((IJSpace)space) : space;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSecured() {
        return this.space.isSecured();
    }

    public void setDefaultReadTimeout(long defaultReadTimeout) {
        this.defaultReadTimeout = defaultReadTimeout;
    }

    public long getDefaultReadTimeout() {
        return this.defaultReadTimeout;
    }

    public void setDefaultTakeTimeout(long defaultTakeTimeout) {
        this.defaultTakeTimeout = defaultTakeTimeout;
    }

    public long getDefaultTakeTimeout() {
        return this.defaultTakeTimeout;
    }

    public void setDefaultWriteLease(long defaultWriteLease) {
        this.defaultWriteLease = defaultWriteLease;
    }

    public long getDefaultWriteLease() {
        return this.defaultWriteLease;
    }

    public int getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    public void setDefaultWriteModifiers(WriteModifiers modifiers) {
        this.defaultWriteModifiers = modifiers != null ? modifiers : WriteModifiers.NONE;
    }

    public void setDefaultClearModifiers(ClearModifiers modifiers) {
        this.defaultClearModifiers = modifiers != null ? modifiers : ClearModifiers.NONE;
    }

    public void setDefaultCountModifiers(CountModifiers modifiers) {
        this.defaultCountModifiers = modifiers == null || modifiers.getCode() == 0 ? IsolationLevelHelpers.toCountModifiers(this.defaultIsolationLevel) : this.validateWithDefaultIsolationLevel(modifiers, "count");
    }

    public void setDefaultReadModifiers(ReadModifiers modifiers) {
        this.defaultReadModifiers = modifiers == null || modifiers.getCode() == 0 ? IsolationLevelHelpers.toReadModifiers(this.defaultIsolationLevel) : this.validateWithDefaultIsolationLevel(modifiers, "read");
    }

    public void setDefaultTakeModifiers(TakeModifiers modifiers) {
        this.defaultTakeModifiers = modifiers != null ? modifiers : TakeModifiers.NONE;
    }

    public void setDefaultChangeModifiers(ChangeModifiers modifiers) {
        this.defaultChangeModifiers = modifiers != null ? modifiers : ChangeModifiers.NONE;
    }

    private <T extends IsolationLevelModifiers> T validateWithDefaultIsolationLevel(T modifiers, String name) {
        if (this.springIsolationLevel == 4 && !modifiers.isRepeatableRead() || this.springIsolationLevel == 2 && !modifiers.isReadCommitted() || this.springIsolationLevel == 1 && !modifiers.isDirtyRead()) {
            throw new IllegalArgumentException("Cannot configure conflicting isolation level and default " + name + " modifiers." + StringUtils.NEW_LINE + "defaultIsolationLevel [" + this.defaultIsolationLevel + "]" + StringUtils.NEW_LINE + "default " + name + " modifiers [" + modifiers.getCode() + "]");
        }
        return modifiers;
    }

    @Override
    public WriteModifiers getDefaultWriteModifiers() {
        return this.defaultWriteModifiers;
    }

    @Override
    public ClearModifiers getDefaultClearModifiers() {
        return this.defaultClearModifiers;
    }

    @Override
    public CountModifiers getDefaultCountModifiers() {
        return (CountModifiers)this.defaultCountModifiers.setIsolationLevel(this.getTxProvider().getCurrentTransactionIsolationLevel());
    }

    @Override
    public ReadModifiers getDefaultReadModifiers() {
        return (ReadModifiers)this.defaultReadModifiers.setIsolationLevel(this.getTxProvider().getCurrentTransactionIsolationLevel());
    }

    @Override
    public TakeModifiers getDefaultTakeModifiers() {
        return this.defaultTakeModifiers;
    }

    @Override
    public ChangeModifiers getDefaultChangeModifiers() {
        return this.defaultChangeModifiers;
    }

    @Override
    public IJSpace getSpace() {
        return this.space;
    }

    @Override
    public GigaSpace getClustered() {
        if (this.clusteredGigaSpace != null) {
            return this.clusteredGigaSpace;
        }
        if (this.space.isClustered()) {
            this.clusteredGigaSpace = this;
        } else {
            DefaultGigaSpace newClusteredGigaSpace;
            try {
                newClusteredGigaSpace = new DefaultGigaSpace(this.space.getDirectProxy().getClusteredProxy(), this);
            }
            catch (Exception e) {
                throw new InvalidDataAccessApiUsageException("Failed to get clustered Space from actual space", (Throwable)e);
            }
            if (this.clusteredGigaSpace == null) {
                this.clusteredGigaSpace = newClusteredGigaSpace;
            }
        }
        return this.clusteredGigaSpace;
    }

    @Override
    public TransactionProvider getTxProvider() {
        return this.txProvider;
    }

    @Override
    public ExceptionTranslator getExceptionTranslator() {
        return this.exTranslator;
    }

    @Override
    public void clear(Object template) throws DataAccessException {
        try {
            this.space.clear(template, this.getCurrentTransaction(), this.defaultClearModifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public int clear(Object template, ClearModifiers modifiers) throws DataAccessException {
        try {
            return this.space.clear(template, this.getCurrentTransaction(), modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public int count(Object template) throws DataAccessException {
        try {
            return this.space.count(template, this.getCurrentTransaction(), this.getDefaultCountModifiers().getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public int count(Object template, CountModifiers modifiers) throws DataAccessException {
        try {
            return this.space.count(template, this.getCurrentTransaction(), modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ISpaceQuery<T> snapshot(Object entry) throws DataAccessException {
        try {
            return this.space.snapshot(entry);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T readById(Class<T> clazz, Object id) {
        return this.readById(clazz, id, null, this.defaultReadTimeout, this.getDefaultReadModifiers());
    }

    @Override
    public <T> T readById(Class<T> clazz, Object id, Object routing) {
        return this.readById(clazz, id, routing, this.defaultReadTimeout, this.getDefaultReadModifiers());
    }

    @Override
    public <T> T readById(Class<T> clazz, Object id, Object routing, long timeout) {
        return this.readById(clazz, id, routing, timeout, this.getDefaultReadModifiers());
    }

    @Override
    public <T> T readById(Class<T> clazz, Object id, Object routing, long timeout, ReadModifiers modifiers) {
        try {
            return (T)this.space.readById(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), id, routing, this.getCurrentTransaction(), timeout, modifiers.getCode(), false, QueryResultTypeInternal.NOT_SET, null);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T readById(IdQuery<T> query) throws DataAccessException {
        try {
            return (T)this.space.readById(query.getTypeName(), query.getId(), query.getRouting(), this.getCurrentTransaction(), this.defaultReadTimeout, this.getDefaultReadModifiers().getCode(), false, DefaultGigaSpace.toInternal(query.getQueryResultType()), query.getProjections());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T readById(IdQuery<T> query, long timeout) throws DataAccessException {
        try {
            return (T)this.space.readById(query.getTypeName(), query.getId(), query.getRouting(), this.getCurrentTransaction(), timeout, this.getDefaultReadModifiers().getCode(), false, DefaultGigaSpace.toInternal(query.getQueryResultType()), query.getProjections());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T readById(IdQuery<T> query, long timeout, ReadModifiers modifiers) throws DataAccessException {
        try {
            return (T)this.space.readById(query.getTypeName(), query.getId(), query.getRouting(), this.getCurrentTransaction(), timeout, modifiers.getCode(), false, DefaultGigaSpace.toInternal(query.getQueryResultType()), query.getProjections());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T read(T template) throws DataAccessException {
        return this.read(template, this.defaultReadTimeout);
    }

    @Override
    public <T> T read(T template, long timeout) throws DataAccessException {
        return this.read(template, timeout, this.getDefaultReadModifiers());
    }

    @Override
    public <T> T read(T template, long timeout, ReadModifiers modifiers) throws DataAccessException {
        try {
            return (T)this.space.read(template, this.getCurrentTransaction(), timeout, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T read(ISpaceQuery<T> template) throws DataAccessException {
        return this.read(template, this.defaultReadTimeout);
    }

    @Override
    public <T> T read(ISpaceQuery<T> template, long timeout) throws DataAccessException {
        return this.read(template, timeout, this.getDefaultReadModifiers());
    }

    @Override
    public <T> T read(ISpaceQuery<T> template, long timeout, ReadModifiers modifiers) throws DataAccessException {
        try {
            return (T)this.space.read(template, this.getCurrentTransaction(), timeout, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> AsyncFuture<T> asyncRead(T template) throws DataAccessException {
        return this.asyncRead(template, this.defaultReadTimeout, this.getDefaultReadModifiers(), null);
    }

    @Override
    public <T> AsyncFuture<T> asyncRead(T template, AsyncFutureListener<T> listener) throws DataAccessException {
        return this.asyncRead(template, this.defaultReadTimeout, this.getDefaultReadModifiers(), listener);
    }

    @Override
    public <T> AsyncFuture<T> asyncRead(T template, long timeout) throws DataAccessException {
        return this.asyncRead(template, timeout, this.getDefaultReadModifiers(), null);
    }

    @Override
    public <T> AsyncFuture<T> asyncRead(T template, long timeout, AsyncFutureListener<T> listener) throws DataAccessException {
        return this.asyncRead(template, timeout, this.getDefaultReadModifiers(), listener);
    }

    @Override
    public <T> AsyncFuture<T> asyncRead(T template, long timeout, ReadModifiers modifiers) throws DataAccessException {
        return this.asyncRead(template, timeout, modifiers, null);
    }

    @Override
    public <T> AsyncFuture<T> asyncRead(T template, long timeout, ReadModifiers modifiers, AsyncFutureListener<T> listener) throws DataAccessException {
        Transaction tx = this.getCurrentTransaction();
        try {
            return this.wrapFuture(this.space.asyncRead(template, tx, timeout, modifiers.getCode(), this.wrapListener(listener, tx)), tx);
        }
        catch (RemoteException e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> AsyncFuture<T> asyncRead(ISpaceQuery<T> template) throws DataAccessException {
        return this.asyncRead(template, this.defaultReadTimeout, this.getDefaultReadModifiers(), (AsyncFutureListener)null);
    }

    @Override
    public <T> AsyncFuture<T> asyncRead(ISpaceQuery<T> template, AsyncFutureListener<T> listener) throws DataAccessException {
        return this.asyncRead(template, this.defaultReadTimeout, this.getDefaultReadModifiers(), listener);
    }

    @Override
    public <T> AsyncFuture<T> asyncRead(ISpaceQuery<T> template, long timeout) throws DataAccessException {
        return this.asyncRead(template, timeout, this.getDefaultReadModifiers(), (AsyncFutureListener)null);
    }

    @Override
    public <T> AsyncFuture<T> asyncRead(ISpaceQuery<T> template, long timeout, AsyncFutureListener<T> listener) throws DataAccessException {
        return this.asyncRead(template, timeout, this.getDefaultReadModifiers(), listener);
    }

    @Override
    public <T> AsyncFuture<T> asyncRead(ISpaceQuery<T> template, long timeout, ReadModifiers modifiers) throws DataAccessException {
        return this.asyncRead(template, timeout, modifiers, (AsyncFutureListener)null);
    }

    @Override
    public <T> AsyncFuture<T> asyncRead(ISpaceQuery<T> template, long timeout, ReadModifiers modifiers, AsyncFutureListener<T> listener) throws DataAccessException {
        Transaction tx = this.getCurrentTransaction();
        try {
            return this.wrapFuture(this.space.asyncRead(template, tx, timeout, modifiers.getCode(), this.wrapListener(listener, tx)), tx);
        }
        catch (RemoteException e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T readIfExistsById(Class<T> clazz, Object id) {
        return this.readIfExistsById(clazz, id, null, this.defaultReadTimeout, this.getDefaultReadModifiers());
    }

    @Override
    public <T> T readIfExistsById(Class<T> clazz, Object id, Object routing) {
        return this.readIfExistsById(clazz, id, routing, this.defaultReadTimeout, this.getDefaultReadModifiers());
    }

    @Override
    public <T> T readIfExistsById(Class<T> clazz, Object id, Object routing, long timeout) {
        return this.readIfExistsById(clazz, id, routing, timeout, this.getDefaultReadModifiers());
    }

    @Override
    public <T> T readIfExistsById(Class<T> clazz, Object id, Object routing, long timeout, ReadModifiers modifiers) {
        try {
            return (T)this.space.readById(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), id, routing, this.getCurrentTransaction(), timeout, modifiers.getCode(), true, QueryResultTypeInternal.NOT_SET, null);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T readIfExistsById(IdQuery<T> query) throws DataAccessException {
        try {
            return (T)this.space.readById(query.getTypeName(), query.getId(), query.getRouting(), this.getCurrentTransaction(), this.defaultReadTimeout, this.getDefaultReadModifiers().getCode(), true, DefaultGigaSpace.toInternal(query.getQueryResultType()), query.getProjections());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T readIfExistsById(IdQuery<T> query, long timeout) throws DataAccessException {
        try {
            return (T)this.space.readById(query.getTypeName(), query.getId(), query.getRouting(), this.getCurrentTransaction(), timeout, this.getDefaultReadModifiers().getCode(), true, DefaultGigaSpace.toInternal(query.getQueryResultType()), query.getProjections());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T readIfExistsById(IdQuery<T> query, long timeout, ReadModifiers modifiers) throws DataAccessException {
        try {
            return (T)this.space.readById(query.getTypeName(), query.getId(), query.getRouting(), this.getCurrentTransaction(), timeout, modifiers.getCode(), true, DefaultGigaSpace.toInternal(query.getQueryResultType()), query.getProjections());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T readIfExists(T template) throws DataAccessException {
        return this.readIfExists(template, this.defaultReadTimeout);
    }

    @Override
    public <T> T readIfExists(T template, long timeout) throws DataAccessException {
        return this.readIfExists(template, timeout, this.getDefaultReadModifiers());
    }

    @Override
    public <T> T readIfExists(T template, long timeout, ReadModifiers modifiers) throws DataAccessException {
        try {
            return (T)this.space.readIfExists(template, this.getCurrentTransaction(), timeout, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T readIfExists(ISpaceQuery<T> template) throws DataAccessException {
        return this.readIfExists(template, this.defaultReadTimeout);
    }

    @Override
    public <T> T readIfExists(ISpaceQuery<T> template, long timeout) throws DataAccessException {
        return this.readIfExists(template, timeout, this.getDefaultReadModifiers());
    }

    @Override
    public <T> T readIfExists(ISpaceQuery<T> template, long timeout, ReadModifiers modifiers) throws DataAccessException {
        try {
            return (T)this.space.readIfExists(template, this.getCurrentTransaction(), timeout, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T[] readMultiple(T template) throws DataAccessException {
        return this.readMultiple(template, Integer.MAX_VALUE);
    }

    @Override
    public <T> T[] readMultiple(T template, int maxEntries) throws DataAccessException {
        return this.readMultiple(template, maxEntries, this.getDefaultReadModifiers());
    }

    @Override
    public <T> T[] readMultiple(T template, int maxEntries, ReadModifiers modifiers) throws DataAccessException {
        try {
            return this.space.readMultiple(template, this.getCurrentTransaction(), maxEntries, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T[] readMultiple(ISpaceQuery<T> template) throws DataAccessException {
        return this.readMultiple(template, Integer.MAX_VALUE);
    }

    @Override
    public <T> T[] readMultiple(ISpaceQuery<T> template, int maxEntries) throws DataAccessException {
        return this.readMultiple(template, maxEntries, this.getDefaultReadModifiers());
    }

    @Override
    public <T> T[] readMultiple(ISpaceQuery<T> template, int maxEntries, ReadModifiers modifiers) throws DataAccessException {
        try {
            return this.space.readMultiple(template, this.getCurrentTransaction(), maxEntries, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T takeById(Class<T> clazz, Object id) {
        return this.takeById(clazz, id, null, this.defaultTakeTimeout, this.defaultTakeModifiers);
    }

    @Override
    public <T> T takeById(Class<T> clazz, Object id, Object routing) {
        return this.takeById(clazz, id, routing, this.defaultTakeTimeout, this.defaultTakeModifiers);
    }

    @Override
    public <T> T takeById(Class<T> clazz, Object id, Object routing, long timeout) {
        return this.takeById(clazz, id, routing, timeout, this.defaultTakeModifiers);
    }

    @Override
    public <T> T takeById(Class<T> clazz, Object id, Object routing, long timeout, TakeModifiers modifiers) {
        try {
            return (T)this.space.takeById(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), id, routing, 0, this.getCurrentTransaction(), timeout, modifiers.getCode(), false, QueryResultTypeInternal.NOT_SET, null);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T takeById(IdQuery<T> query) throws DataAccessException {
        try {
            return (T)this.space.takeById(query.getTypeName(), query.getId(), query.getRouting(), query.getVersion(), this.getCurrentTransaction(), this.defaultTakeTimeout, this.defaultTakeModifiers.getCode(), false, DefaultGigaSpace.toInternal(query.getQueryResultType()), query.getProjections());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T takeById(IdQuery<T> query, long timeout) throws DataAccessException {
        try {
            return (T)this.space.takeById(query.getTypeName(), query.getId(), query.getRouting(), query.getVersion(), this.getCurrentTransaction(), timeout, this.defaultTakeModifiers.getCode(), false, DefaultGigaSpace.toInternal(query.getQueryResultType()), query.getProjections());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T takeById(IdQuery<T> query, long timeout, TakeModifiers modifiers) throws DataAccessException {
        try {
            return (T)this.space.takeById(query.getTypeName(), query.getId(), query.getRouting(), query.getVersion(), this.getCurrentTransaction(), timeout, modifiers.getCode(), false, DefaultGigaSpace.toInternal(query.getQueryResultType()), query.getProjections());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T take(T template) throws DataAccessException {
        return this.take(template, this.defaultTakeTimeout);
    }

    @Override
    public <T> T take(T template, long timeout) throws DataAccessException {
        return this.take(template, timeout, this.defaultTakeModifiers);
    }

    @Override
    public <T> T take(T template, long timeout, TakeModifiers modifiers) throws DataAccessException {
        try {
            return (T)this.space.take(template, this.getCurrentTransaction(), timeout, modifiers.getCode(), false);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T take(ISpaceQuery<T> template) throws DataAccessException {
        return this.take(template, this.defaultTakeTimeout);
    }

    @Override
    public <T> T take(ISpaceQuery<T> template, long timeout) throws DataAccessException {
        return this.take(template, timeout, this.defaultTakeModifiers);
    }

    @Override
    public <T> T take(ISpaceQuery<T> template, long timeout, TakeModifiers modifiers) throws DataAccessException {
        try {
            return (T)this.space.take(template, this.getCurrentTransaction(), timeout, modifiers.getCode(), false);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> AsyncFuture<T> asyncTake(T template) throws DataAccessException {
        return this.asyncTake(template, this.defaultTakeTimeout, this.defaultTakeModifiers, null);
    }

    @Override
    public <T> AsyncFuture<T> asyncTake(T template, AsyncFutureListener<T> listener) throws DataAccessException {
        return this.asyncTake(template, this.defaultTakeTimeout, this.defaultTakeModifiers, listener);
    }

    @Override
    public <T> AsyncFuture<T> asyncTake(T template, long timeout) throws DataAccessException {
        return this.asyncTake(template, timeout, this.defaultTakeModifiers, null);
    }

    @Override
    public <T> AsyncFuture<T> asyncTake(T template, long timeout, AsyncFutureListener<T> listener) throws DataAccessException {
        return this.asyncTake(template, timeout, this.defaultTakeModifiers, listener);
    }

    @Override
    public <T> AsyncFuture<T> asyncTake(T template, long timeout, TakeModifiers modifiers) throws DataAccessException {
        return this.asyncTake(template, timeout, modifiers, null);
    }

    @Override
    public <T> AsyncFuture<T> asyncTake(T template, long timeout, TakeModifiers modifiers, AsyncFutureListener<T> listener) throws DataAccessException {
        Transaction tx = this.getCurrentTransaction();
        try {
            return this.wrapFuture(this.space.asyncTake(template, tx, timeout, modifiers.getCode(), this.wrapListener(listener, tx)), tx);
        }
        catch (RemoteException e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> AsyncFuture<T> asyncTake(ISpaceQuery<T> template) throws DataAccessException {
        return this.asyncTake(template, this.defaultTakeTimeout, this.defaultTakeModifiers, (AsyncFutureListener)null);
    }

    @Override
    public <T> AsyncFuture<T> asyncTake(ISpaceQuery<T> template, AsyncFutureListener<T> listener) throws DataAccessException {
        return this.asyncTake(template, this.defaultTakeTimeout, this.defaultTakeModifiers, listener);
    }

    @Override
    public <T> AsyncFuture<T> asyncTake(ISpaceQuery<T> template, long timeout) throws DataAccessException {
        return this.asyncTake(template, timeout, this.defaultTakeModifiers, (AsyncFutureListener)null);
    }

    @Override
    public <T> AsyncFuture<T> asyncTake(ISpaceQuery<T> template, long timeout, AsyncFutureListener<T> listener) throws DataAccessException {
        return this.asyncTake(template, timeout, this.defaultTakeModifiers, listener);
    }

    @Override
    public <T> AsyncFuture<T> asyncTake(ISpaceQuery<T> template, long timeout, TakeModifiers modifiers) throws DataAccessException {
        return this.asyncTake(template, timeout, modifiers, (AsyncFutureListener)null);
    }

    @Override
    public <T> AsyncFuture<T> asyncTake(ISpaceQuery<T> template, long timeout, TakeModifiers modifiers, AsyncFutureListener<T> listener) throws DataAccessException {
        Transaction tx = this.getCurrentTransaction();
        try {
            return this.wrapFuture(this.space.asyncTake(template, tx, timeout, modifiers.getCode(), this.wrapListener(listener, tx)), tx);
        }
        catch (RemoteException e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T takeIfExistsById(Class<T> clazz, Object id) {
        return this.takeIfExistsById(clazz, id, null, this.defaultTakeTimeout, this.defaultTakeModifiers);
    }

    @Override
    public <T> T takeIfExistsById(Class<T> clazz, Object id, Object routing) {
        return this.takeIfExistsById(clazz, id, routing, this.defaultTakeTimeout, this.defaultTakeModifiers);
    }

    @Override
    public <T> T takeIfExistsById(Class<T> clazz, Object id, Object routing, long timeout) {
        return this.takeIfExistsById(clazz, id, routing, timeout, this.defaultTakeModifiers);
    }

    @Override
    public <T> T takeIfExistsById(Class<T> clazz, Object id, Object routing, long timeout, TakeModifiers modifiers) {
        try {
            return (T)this.space.takeById(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), id, routing, 0, this.getCurrentTransaction(), timeout, modifiers.getCode(), true, QueryResultTypeInternal.NOT_SET, null);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T takeIfExistsById(IdQuery<T> query) throws DataAccessException {
        try {
            return (T)this.space.takeById(query.getTypeName(), query.getId(), query.getRouting(), query.getVersion(), this.getCurrentTransaction(), this.defaultTakeTimeout, this.defaultTakeModifiers.getCode(), true, DefaultGigaSpace.toInternal(query.getQueryResultType()), query.getProjections());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T takeIfExistsById(IdQuery<T> query, long timeout) throws DataAccessException {
        try {
            return (T)this.space.takeById(query.getTypeName(), query.getId(), query.getRouting(), query.getVersion(), this.getCurrentTransaction(), timeout, this.defaultTakeModifiers.getCode(), true, DefaultGigaSpace.toInternal(query.getQueryResultType()), query.getProjections());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T takeIfExistsById(IdQuery<T> query, long timeout, TakeModifiers modifiers) throws DataAccessException {
        try {
            return (T)this.space.takeById(query.getTypeName(), query.getId(), query.getRouting(), query.getVersion(), this.getCurrentTransaction(), timeout, modifiers.getCode(), true, DefaultGigaSpace.toInternal(query.getQueryResultType()), query.getProjections());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T takeIfExists(T template) throws DataAccessException {
        return this.takeIfExists(template, this.defaultTakeTimeout, this.defaultTakeModifiers);
    }

    @Override
    public <T> T takeIfExists(T template, long timeout) throws DataAccessException {
        return this.takeIfExists(template, timeout, this.defaultTakeModifiers);
    }

    @Override
    public <T> T takeIfExists(T template, long timeout, TakeModifiers modifiers) throws DataAccessException {
        try {
            return (T)this.space.take(template, this.getCurrentTransaction(), timeout, modifiers.getCode(), true);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T takeIfExists(ISpaceQuery<T> template) throws DataAccessException {
        return this.takeIfExists(template, this.defaultTakeTimeout, this.defaultTakeModifiers);
    }

    @Override
    public <T> T takeIfExists(ISpaceQuery<T> template, long timeout) throws DataAccessException {
        return this.takeIfExists(template, timeout, this.defaultTakeModifiers);
    }

    @Override
    public <T> T takeIfExists(ISpaceQuery<T> template, long timeout, TakeModifiers modifiers) throws DataAccessException {
        try {
            return (T)this.space.take(template, this.getCurrentTransaction(), timeout, modifiers.getCode(), true);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T[] takeMultiple(T template) throws DataAccessException {
        return this.takeMultiple(template, Integer.MAX_VALUE);
    }

    @Override
    public <T> T[] takeMultiple(T template, int maxEntries) throws DataAccessException {
        try {
            return this.space.takeMultiple(template, this.getCurrentTransaction(), maxEntries, this.defaultTakeModifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T[] takeMultiple(ISpaceQuery<T> template) throws DataAccessException {
        return this.takeMultiple(template, Integer.MAX_VALUE);
    }

    @Override
    public <T> T[] takeMultiple(ISpaceQuery<T> template, int maxEntries) throws DataAccessException {
        try {
            return this.space.takeMultiple(template, this.getCurrentTransaction(), maxEntries, this.defaultTakeModifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T[] takeMultiple(T template, int maxEntries, TakeModifiers modifiers) throws DataAccessException {
        try {
            return this.space.takeMultiple(template, this.getCurrentTransaction(), maxEntries, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> T[] takeMultiple(ISpaceQuery<T> template, int maxEntries, TakeModifiers modifiers) throws DataAccessException {
        try {
            return this.space.takeMultiple(template, this.getCurrentTransaction(), maxEntries, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> LeaseContext<T> write(T entry) throws DataAccessException {
        return this.write(entry, this.defaultWriteLease);
    }

    @Override
    public <T> LeaseContext<T> write(T entry, long lease) throws DataAccessException {
        try {
            return this.space.write(entry, this.getCurrentTransaction(), lease, 0L, this.defaultWriteModifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> LeaseContext<T> write(T entry, WriteModifiers modifiers) throws DataAccessException {
        try {
            return this.space.write(entry, this.getCurrentTransaction(), this.defaultWriteLease, 0L, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> LeaseContext<T> write(T entry, long lease, long timeout, WriteModifiers modifiers) throws DataAccessException {
        try {
            return this.space.write(entry, this.getCurrentTransaction(), lease, timeout, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> AggregationResult aggregate(ISpaceQuery<T> query, AggregationSet aggregationSet) {
        try {
            return this.space.aggregate(query, aggregationSet, this.getCurrentTransaction(), this.getDefaultReadModifiers().getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ChangeResult<T> change(ISpaceQuery<T> query, ChangeSet changeSet) {
        try {
            return this.space.change(query, changeSet, this.getCurrentTransaction(), 0L, this.defaultChangeModifiers);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ChangeResult<T> change(ISpaceQuery<T> query, ChangeSet changeSet, ChangeModifiers modifiers) {
        try {
            return this.space.change(query, changeSet, this.getCurrentTransaction(), 0L, modifiers);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ChangeResult<T> change(ISpaceQuery<T> query, ChangeSet changeSet, long timeout) {
        try {
            return this.space.change(query, changeSet, this.getCurrentTransaction(), timeout, this.defaultChangeModifiers);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ChangeResult<T> change(ISpaceQuery<T> query, ChangeSet changeSet, ChangeModifiers modifiers, long timeout) {
        try {
            return this.space.change(query, changeSet, this.getCurrentTransaction(), timeout, modifiers);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(ISpaceQuery<T> query, ChangeSet changeSet) {
        try {
            return this.space.asyncChange(query, changeSet, this.getCurrentTransaction(), 0L, this.defaultChangeModifiers, null);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(ISpaceQuery<T> query, ChangeSet changeSet, AsyncFutureListener<ChangeResult<T>> listener) {
        try {
            return this.space.asyncChange(query, changeSet, this.getCurrentTransaction(), 0L, this.defaultChangeModifiers, listener);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(ISpaceQuery<T> query, ChangeSet changeSet, long timeout) {
        try {
            return this.space.asyncChange(query, changeSet, this.getCurrentTransaction(), timeout, this.defaultChangeModifiers, null);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(ISpaceQuery<T> query, ChangeSet changeSet, long timeout, AsyncFutureListener<ChangeResult<T>> listener) {
        try {
            return this.space.asyncChange(query, changeSet, this.getCurrentTransaction(), timeout, this.defaultChangeModifiers, listener);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(ISpaceQuery<T> query, ChangeSet changeSet, ChangeModifiers modifiers) {
        try {
            return this.space.asyncChange(query, changeSet, this.getCurrentTransaction(), 0L, modifiers, null);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(ISpaceQuery<T> query, ChangeSet changeSet, ChangeModifiers modifiers, AsyncFutureListener<ChangeResult<T>> listener) {
        try {
            return this.space.asyncChange(query, changeSet, this.getCurrentTransaction(), 0L, modifiers, listener);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(ISpaceQuery<T> query, ChangeSet changeSet, ChangeModifiers modifiers, long timeout) {
        try {
            return this.space.asyncChange(query, changeSet, this.getCurrentTransaction(), timeout, modifiers, null);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(ISpaceQuery<T> query, ChangeSet changeSet, ChangeModifiers modifiers, long timeout, AsyncFutureListener<ChangeResult<T>> listener) {
        try {
            return this.space.asyncChange(query, changeSet, this.getCurrentTransaction(), timeout, modifiers, listener);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ChangeResult<T> change(T template, ChangeSet changeSet) {
        try {
            return this.space.change(template, changeSet, this.getCurrentTransaction(), 0L, this.defaultChangeModifiers);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ChangeResult<T> change(T template, ChangeSet changeSet, ChangeModifiers modifiers) {
        try {
            return this.space.change(template, changeSet, this.getCurrentTransaction(), 0L, modifiers);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ChangeResult<T> change(T template, ChangeSet changeSet, long timeout) {
        try {
            return this.space.change(template, changeSet, this.getCurrentTransaction(), timeout, this.defaultChangeModifiers);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ChangeResult<T> change(T template, ChangeSet changeSet, ChangeModifiers modifiers, long timeout) {
        try {
            return this.space.change(template, changeSet, this.getCurrentTransaction(), timeout, modifiers);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(T template, ChangeSet changeSet) {
        try {
            return this.space.asyncChange(template, changeSet, this.getCurrentTransaction(), 0L, this.defaultChangeModifiers, null);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(T template, ChangeSet changeSet, AsyncFutureListener<ChangeResult<T>> listener) {
        try {
            return this.space.asyncChange(template, changeSet, this.getCurrentTransaction(), 0L, this.defaultChangeModifiers, listener);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(T template, ChangeSet changeSet, long timeout) {
        try {
            return this.space.asyncChange(template, changeSet, this.getCurrentTransaction(), timeout, this.defaultChangeModifiers, null);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(T template, ChangeSet changeSet, long timeout, AsyncFutureListener<ChangeResult<T>> listener) {
        try {
            return this.space.asyncChange(template, changeSet, this.getCurrentTransaction(), timeout, this.defaultChangeModifiers, listener);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(T template, ChangeSet changeSet, ChangeModifiers modifiers) {
        try {
            return this.space.asyncChange(template, changeSet, this.getCurrentTransaction(), 0L, modifiers, null);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(T template, ChangeSet changeSet, ChangeModifiers modifiers, AsyncFutureListener<ChangeResult<T>> listener) {
        try {
            return this.space.asyncChange(template, changeSet, this.getCurrentTransaction(), 0L, modifiers, listener);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(T template, ChangeSet changeSet, ChangeModifiers modifiers, long timeout) {
        try {
            return this.space.asyncChange(template, changeSet, this.getCurrentTransaction(), timeout, modifiers, null);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> Future<ChangeResult<T>> asyncChange(T template, ChangeSet changeSet, ChangeModifiers modifiers, long timeout, AsyncFutureListener<ChangeResult<T>> listener) {
        try {
            return this.space.asyncChange(template, changeSet, this.getCurrentTransaction(), timeout, modifiers, listener);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> LeaseContext<T>[] writeMultiple(T[] entries) throws DataAccessException {
        return this.writeMultiple(entries, this.defaultWriteLease);
    }

    @Override
    public <T> LeaseContext<T>[] writeMultiple(T[] entries, WriteModifiers modifiers) throws DataAccessException {
        return this.writeMultiple(entries, this.defaultWriteLease, modifiers);
    }

    @Override
    public <T> LeaseContext<T>[] writeMultiple(T[] entries, long lease) throws DataAccessException {
        try {
            return this.space.writeMultiple((Object[])entries, this.getCurrentTransaction(), lease, null, 0L, this.defaultWriteModifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> LeaseContext<T>[] writeMultiple(T[] entries, long lease, WriteModifiers modifiers) throws DataAccessException {
        try {
            return this.space.writeMultiple((Object[])entries, this.getCurrentTransaction(), lease, null, 0L, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> LeaseContext<T>[] writeMultiple(T[] entries, long lease, long timeout, WriteModifiers modifiers) throws DataAccessException {
        try {
            return this.space.writeMultiple((Object[])entries, this.getCurrentTransaction(), lease, null, timeout, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> LeaseContext<T>[] writeMultiple(T[] entries, long[] leases, WriteModifiers modifiers) throws DataAccessException {
        try {
            return this.space.writeMultiple((Object[])entries, this.getCurrentTransaction(), Long.MIN_VALUE, leases, 0L, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> LeaseContext<T>[] writeMultiple(T[] entries, long[] leases, long timeout, WriteModifiers modifiers) throws DataAccessException {
        try {
            return this.space.writeMultiple((Object[])entries, this.getCurrentTransaction(), Long.MIN_VALUE, leases, timeout, modifiers.getCode());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public IteratorBuilder iterator() {
        return new IteratorBuilder(this);
    }

    @Override
    public <T> SpaceIterator<T> iterator(T template) {
        return this.iterator(template, SpaceIterator.getDefaultBatchSize(), this.getDefaultReadModifiers());
    }

    @Override
    public <T> SpaceIterator<T> iterator(T template, int batchSize) {
        return this.iterator(template, batchSize, this.getDefaultReadModifiers());
    }

    @Override
    public <T> SpaceIterator<T> iterator(T template, int batchSize, ReadModifiers modifiers) {
        try {
            return new SpaceIterator(this.space, template, this.getCurrentTransaction(), batchSize, modifiers);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> SpaceIterator<T> iterator(ISpaceQuery<T> template) {
        return this.iterator(template, SpaceIterator.getDefaultBatchSize(), this.getDefaultReadModifiers());
    }

    @Override
    public <T> SpaceIterator<T> iterator(ISpaceQuery<T> template, int batchSize) {
        return this.iterator(template, batchSize, this.getDefaultReadModifiers());
    }

    @Override
    public <T> SpaceIterator<T> iterator(ISpaceQuery<T> template, int batchSize, ReadModifiers modifiers) {
        try {
            return new SpaceIterator(this.space, template, this.getCurrentTransaction(), batchSize, modifiers);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T extends Serializable> AsyncFuture<T> execute(Task<T> task) {
        return this.execute(task, (AsyncFutureListener)null);
    }

    @Override
    public <T extends Serializable> AsyncFuture<T> execute(Task<T> task, AsyncFutureListener<T> listener) {
        Object optionalRouting;
        if (task instanceof DistributedTask) {
            return this.distExecute((DistributedTask)task, listener);
        }
        Object routing = null;
        if (task instanceof TaskRoutingProvider && (optionalRouting = this.executorMetaDataProvider.findRouting(((TaskRoutingProvider)((Object)task)).getRouting())) != null) {
            routing = optionalRouting;
        }
        if (routing == null) {
            routing = this.executorMetaDataProvider.findRouting(task);
        }
        return this.execute(task, routing, listener);
    }

    @Override
    public <T extends Serializable> AsyncFuture<T> execute(Task<T> task, Object routing) {
        return this.execute(task, routing, null);
    }

    @Override
    public <T extends Serializable> AsyncFuture<T> execute(Task<T> task, Object routing, AsyncFutureListener<T> listener) {
        Object optionalRouting = this.executorMetaDataProvider.findRouting(routing);
        if (optionalRouting != null) {
            routing = optionalRouting;
        }
        try {
            Transaction tx = this.getCurrentTransaction();
            return this.wrapFuture(this.space.execute(new InternalSpaceTaskWrapper<T>(task, routing), routing, tx, this.wrapListener(listener, tx)), tx);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T extends Serializable, R> AsyncFuture<R> execute(DistributedTask<T, R> task, Object ... routings) {
        AsyncFutureListener listener = null;
        int numberOfRoutings = routings.length;
        if (routings.length > 0 && routings[routings.length - 1] instanceof AsyncFutureListener) {
            listener = (AsyncFutureListener)routings[routings.length - 1];
            --numberOfRoutings;
        }
        if (numberOfRoutings == 0) {
            return this.execute(task, listener);
        }
        AsyncFuture[] futures = new AsyncFuture[numberOfRoutings];
        Transaction tx = this.getCurrentTransaction();
        for (int i = 0; i < numberOfRoutings; ++i) {
            try {
                Object routing = routings[i];
                Object optionalRouting = this.executorMetaDataProvider.findRouting(routing);
                if (optionalRouting != null) {
                    routing = optionalRouting;
                }
                futures[i] = this.space.execute(new InternalSpaceTaskWrapper(task, routing), routing, tx, (AsyncFutureListener)null);
                continue;
            }
            catch (Exception e) {
                throw this.exTranslator.translate(e);
            }
        }
        Object result = task instanceof AsyncResultFilter ? FutureFactory.create((AsyncFuture[])futures, task, (AsyncResultFilter)((AsyncResultFilter)task)) : FutureFactory.create((AsyncFuture[])futures, task);
        result = this.wrapFuture((AsyncFuture<T>)result, tx);
        if (listener != null) {
            result.setListener(this.wrapListener(listener, tx));
        }
        return result;
    }

    @Override
    public <T extends Serializable, R> AsyncFuture<R> execute(DistributedTask<T, R> task) {
        return this.distExecute(task, null);
    }

    public <T extends Serializable, R> AsyncFuture<R> execute(DistributedTask<T, R> task, AsyncFutureListener<R> listener) {
        return this.distExecute(task, listener);
    }

    public <T extends Serializable, R> AsyncFuture<R> distExecute(DistributedTask<T, R> task, AsyncFutureListener<R> listener) {
        try {
            Transaction tx = this.getCurrentTransaction();
            InternalDistributedSpaceTaskWrapper<T, R> taskWrapper = new InternalDistributedSpaceTaskWrapper<T, R>(task);
            return this.wrapFuture(this.space.execute(taskWrapper, taskWrapper.getRouting(), tx, this.wrapListener(listener, tx)), tx);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T extends Serializable, R> ExecutorBuilder<T, R> executorBuilder(AsyncResultsReducer<T, R> reducer) {
        return new ExecutorBuilder<T, R>(this, reducer);
    }

    @Override
    public Transaction getCurrentTransaction() {
        return this.txProvider.getCurrentTransaction();
    }

    public String toString() {
        return this.space.toString();
    }

    public <T> AsyncFutureListener<T> wrapListener(AsyncFutureListener<T> listener, Transaction tx) {
        if (listener == null) {
            return null;
        }
        if (tx == null) {
            return new InternalAsyncFutureListener<T>(this, listener);
        }
        return InternalAsyncFutureListener.wrapIfNeeded(listener, this);
    }

    @Override
    public <T> AsyncFuture<T> wrapFuture(AsyncFuture<T> future, Transaction tx) {
        return new InternalAsyncFuture<T>(future, this, tx);
    }

    @Override
    public <T> ReadByIdsResult<T> readByIds(Class<T> clazz, Object[] ids) {
        try {
            return new ReadByIdsResultImpl(this.space.readByIds(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), ids, null, this.getCurrentTransaction(), this.getDefaultReadModifiers().getCode(), QueryResultTypeInternal.NOT_SET, false, null));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ReadByIdsResult<T> readByIds(Class<T> clazz, Object[] ids, Object routing, ReadModifiers modifiers) {
        try {
            return new ReadByIdsResultImpl(this.space.readByIds(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), ids, routing, this.getCurrentTransaction(), modifiers.getCode(), QueryResultTypeInternal.NOT_SET, false, null));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ReadByIdsResult<T> readByIds(Class<T> clazz, Object[] ids, Object[] routings, ReadModifiers modifiers) {
        try {
            return new ReadByIdsResultImpl(this.space.readByIds(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), ids, routings, this.getCurrentTransaction(), modifiers.getCode(), QueryResultTypeInternal.NOT_SET, false, null));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ReadByIdsResult<T> readByIds(Class<T> clazz, Object[] ids, Object routing) {
        try {
            return new ReadByIdsResultImpl(this.space.readByIds(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), ids, routing, this.getCurrentTransaction(), this.getDefaultReadModifiers().getCode(), QueryResultTypeInternal.NOT_SET, false, null));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ReadByIdsResult<T> readByIds(Class<T> clazz, Object[] ids, Object[] routings) {
        try {
            return new ReadByIdsResultImpl(this.space.readByIds(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), ids, routings, this.getCurrentTransaction(), this.getDefaultReadModifiers().getCode(), QueryResultTypeInternal.NOT_SET, false, null));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ReadByIdsResult<T> readByIds(IdsQuery<T> query) throws DataAccessException {
        try {
            if (query.getRouting() != null) {
                return new ReadByIdsResultImpl(this.space.readByIds(query.getTypeName(), query.getIds(), query.getRouting(), this.getCurrentTransaction(), this.getDefaultReadModifiers().getCode(), DefaultGigaSpace.toInternal(query.getQueryResultType()), false, query.getProjections()));
            }
            return new ReadByIdsResultImpl(this.space.readByIds(query.getTypeName(), query.getIds(), query.getRoutings(), this.getCurrentTransaction(), this.getDefaultReadModifiers().getCode(), DefaultGigaSpace.toInternal(query.getQueryResultType()), false, query.getProjections()));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> ReadByIdsResult<T> readByIds(IdsQuery<T> query, ReadModifiers modifiers) throws DataAccessException {
        try {
            if (query.getRouting() != null) {
                return new ReadByIdsResultImpl(this.space.readByIds(query.getTypeName(), query.getIds(), query.getRouting(), this.getCurrentTransaction(), modifiers.getCode(), DefaultGigaSpace.toInternal(query.getQueryResultType()), false, query.getProjections()));
            }
            return new ReadByIdsResultImpl(this.space.readByIds(query.getTypeName(), query.getIds(), query.getRoutings(), this.getCurrentTransaction(), modifiers.getCode(), DefaultGigaSpace.toInternal(query.getQueryResultType()), false, query.getProjections()));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> TakeByIdsResult<T> takeByIds(Class<T> clazz, Object[] ids, Object routing, TakeModifiers modifiers) {
        try {
            return new TakeByIdsResultImpl(this.space.takeByIds(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), ids, routing, this.getCurrentTransaction(), modifiers.getCode(), QueryResultTypeInternal.NOT_SET, false, null));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> TakeByIdsResult<T> takeByIds(Class<T> clazz, Object[] ids, Object[] routings, TakeModifiers modifiers) {
        try {
            return new TakeByIdsResultImpl(this.space.takeByIds(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), ids, routings, this.getCurrentTransaction(), modifiers.getCode(), QueryResultTypeInternal.NOT_SET, false, null));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> TakeByIdsResult<T> takeByIds(Class<T> clazz, Object[] ids) {
        try {
            return new TakeByIdsResultImpl(this.space.takeByIds(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), ids, null, this.getCurrentTransaction(), this.defaultTakeModifiers.getCode(), QueryResultTypeInternal.NOT_SET, false, null));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> TakeByIdsResult<T> takeByIds(Class<T> clazz, Object[] ids, Object routing) {
        try {
            return new TakeByIdsResultImpl(this.space.takeByIds(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), ids, routing, this.getCurrentTransaction(), this.defaultTakeModifiers.getCode(), QueryResultTypeInternal.NOT_SET, false, null));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> TakeByIdsResult<T> takeByIds(Class<T> clazz, Object[] ids, Object[] routings) {
        try {
            return new TakeByIdsResultImpl(this.space.takeByIds(((Class)ObjectUtils.assertArgumentNotNull(clazz, (String)"class")).getName(), ids, routings, this.getCurrentTransaction(), this.defaultTakeModifiers.getCode(), QueryResultTypeInternal.NOT_SET, false, null));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> TakeByIdsResult<T> takeByIds(IdsQuery<T> query) throws DataAccessException {
        try {
            if (query.getRouting() != null) {
                return new TakeByIdsResultImpl(this.space.takeByIds(query.getTypeName(), query.getIds(), query.getRouting(), this.getCurrentTransaction(), this.defaultTakeModifiers.getCode(), DefaultGigaSpace.toInternal(query.getQueryResultType()), false, query.getProjections()));
            }
            return new TakeByIdsResultImpl(this.space.takeByIds(query.getTypeName(), query.getIds(), query.getRoutings(), this.getCurrentTransaction(), this.defaultTakeModifiers.getCode(), DefaultGigaSpace.toInternal(query.getQueryResultType()), false, query.getProjections()));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public <T> TakeByIdsResult<T> takeByIds(IdsQuery<T> query, TakeModifiers modifiers) throws DataAccessException {
        try {
            if (query.getRouting() != null) {
                return new TakeByIdsResultImpl(this.space.takeByIds(query.getTypeName(), query.getIds(), query.getRouting(), this.getCurrentTransaction(), modifiers.getCode(), DefaultGigaSpace.toInternal(query.getQueryResultType()), false, query.getProjections()));
            }
            return new TakeByIdsResultImpl(this.space.takeByIds(query.getTypeName(), query.getIds(), query.getRoutings(), this.getCurrentTransaction(), modifiers.getCode(), DefaultGigaSpace.toInternal(query.getQueryResultType()), false, query.getProjections()));
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public DataEventSession newDataEventSession() {
        return this.newDataEventSession(new EventSessionConfig());
    }

    @Override
    public DataEventSession newDataEventSession(EventSessionConfig config) {
        try {
            return DataEventSessionFactory.create((IJSpace)this.getSpace(), (EventSessionConfig)config);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public GigaSpaceTypeManager getTypeManager() {
        return this.typeManager;
    }

    private static QueryResultTypeInternal toInternal(QueryResultType queryResultType) {
        if (queryResultType == null) {
            return null;
        }
        if (queryResultType == QueryResultType.DEFAULT || queryResultType == QueryResultType.NOT_SET) {
            return QueryResultTypeInternal.NOT_SET;
        }
        if (queryResultType == QueryResultType.OBJECT) {
            return QueryResultTypeInternal.OBJECT_JAVA;
        }
        if (queryResultType == QueryResultType.DOCUMENT) {
            return QueryResultTypeInternal.DOCUMENT_ENTRY;
        }
        throw new IllegalArgumentException("Unsupported query result type: " + queryResultType);
    }

    @Override
    public void setQuiesceToken(QuiesceToken token) {
        this.space.getDirectProxy().setQuiesceToken(token);
    }

    @Override
    public <T> ISpaceQuery<T> prepareTemplate(Object template) {
        return this.space.getDirectProxy().prepareTemplate(template);
    }

    public void close() throws IOException {
        if (this.implicitTxProvider) {
            this.txProvider.close();
        }
    }
}

