/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.metadata.index.AddTypeIndexesResult;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndex;
import org.openspaces.core.GigaSpaceTypeManager;
import org.openspaces.core.exception.ExceptionTranslator;

public class DefaultGigaSpaceTypeManager
implements GigaSpaceTypeManager {
    private final ISpaceProxy space;
    private final ExceptionTranslator exTranslator;

    public DefaultGigaSpaceTypeManager(ISpaceProxy space, ExceptionTranslator exTranslator) {
        this.space = space;
        this.exTranslator = exTranslator;
    }

    @Override
    public SpaceTypeDescriptor getTypeDescriptor(String typeName) {
        try {
            return this.space.getTypeDescriptor(typeName);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public SpaceTypeDescriptor getTypeDescriptor(Class<?> type) {
        try {
            if (type == null) {
                throw new IllegalArgumentException("Argument cannot be null - 'type'.");
            }
            return this.space.getTypeDescriptor(type.getName());
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public void registerTypeDescriptor(SpaceTypeDescriptor typeDescriptor) {
        try {
            if (typeDescriptor == null) {
                throw new IllegalArgumentException("Argument cannot be null - 'typeDescriptor'.");
            }
            this.space.registerTypeDescriptor((ITypeDesc)typeDescriptor);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public void registerTypeDescriptor(Class<?> type) {
        try {
            if (type == null) {
                throw new IllegalArgumentException("Argument cannot be null - 'type'.");
            }
            this.space.registerTypeDescriptor(type);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }

    @Override
    public AsyncFuture<AddTypeIndexesResult> asyncAddIndex(String typeName, SpaceIndex index) {
        return this.asyncAddIndexes(typeName, new SpaceIndex[]{index}, null);
    }

    @Override
    public AsyncFuture<AddTypeIndexesResult> asyncAddIndex(String typeName, SpaceIndex index, AsyncFutureListener<AddTypeIndexesResult> listener) {
        return this.asyncAddIndexes(typeName, new SpaceIndex[]{index}, listener);
    }

    @Override
    public AsyncFuture<AddTypeIndexesResult> asyncAddIndexes(String typeName, SpaceIndex[] indexes, AsyncFutureListener<AddTypeIndexesResult> listener) {
        try {
            if (typeName == null || typeName.length() == 0) {
                throw new IllegalArgumentException("Argument cannot be null or empty - 'typeName'.");
            }
            if (indexes == null || indexes.length == 0) {
                throw new IllegalArgumentException("Argument cannot be null or empty - 'indexes'.");
            }
            ISpaceIndex[] internalIndexes = new ISpaceIndex[indexes.length];
            for (int i = 0; i < indexes.length; ++i) {
                if (indexes[i] == null) {
                    throw new IllegalArgumentException("Index at position #" + i + " is null.");
                }
                if (!(indexes[i] instanceof ISpaceIndex)) {
                    throw new IllegalArgumentException("Index at position #" + i + " is of an unsupported type - " + indexes[i].getClass().getName());
                }
                if (((ISpaceIndex)indexes[i]).isUnique()) {
                    throw new UnsupportedOperationException("invalid index at position #" + i + " dynamic index cannot be unique");
                }
                internalIndexes[i] = (ISpaceIndex)indexes[i];
            }
            return this.space.asyncAddIndexes(typeName, (SpaceIndex[])internalIndexes, listener);
        }
        catch (Exception e) {
            throw this.exTranslator.translate(e);
        }
    }
}

