/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResultFilter;
import com.gigaspaces.async.AsyncResultsReducer;
import com.gigaspaces.async.FutureFactory;
import java.io.Serializable;
import java.util.ArrayList;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.executor.DistributedTask;
import org.openspaces.core.executor.Task;
import org.openspaces.core.internal.InternalGigaSpace;

public class ExecutorBuilder<T extends Serializable, R> {
    private final ArrayList<Holder> holders = new ArrayList();
    private final InternalGigaSpace gigaSpace;
    private final AsyncResultsReducer<T, R> reducer;

    ExecutorBuilder(GigaSpace gigaSpace, AsyncResultsReducer<T, R> reducer) {
        this.gigaSpace = (InternalGigaSpace)gigaSpace;
        this.reducer = reducer;
    }

    public ExecutorBuilder<T, R> add(Task<T> task) {
        this.holders.add(new Holder<T>(task, null));
        return this;
    }

    public ExecutorBuilder<T, R> add(Task<T> task, AsyncFutureListener<T> listener) {
        this.holders.add(new Holder<T>(task, null));
        return this;
    }

    public ExecutorBuilder<T, R> add(Task<T> task, Object routing) {
        this.holders.add(new Holder<T>(task, routing));
        return this;
    }

    public ExecutorBuilder<T, R> add(DistributedTask<T, R> task, Object ... routing) {
        this.holders.add(new Holder(task, routing));
        return this;
    }

    public ExecutorBuilder<T, R> add(DistributedTask<T, R> task) {
        this.holders.add(new Holder(task, null));
        return this;
    }

    public AsyncFuture<R> execute() {
        if (this.holders.size() == 0) {
            throw new IllegalArgumentException("No tasks to execute");
        }
        AsyncFuture[] futures = new AsyncFuture[this.holders.size()];
        for (int i = 0; i < futures.length; ++i) {
            Holder holder = this.holders.get(i);
            if (holder.task instanceof DistributedTask) {
                if (holder.routing != null) {
                    futures[i] = this.gigaSpace.execute((DistributedTask)holder.task, (Object[])holder.routing);
                    continue;
                }
                futures[i] = this.gigaSpace.execute((DistributedTask)holder.task);
                continue;
            }
            futures[i] = holder.routing != null ? this.gigaSpace.execute(holder.task, holder.routing) : this.gigaSpace.execute(holder.task);
        }
        AsyncFuture result = this.reducer instanceof AsyncResultFilter ? FutureFactory.create((AsyncFuture[])futures, this.reducer, (AsyncResultFilter)((AsyncResultFilter)this.reducer)) : FutureFactory.create((AsyncFuture[])futures, this.reducer);
        return this.gigaSpace.wrapFuture(result, this.gigaSpace.getCurrentTransaction());
    }

    private static class Holder<S extends Serializable> {
        Task<S> task;
        Object routing;

        public Holder(Task<S> task, Object routing) {
            this.task = task;
            this.routing = routing;
        }
    }
}

