/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core;

import com.gigaspaces.client.ChangeModifiers;
import com.gigaspaces.client.ClearModifiers;
import com.gigaspaces.client.CountModifiers;
import com.gigaspaces.client.ReadModifiers;
import com.gigaspaces.client.TakeModifiers;
import com.gigaspaces.client.WriteModifiers;
import com.j_spaces.core.IJSpace;
import org.openspaces.core.DefaultGigaSpace;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.exception.ExceptionTranslator;
import org.openspaces.core.space.SpaceConfigurer;
import org.openspaces.core.transaction.TransactionProvider;
import org.springframework.core.Constants;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;

public class GigaSpaceConfigurer {
    private static final Constants constants = new Constants(TransactionDefinition.class);
    public static final String PREFIX_ISOLATION = "ISOLATION_";
    private DefaultGigaSpace gigaSpace;
    private IJSpace space;
    private String name;
    private Boolean clustered;
    private ExceptionTranslator exTranslator;
    private TransactionProvider txProvider;
    private PlatformTransactionManager transactionManager;
    private int defaultIsolationLevel = -1;
    private long defaultReadTimeout = 0L;
    private long defaultTakeTimeout = 0L;
    private long defaultWriteLease = Long.MAX_VALUE;
    private WriteModifiers defaultWriteModifiers;
    private ReadModifiers defaultReadModifiers;
    private TakeModifiers defaultTakeModifiers;
    private ClearModifiers defaultClearModifiers;
    private CountModifiers defaultCountModifiers;
    private ChangeModifiers defaultChangeModifiers;

    public GigaSpaceConfigurer(IJSpace space) {
        this.space(space);
    }

    public GigaSpaceConfigurer(SpaceConfigurer configurer) {
        this(configurer.space());
    }

    protected GigaSpaceConfigurer() {
    }

    protected void space(IJSpace space) {
        this.space = space;
    }

    public IJSpace getSpace() {
        return this.space;
    }

    public GigaSpaceConfigurer name(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public GigaSpaceConfigurer txProvider(TransactionProvider txProvider) {
        this.txProvider = txProvider;
        return this;
    }

    public TransactionProvider getTxProvider() {
        return this.txProvider;
    }

    public GigaSpaceConfigurer exTranslator(ExceptionTranslator exTranslator) {
        this.exTranslator = exTranslator;
        return this;
    }

    public ExceptionTranslator getExTranslator() {
        return this.exTranslator;
    }

    public GigaSpaceConfigurer clustered(boolean clustered) {
        this.clustered = clustered;
        return this;
    }

    public Boolean getClustered() {
        return this.clustered;
    }

    public GigaSpaceConfigurer defaultReadTimeout(long defaultReadTimeout) {
        this.defaultReadTimeout = defaultReadTimeout;
        return this;
    }

    public long getDefaultReadTimeout() {
        return this.defaultReadTimeout;
    }

    public GigaSpaceConfigurer defaultTakeTimeout(long defaultTakeTimeout) {
        this.defaultTakeTimeout = defaultTakeTimeout;
        return this;
    }

    public long getDefaultTakeTimeout() {
        return this.defaultTakeTimeout;
    }

    public GigaSpaceConfigurer defaultWriteLease(long defaultWriteLease) {
        this.defaultWriteLease = defaultWriteLease;
        return this;
    }

    public long getDefaultWriteLease() {
        return this.defaultWriteLease;
    }

    public GigaSpaceConfigurer defaultIsolationLevel(int defaultIsolationLevel) {
        if (!constants.getValues(PREFIX_ISOLATION).contains(defaultIsolationLevel)) {
            throw new IllegalArgumentException("Only values of isolation constants allowed");
        }
        this.defaultIsolationLevel = defaultIsolationLevel;
        return this;
    }

    public int getDefaultIsolationLevel() {
        return this.defaultIsolationLevel;
    }

    public GigaSpaceConfigurer defaultIsolationLevel(String name) {
        if (name == null || !name.startsWith(PREFIX_ISOLATION)) {
            throw new IllegalArgumentException("Only isolation constants allowed");
        }
        this.defaultIsolationLevel(constants.asNumber(name).intValue());
        return this;
    }

    public GigaSpaceConfigurer defaultWriteModifiers(WriteModifiers defaultWriteModifiers) {
        this.defaultWriteModifiers = defaultWriteModifiers;
        return this;
    }

    public WriteModifiers getDefaultWriteModifiers() {
        return this.defaultWriteModifiers;
    }

    public GigaSpaceConfigurer defaultReadModifiers(ReadModifiers defaultReadModifiers) {
        this.defaultReadModifiers = defaultReadModifiers;
        return this;
    }

    public ReadModifiers getDefaultReadModifiers() {
        return this.defaultReadModifiers;
    }

    public GigaSpaceConfigurer defaultTakeModifiers(TakeModifiers defaultTakeModifiers) {
        this.defaultTakeModifiers = defaultTakeModifiers;
        return this;
    }

    public TakeModifiers getDefaultTakeModifiers() {
        return this.defaultTakeModifiers;
    }

    public GigaSpaceConfigurer defaultCountModifiers(CountModifiers defaultCountModifiers) {
        this.defaultCountModifiers = defaultCountModifiers;
        return this;
    }

    public CountModifiers getDefaultCountModifiers() {
        return this.defaultCountModifiers;
    }

    public GigaSpaceConfigurer defaultClearModifiers(ClearModifiers defaultClearModifiers) {
        this.defaultClearModifiers = defaultClearModifiers;
        return this;
    }

    public ClearModifiers getDefaultClearModifiers() {
        return this.defaultClearModifiers;
    }

    public GigaSpaceConfigurer defaultChangeModifiers(ChangeModifiers defaultChangeModifiers) {
        this.defaultChangeModifiers = defaultChangeModifiers;
        return this;
    }

    public ChangeModifiers getDefaultChangeModifiers() {
        return this.defaultChangeModifiers;
    }

    public GigaSpaceConfigurer transactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        return this;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public GigaSpace create() {
        if (this.gigaSpace == null) {
            this.gigaSpace = this.initialize();
        }
        return this.gigaSpace;
    }

    protected void close() throws Exception {
        if (this.gigaSpace != null) {
            this.gigaSpace.close();
        }
    }

    protected GigaSpace getGigaSpaceIfInitialized() {
        return this.gigaSpace;
    }

    public GigaSpace gigaSpace() {
        return this.create();
    }

    protected DefaultGigaSpace initialize() {
        return new DefaultGigaSpace(this);
    }
}

