/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core;

import com.gigaspaces.client.ChangeModifiers;
import com.gigaspaces.client.ClearModifiers;
import com.gigaspaces.client.CountModifiers;
import com.gigaspaces.client.ReadModifiers;
import com.gigaspaces.client.TakeModifiers;
import com.gigaspaces.client.WriteModifiers;
import com.j_spaces.core.IJSpace;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.exception.ExceptionTranslator;
import org.openspaces.core.transaction.TransactionProvider;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.PlatformTransactionManager;

public class GigaSpaceFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean,
BeanNameAware {
    public static final String PREFIX_ISOLATION = "ISOLATION_";
    private final GigaSpaceConfigurer configurer = new GigaSpaceConfigurer();

    public void setSpace(IJSpace space) {
        this.configurer.space(space);
    }

    public void setTxProvider(TransactionProvider txProvider) {
        this.configurer.txProvider(txProvider);
    }

    public void setExTranslator(ExceptionTranslator exTranslator) {
        this.configurer.exTranslator(exTranslator);
    }

    public void setClustered(boolean clustered) {
        this.configurer.clustered(clustered);
    }

    public void setDefaultReadTimeout(long defaultReadTimeout) {
        this.configurer.defaultReadTimeout(defaultReadTimeout);
    }

    public void setDefaultTakeTimeout(long defaultTakeTimeout) {
        this.configurer.defaultTakeTimeout(defaultTakeTimeout);
    }

    public void setDefaultWriteLease(long defaultWriteLease) {
        this.configurer.defaultWriteLease(defaultWriteLease);
    }

    public final void setDefaultIsolationLevelName(String constantName) throws IllegalArgumentException {
        this.configurer.defaultIsolationLevel(constantName);
    }

    public void setDefaultIsolationLevel(int defaultIsolationLevel) {
        this.configurer.defaultIsolationLevel(defaultIsolationLevel);
    }

    public void setDefaultWriteModifiers(WriteModifiers[] defaultWriteModifiers) {
        if (defaultWriteModifiers != null && defaultWriteModifiers.length != 0) {
            WriteModifiers modifiers = defaultWriteModifiers[0];
            for (int i = 1; i < defaultWriteModifiers.length; ++i) {
                modifiers = modifiers.add(defaultWriteModifiers[i]);
            }
            this.configurer.defaultWriteModifiers(modifiers);
        }
    }

    public void setDefaultReadModifiers(ReadModifiers[] defaultReadModifiers) {
        if (defaultReadModifiers != null && defaultReadModifiers.length != 0) {
            ReadModifiers modifiers = defaultReadModifiers[0];
            for (int i = 1; i < defaultReadModifiers.length; ++i) {
                modifiers = modifiers.add(defaultReadModifiers[i]);
            }
            this.configurer.defaultReadModifiers(modifiers);
        }
    }

    public void setDefaultTakeModifiers(TakeModifiers[] defaultTakeModifiers) {
        if (defaultTakeModifiers != null && defaultTakeModifiers.length != 0) {
            TakeModifiers modifiers = defaultTakeModifiers[0];
            for (int i = 1; i < defaultTakeModifiers.length; ++i) {
                modifiers = modifiers.add(defaultTakeModifiers[i]);
            }
            this.configurer.defaultTakeModifiers(modifiers);
        }
    }

    public void setDefaultCountModifiers(CountModifiers[] defaultCountModifiers) {
        if (defaultCountModifiers != null && defaultCountModifiers.length != 0) {
            CountModifiers modifiers = defaultCountModifiers[0];
            for (int i = 1; i < defaultCountModifiers.length; ++i) {
                modifiers = modifiers.add(defaultCountModifiers[i]);
            }
            this.configurer.defaultCountModifiers(modifiers);
        }
    }

    public void setDefaultClearModifiers(ClearModifiers[] defaultClearModifiers) {
        if (defaultClearModifiers != null && defaultClearModifiers.length != 0) {
            ClearModifiers modifiers = defaultClearModifiers[0];
            for (int i = 1; i < defaultClearModifiers.length; ++i) {
                modifiers = modifiers.add(defaultClearModifiers[i]);
            }
            this.configurer.defaultClearModifiers(modifiers);
        }
    }

    public void setDefaultChangeModifiers(ChangeModifiers[] defaultChangeModifiers) {
        if (defaultChangeModifiers != null && defaultChangeModifiers.length != 0) {
            ChangeModifiers modifiers = defaultChangeModifiers[0];
            for (int i = 1; i < defaultChangeModifiers.length; ++i) {
                modifiers = modifiers.add(defaultChangeModifiers[i]);
            }
            this.configurer.defaultChangeModifiers(modifiers);
        }
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.configurer.transactionManager(transactionManager);
    }

    public void setBeanName(String beanName) {
        this.configurer.name(beanName);
    }

    public void afterPropertiesSet() {
        this.configurer.create();
    }

    public Object getObject() {
        return this.configurer.getGigaSpaceIfInitialized();
    }

    public Class<? extends GigaSpace> getObjectType() {
        GigaSpace gigaSpace = this.configurer.getGigaSpaceIfInitialized();
        return gigaSpace == null ? GigaSpace.class : gigaSpace.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        this.configurer.close();
    }
}

