/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core;

import com.gigaspaces.client.CountModifiers;
import com.gigaspaces.client.IsolationLevelModifiers;
import com.gigaspaces.client.ReadModifiers;

public class IsolationLevelHelpers {
    public static int toSpringIsolationLevel(IsolationLevelModifiers modifiers) {
        if (modifiers == null) {
            return -1;
        }
        if (modifiers.getCode() == ReadModifiers.DIRTY_READ.getCode()) {
            return 1;
        }
        if (modifiers.getCode() == ReadModifiers.READ_COMMITTED.getCode()) {
            return 2;
        }
        if (modifiers.getCode() == ReadModifiers.REPEATABLE_READ.getCode()) {
            return 4;
        }
        throw new IllegalArgumentException("Unsupported isolation level [" + modifiers + "]");
    }

    public static IsolationLevelModifiers fromSpringIsolationLevel(Integer springIsolationLevel) {
        if (springIsolationLevel == null) {
            return null;
        }
        switch (springIsolationLevel) {
            case -1: {
                return null;
            }
            case 1: {
                return ReadModifiers.DIRTY_READ;
            }
            case 2: {
                return ReadModifiers.READ_COMMITTED;
            }
            case 4: {
                return ReadModifiers.REPEATABLE_READ;
            }
        }
        throw new IllegalArgumentException("Unsupported Spring isolation level [" + springIsolationLevel + "]");
    }

    public static int convertSpringToSpaceIsolationLevel(int springIsolationLevel, int defaultValue) {
        IsolationLevelModifiers modifiers = IsolationLevelHelpers.fromSpringIsolationLevel(springIsolationLevel);
        return modifiers != null ? modifiers.getCode() : defaultValue;
    }

    public static ReadModifiers toReadModifiers(int isolationLevel) {
        if (isolationLevel == ReadModifiers.NONE.getCode()) {
            return ReadModifiers.NONE;
        }
        if (isolationLevel == ReadModifiers.DIRTY_READ.getCode()) {
            return ReadModifiers.DIRTY_READ;
        }
        if (isolationLevel == ReadModifiers.READ_COMMITTED.getCode()) {
            return ReadModifiers.READ_COMMITTED;
        }
        if (isolationLevel == ReadModifiers.REPEATABLE_READ.getCode()) {
            return ReadModifiers.REPEATABLE_READ;
        }
        throw new IllegalArgumentException("GigaSpace does not support isolation level: " + isolationLevel);
    }

    public static CountModifiers toCountModifiers(int isolationLevel) {
        if (isolationLevel == CountModifiers.NONE.getCode()) {
            return CountModifiers.NONE;
        }
        if (isolationLevel == CountModifiers.DIRTY_READ.getCode()) {
            return CountModifiers.DIRTY_READ;
        }
        if (isolationLevel == CountModifiers.READ_COMMITTED.getCode()) {
            return CountModifiers.READ_COMMITTED;
        }
        if (isolationLevel == CountModifiers.REPEATABLE_READ.getCode()) {
            return CountModifiers.REPEATABLE_READ;
        }
        throw new IllegalArgumentException("GigaSpace does not support isolation level: " + isolationLevel);
    }
}

