/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core;

import com.gigaspaces.client.ReadTakeByIdResult;
import org.openspaces.core.exception.ExceptionTranslator;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

public class ReadByIdsException
extends InvalidDataAccessResourceUsageException {
    private static final long serialVersionUID = 1L;
    private final ReadByIdResult[] _results;

    public ReadByIdsException(com.gigaspaces.client.ReadByIdsException cause, ExceptionTranslator exceptionTranslator) {
        super(cause.getMessage(), (Throwable)cause);
        this._results = new ReadByIdResult[cause.getResults().length];
        for (int i = 0; i < this._results.length; ++i) {
            this._results[i] = new ReadByIdResult(cause.getResults()[i], exceptionTranslator);
        }
    }

    public ReadByIdResult[] getResults() {
        return this._results;
    }

    public static class ReadByIdResult {
        private final ReadTakeByIdResult _result;
        private final ReadByIdResultType _resultType;
        private final Throwable _error;

        protected ReadByIdResult(ReadTakeByIdResult result, ExceptionTranslator exceptionTranslator) {
            this._result = result;
            if (this._result.isError()) {
                this._resultType = ReadByIdResultType.ERROR;
                this._error = exceptionTranslator.translate(result.getError());
            } else {
                this._resultType = this._result.getObject() == null ? ReadByIdResultType.NOT_FOUND : ReadByIdResultType.OBJECT;
                this._error = null;
            }
        }

        public Throwable getError() {
            return this._error;
        }

        public Object getId() {
            return this._result.getId();
        }

        public Object getObject() {
            return this._result.getObject();
        }

        public boolean isError() {
            return this._result.isError();
        }

        public ReadByIdResultType getResultType() {
            return this._resultType;
        }

        public static enum ReadByIdResultType {
            ERROR,
            OBJECT,
            NOT_FOUND;

        }
    }
}

