/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core;

import com.gigaspaces.client.ReadTakeByIdResult;
import org.openspaces.core.exception.ExceptionTranslator;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

public class TakeByIdsException
extends InvalidDataAccessResourceUsageException {
    private static final long serialVersionUID = 1L;
    private final TakeByIdResult[] _results;

    public TakeByIdsException(com.gigaspaces.client.TakeByIdsException cause, ExceptionTranslator exceptionTranslator) {
        super(cause.getMessage(), (Throwable)cause);
        this._results = new TakeByIdResult[cause.getResults().length];
        for (int i = 0; i < this._results.length; ++i) {
            this._results[i] = new TakeByIdResult(cause.getResults()[i], exceptionTranslator);
        }
    }

    public TakeByIdResult[] getResults() {
        return this._results;
    }

    public static class TakeByIdResult {
        private final ReadTakeByIdResult _result;
        private final TakeByIdResultType _resultType;
        private final Throwable _error;

        protected TakeByIdResult(ReadTakeByIdResult result, ExceptionTranslator exceptionTranslator) {
            this._result = result;
            if (this._result.isError()) {
                this._resultType = TakeByIdResultType.ERROR;
                this._error = exceptionTranslator.translate(result.getError());
            } else {
                this._resultType = this._result.getObject() == null ? TakeByIdResultType.NOT_FOUND : TakeByIdResultType.OBJECT;
                this._error = null;
            }
        }

        public Throwable getError() {
            return this._error;
        }

        public Object getId() {
            return this._result.getId();
        }

        public Object getObject() {
            return this._result.getObject();
        }

        public boolean isError() {
            return this._result.isError();
        }

        public TakeByIdResultType getResultType() {
            return this._resultType;
        }

        public static enum TakeByIdResultType {
            ERROR,
            OBJECT,
            NOT_FOUND;

        }
    }
}

