/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.cluster;

import java.io.Serializable;

public class ClusterInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -128705742407213814L;
    private String schema;
    private Integer instanceId;
    private Integer backupId;
    private Integer numberOfInstances;
    private Integer numberOfBackups;
    private String name;

    public ClusterInfo() {
    }

    public ClusterInfo(String schema, Integer instanceId, Integer backupId, Integer numberOfInstances, Integer numberOfBackups) {
        this.schema = schema;
        this.instanceId = instanceId;
        this.backupId = backupId;
        this.numberOfInstances = numberOfInstances;
        this.numberOfBackups = numberOfBackups;
    }

    public String getSchema() {
        return this.schema;
    }

    public ClusterInfo setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public Integer getInstanceId() {
        return this.instanceId;
    }

    public ClusterInfo setInstanceId(Integer instanceId) {
        if (instanceId != null && instanceId < 1) {
            throw new IllegalArgumentException("Cluster member instance-id should be greater than zero");
        }
        this.instanceId = instanceId;
        return this;
    }

    public Integer getBackupId() {
        return this.backupId;
    }

    public ClusterInfo setBackupId(Integer backupId) {
        if (backupId != null && backupId < 1) {
            throw new IllegalArgumentException("Cluster member backup-id should be greater than zero");
        }
        this.backupId = backupId;
        return this;
    }

    public Integer getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public ClusterInfo setNumberOfInstances(Integer numberOfInstances) {
        this.numberOfInstances = numberOfInstances;
        return this;
    }

    public Integer getNumberOfBackups() {
        return this.numberOfBackups;
    }

    public ClusterInfo setNumberOfBackups(Integer numberOfBackups) {
        this.numberOfBackups = numberOfBackups;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ClusterInfo setName(String name) {
        this.name = name;
        return this;
    }

    public int getRunningNumber() {
        if (this.getNumberOfInstances() == null) {
            return 0;
        }
        if (this.getNumberOfInstances() == 0) {
            if (this.getInstanceId() != null) {
                return this.getInstanceId();
            }
            return 0;
        }
        if (this.getInstanceId() == null || this.getInstanceId() == 0) {
            return 0;
        }
        if (this.getNumberOfBackups() == null || this.getNumberOfBackups() == 0) {
            return this.getInstanceId() - 1;
        }
        return (this.getInstanceId() - 1) * (this.getNumberOfBackups() + 1) + (this.getBackupId() == null ? 0 : this.getBackupId());
    }

    public int getRunningNumberOffset1() {
        return this.getRunningNumber() + 1;
    }

    public String getSuffix() {
        boolean hasBackups = this.getNumberOfBackups() != null && this.getNumberOfBackups() != 0;
        int instanceId = this.getInstanceId() != null ? this.getInstanceId() : 0;
        int backupId = this.getBackupId() != null ? this.getBackupId() + 1 : 1;
        return hasBackups ? instanceId + "_" + backupId : String.valueOf(instanceId);
    }

    public String getUniqueName() {
        return this.getName() + "_" + this.getSuffix();
    }

    public ClusterInfo copy() {
        ClusterInfo clusterInfo = new ClusterInfo();
        clusterInfo.setBackupId(this.getBackupId());
        clusterInfo.setInstanceId(this.getInstanceId());
        clusterInfo.setNumberOfBackups(this.getNumberOfBackups());
        clusterInfo.setNumberOfInstances(this.getNumberOfInstances());
        clusterInfo.setSchema(this.getSchema());
        clusterInfo.setName(this.getName());
        return clusterInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name[").append(this.name).append("] ");
        sb.append("schema[").append(this.schema).append("] ");
        sb.append("numberOfInstances[").append(this.numberOfInstances).append("] ");
        sb.append("numberOfBackups[").append(this.numberOfBackups).append("] ");
        sb.append("instanceId[").append(this.instanceId).append("] ");
        sb.append("backupId[").append(this.backupId).append("]");
        return sb.toString();
    }
}

