/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.cluster;

import java.lang.reflect.Field;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.openspaces.core.cluster.ClusterInfoContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class ClusterInfoBeanPostProcessor
implements BeanPostProcessor {
    private ClusterInfo clusterInfo;

    public ClusterInfoBeanPostProcessor(ClusterInfo clusterInfo) {
        this.clusterInfo = clusterInfo;
    }

    public Object postProcessBeforeInitialization(final Object bean, String beanName) throws BeansException {
        if (bean instanceof ClusterInfoAware) {
            ((ClusterInfoAware)bean).setClusterInfo(this.clusterInfo);
        }
        if (bean == null) {
            return bean;
        }
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                if (field.isAnnotationPresent(ClusterInfoContext.class)) {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    try {
                        field.set(bean, ClusterInfoBeanPostProcessor.this.clusterInfo);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to inject ClusterInfo", e);
                    }
                }
            }
        });
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

