/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.cluster;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceHealthStatus;
import org.openspaces.core.cluster.MemberAliveIndicator;
import org.openspaces.core.util.SpaceUtils;

public class SpaceMemberAliveIndicator
implements MemberAliveIndicator {
    private final boolean enabled;
    private final ISpaceProxy spaceProxy;

    public SpaceMemberAliveIndicator(IJSpace spaceProxy, Boolean enabled) {
        boolean isEmbedded = !SpaceUtils.isRemoteProtocol(spaceProxy);
        this.enabled = enabled != null ? enabled : isEmbedded;
        this.spaceProxy = isEmbedded ? (ISpaceProxy)SpaceUtils.getClusterMemberSpace(spaceProxy) : (ISpaceProxy)spaceProxy;
    }

    @Override
    public boolean isMemberAliveEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isAlive() throws Exception {
        SpaceHealthStatus spaceHealthStatus = this.spaceProxy.getSpaceHealthStatus();
        if (!spaceHealthStatus.isHealthy()) {
            throw spaceHealthStatus.getUnhealthyReason();
        }
        return true;
    }
}

