/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import java.util.List;
import org.openspaces.core.config.xmlparser.SecurityDefinitionsParser;
import org.openspaces.core.space.AllInCachePolicy;
import org.openspaces.core.space.CachePolicy;
import org.openspaces.core.space.LruCachePolicy;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractSpaceBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String PROPERTIES = "properties";
    private static final String SECURITY = "security";
    private static final String DATA_SOURCE = "external-data-source";
    private static final String SPACE_DATA_SOURCE = "space-data-source";
    private static final String SPACE_SYNC_ENDPOINT = "space-sync-endpoint";
    private static final String GATEWAY_TARGETS = "gateway-targets";
    private static final String REGISTER_FOR_SPACE_MODE_EVENTS = "register-for-space-mode-notifications";

    protected boolean isEligibleAttribute(String attributeName) {
        return super.isEligibleAttribute(attributeName) && !DATA_SOURCE.equals(attributeName) && !SPACE_DATA_SOURCE.equals(attributeName) && !SPACE_SYNC_ENDPOINT.equals(attributeName);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element securityEle;
        super.doParse(element, parserContext, builder);
        Element propertiesEle = DomUtils.getChildElementByTagName((Element)element, (String)PROPERTIES);
        if (propertiesEle != null) {
            Object properties = parserContext.getDelegate().parsePropertyValue(propertiesEle, (BeanDefinition)builder.getRawBeanDefinition(), PROPERTIES);
            builder.addPropertyValue(PROPERTIES, properties);
        }
        if ((securityEle = DomUtils.getChildElementByTagName((Element)element, (String)SECURITY)) != null) {
            SecurityDefinitionsParser.parseXml(securityEle, builder);
            String secured = securityEle.getAttribute("secured");
            if (StringUtils.hasText((String)secured)) {
                builder.addPropertyValue("secured", (Object)Boolean.parseBoolean(secured));
            }
        }
    }

    protected void parseServerComponents(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String registerForSpaceModeEvents;
        Element leaderSelectorStoreEle;
        Element attributeStoreEle;
        Element blobStoreDataPolicyEle;
        Element customCacheEle;
        Element lruCacheEle;
        Element spaceReplicationFilterEle;
        String spaceSynchronizationEndpoint;
        String spaceDataSource;
        String dataSource = element.getAttribute(DATA_SOURCE);
        if (StringUtils.hasLength((String)dataSource)) {
            builder.addPropertyReference("externalDataSource", dataSource);
        }
        if (StringUtils.hasLength((String)(spaceDataSource = element.getAttribute(SPACE_DATA_SOURCE)))) {
            builder.addPropertyReference("spaceDataSource", spaceDataSource);
        }
        if (StringUtils.hasLength((String)(spaceSynchronizationEndpoint = element.getAttribute(SPACE_SYNC_ENDPOINT)))) {
            builder.addPropertyReference("spaceSynchronizationEndpoint", spaceSynchronizationEndpoint);
        }
        List spaceFilterElements = DomUtils.getChildElementsByTagName((Element)element, (String)"space-filter");
        ManagedList list = new ManagedList();
        for (Element ele : spaceFilterElements) {
            list.add(parserContext.getDelegate().parsePropertySubElement(ele, (BeanDefinition)builder.getRawBeanDefinition()));
        }
        spaceFilterElements = DomUtils.getChildElementsByTagName((Element)element, (String)"annotation-adapter-filter");
        for (Element ele : spaceFilterElements) {
            list.add(parserContext.getDelegate().parsePropertySubElement(ele, (BeanDefinition)builder.getRawBeanDefinition(), null));
        }
        spaceFilterElements = DomUtils.getChildElementsByTagName((Element)element, (String)"method-adapter-filter");
        for (Element ele : spaceFilterElements) {
            list.add(parserContext.getDelegate().parsePropertySubElement(ele, (BeanDefinition)builder.getRawBeanDefinition(), null));
        }
        spaceFilterElements = DomUtils.getChildElementsByTagName((Element)element, (String)"filter-provider");
        for (Element ele : spaceFilterElements) {
            String refName = ele.getAttribute("ref");
            RuntimeBeanReference ref = new RuntimeBeanReference(refName, false);
            list.add((Object)ref);
        }
        builder.addPropertyValue("filterProviders", (Object)list);
        Element replicationFilterProviderEle = DomUtils.getChildElementByTagName((Element)element, (String)"replication-filter-provider");
        if (replicationFilterProviderEle != null) {
            String refName = replicationFilterProviderEle.getAttribute("ref");
            RuntimeBeanReference ref = new RuntimeBeanReference(refName, false);
            builder.addPropertyValue("replicationFilterProvider", (Object)ref);
        }
        if ((spaceReplicationFilterEle = DomUtils.getChildElementByTagName((Element)element, (String)"space-replication-filter")) != null) {
            builder.addPropertyValue("replicationFilterProvider", parserContext.getDelegate().parsePropertySubElement(spaceReplicationFilterEle, (BeanDefinition)builder.getRawBeanDefinition(), null));
        }
        CachePolicy cachePolicy = null;
        Element allInCacheEle = DomUtils.getChildElementByTagName((Element)element, (String)"all-in-cache-policy");
        if (allInCacheEle != null) {
            cachePolicy = new AllInCachePolicy();
        }
        if ((lruCacheEle = DomUtils.getChildElementByTagName((Element)element, (String)"lru-cache-policy")) != null) {
            String initialLoadPercentage;
            cachePolicy = new LruCachePolicy();
            String size = lruCacheEle.getAttribute("size");
            if (StringUtils.hasText((String)size)) {
                ((LruCachePolicy)cachePolicy).setSize(Integer.parseInt(size));
            }
            if (StringUtils.hasText((String)(initialLoadPercentage = lruCacheEle.getAttribute("initialLoadPercentage")))) {
                ((LruCachePolicy)cachePolicy).setInitialLoadPercentage(Integer.parseInt(initialLoadPercentage));
            }
        }
        if ((customCacheEle = DomUtils.getChildElementByTagName((Element)element, (String)"custom-cache-policy")) != null) {
            Object customCachePolicyFactoryBean = parserContext.getDelegate().parsePropertySubElement(customCacheEle, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("customCachePolicy", customCachePolicyFactoryBean);
        }
        if ((blobStoreDataPolicyEle = DomUtils.getChildElementByTagName((Element)element, (String)"blob-store-data-policy")) != null) {
            Object blobStoreDataPolicyFactoryBean = parserContext.getDelegate().parsePropertySubElement(blobStoreDataPolicyEle, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("blobStoreDataPolicy", blobStoreDataPolicyFactoryBean);
        }
        if ((attributeStoreEle = DomUtils.getChildElementByTagName((Element)element, (String)"attribute-store")) != null) {
            Object AttributeStoreFactoryBean2 = parserContext.getDelegate().parsePropertySubElement(attributeStoreEle, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("attributeStore", AttributeStoreFactoryBean2);
        }
        if ((leaderSelectorStoreEle = DomUtils.getChildElementByTagName((Element)element, (String)"leader-selector")) != null) {
            Object LeaderSelectorFactoryBean = parserContext.getDelegate().parsePropertySubElement(leaderSelectorStoreEle, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("leaderSelectorConfig", LeaderSelectorFactoryBean);
        }
        if (cachePolicy != null) {
            builder.addPropertyValue("cachePolicy", (Object)cachePolicy);
        }
        List documentTypeElements = DomUtils.getChildElementsByTagName((Element)element, (String)"space-type");
        ManagedList typesList = new ManagedList();
        for (Element ele : documentTypeElements) {
            typesList.add(parserContext.getDelegate().parsePropertySubElement(ele, (BeanDefinition)builder.getRawBeanDefinition()));
        }
        builder.addPropertyValue("spaceTypes", (Object)typesList);
        List spaceSqlFunctionElements = DomUtils.getChildElementsByTagName((Element)element, (String)"space-sql-function");
        ManagedList sqlFunctionsList = new ManagedList();
        for (Element ele : spaceSqlFunctionElements) {
            sqlFunctionsList.add(parserContext.getDelegate().parsePropertySubElement(ele, (BeanDefinition)builder.getRawBeanDefinition()));
        }
        builder.addPropertyValue("spaceSqlFunction", (Object)sqlFunctionsList);
        String gatewayTargetsRef = element.getAttribute(GATEWAY_TARGETS);
        if (StringUtils.hasLength((String)gatewayTargetsRef)) {
            builder.addPropertyReference("gatewayTargets", gatewayTargetsRef);
        }
        if (StringUtils.hasLength((String)(registerForSpaceModeEvents = element.getAttribute(REGISTER_FOR_SPACE_MODE_EVENTS)))) {
            builder.addPropertyValue("registerForSpaceModeNotifications", (Object)registerForSpaceModeEvents);
        }
        List queryExtensionProviders = DomUtils.getChildElementsByTagName((Element)element, (String)"query-extension-provider");
        ManagedList queryExtensionProviderList = new ManagedList();
        for (Element ele : queryExtensionProviders) {
            String refName = ele.getAttribute("ref");
            RuntimeBeanReference ref = new RuntimeBeanReference(refName, false);
            queryExtensionProviderList.add((Object)ref);
        }
        builder.addPropertyValue("queryExtensionProviders", (Object)queryExtensionProviderList);
    }
}

