/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import java.util.List;
import org.openspaces.core.config.BlobStoreDataPolicyFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class BlobStoreDataPolicyBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String AVG_OBJECT_SIZE_KB = "avg-object-size-KB";
    private static final String AVG_OBJECT_SIZE_BYTES = "avg-object-size-bytes";
    private static final String CACHE_ENTRIES_PERCENTAGE = "cache-entries-percentage";
    private static final String PERSISTENT = "persistent";
    private static final String STORAGE_HANDLER = "blob-store-handler";

    protected Class<BlobStoreDataPolicyFactoryBean> getBeanClass(Element element) {
        return BlobStoreDataPolicyFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String blobStoreStorageHandler;
        String persistent;
        String cacheEntriesPercentage;
        String avgObjectSizeKB = element.getAttribute(AVG_OBJECT_SIZE_KB);
        String avgObjectSizeBytes = element.getAttribute(AVG_OBJECT_SIZE_BYTES);
        if (StringUtils.hasText((String)avgObjectSizeKB) && StringUtils.hasText((String)avgObjectSizeBytes)) {
            throw new IllegalArgumentException("avg-object-size-KB and avg-object-size-bytes cannot be used together");
        }
        if (StringUtils.hasText((String)avgObjectSizeKB)) {
            builder.addPropertyValue("avgObjectSizeKB", (Object)avgObjectSizeKB);
        }
        if (StringUtils.hasText((String)avgObjectSizeBytes)) {
            builder.addPropertyValue("avgObjectSizeBytes", (Object)avgObjectSizeBytes);
        }
        if (StringUtils.hasText((String)(cacheEntriesPercentage = element.getAttribute(CACHE_ENTRIES_PERCENTAGE)))) {
            builder.addPropertyValue("cacheEntriesPercentage", (Object)cacheEntriesPercentage);
        }
        if (StringUtils.hasText((String)(persistent = element.getAttribute(PERSISTENT)))) {
            builder.addPropertyValue(PERSISTENT, (Object)persistent);
        }
        if (StringUtils.hasText((String)(blobStoreStorageHandler = element.getAttribute(STORAGE_HANDLER)))) {
            builder.addPropertyReference("blobStoreHandler", blobStoreStorageHandler);
        }
        if (!StringUtils.hasText((String)blobStoreStorageHandler)) {
            throw new IllegalArgumentException("A reference to a space blob store handler bean must be specified");
        }
        List queryElements = DomUtils.getChildElementsByTagName((Element)element, (String)"blob-store-cache-query");
        ManagedList list = new ManagedList(queryElements.size());
        for (Element ele : queryElements) {
            list.add(parserContext.getDelegate().parsePropertySubElement(ele, (BeanDefinition)builder.getRawBeanDefinition(), null));
        }
        builder.addPropertyValue("blobstoreCacheQueries", (Object)list);
    }
}

