/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import com.gigaspaces.server.blobstore.BlobStoreException;
import com.gigaspaces.server.blobstore.BlobStoreStorageHandler;
import com.j_spaces.core.client.SQLQuery;
import java.util.List;
import org.openspaces.core.space.BlobStoreDataCachePolicy;
import org.openspaces.core.space.CachePolicy;

public class BlobStoreDataPolicyConfigurer {
    private BlobStoreStorageHandler blobStoreHandler;
    private List<SQLQuery> cacheQueries;
    private Boolean persistent;
    private Integer cacheEntriesPercentage;
    private Integer avgObjectSizeKB;
    private Integer avgObjectSizeBytes;

    public BlobStoreStorageHandler getBlobStoreHandler() {
        return this.blobStoreHandler;
    }

    public BlobStoreDataPolicyConfigurer setBlobStoreHandler(BlobStoreStorageHandler blobStoreHandler) {
        this.blobStoreHandler = blobStoreHandler;
        return this;
    }

    public List<SQLQuery> getCacheQueries() {
        return this.cacheQueries;
    }

    public BlobStoreDataPolicyConfigurer setCacheQueries(List<SQLQuery> cacheQueries) {
        this.cacheQueries = cacheQueries;
        return this;
    }

    public Boolean getPersistent() {
        return this.persistent;
    }

    public BlobStoreDataPolicyConfigurer setPersistent(Boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public Integer getCacheEntriesPercentage() {
        return this.cacheEntriesPercentage;
    }

    public BlobStoreDataPolicyConfigurer setCacheEntriesPercentage(Integer cacheEntriesPercentage) {
        this.cacheEntriesPercentage = cacheEntriesPercentage;
        return this;
    }

    public BlobStoreDataPolicyConfigurer setAvgObjectSizeBytes(Integer avgObjectSizeBytes) {
        this.avgObjectSizeBytes = avgObjectSizeBytes;
        return this;
    }

    public BlobStoreDataPolicyConfigurer setAvgObjectSizeKB(Integer avgObjectSizeKB) {
        this.avgObjectSizeKB = avgObjectSizeKB;
        return this;
    }

    public CachePolicy asCachePolicy() {
        BlobStoreDataCachePolicy policy = new BlobStoreDataCachePolicy();
        if (this.avgObjectSizeKB != null && this.avgObjectSizeBytes != null) {
            throw new BlobStoreException("avgObjectSizeKB and avgObjectSizeBytes cannot be used together");
        }
        if (this.avgObjectSizeKB != null) {
            policy.setAvgObjectSizeKB(this.avgObjectSizeKB);
        }
        if (this.avgObjectSizeBytes != null) {
            policy.setAvgObjectSizeBytes(this.avgObjectSizeBytes);
        }
        if (this.cacheEntriesPercentage != null) {
            policy.setCacheEntriesPercentage(this.cacheEntriesPercentage);
        }
        if (this.persistent == null) {
            throw new BlobStoreException("persistent attribute in Blobstore space must be configured");
        }
        policy.setPersistent(this.persistent);
        if (this.blobStoreHandler == null) {
            throw new BlobStoreException("blobStoreHandler attribute in Blobstore space must be configured");
        }
        policy.setBlobStoreHandler(this.blobStoreHandler);
        if (this.cacheQueries != null) {
            for (SQLQuery sqlQuery : this.cacheQueries) {
                policy.addCacheQuery(sqlQuery);
            }
        }
        return policy;
    }
}

