/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import org.openspaces.core.space.mode.SpaceModeContextLoader;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class ContextLoaderBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String GIGA_SPACE = "giga-space";

    protected Class getBeanClass(Element element) {
        return SpaceModeContextLoader.class;
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return super.isEligibleAttribute(attributeName) && !GIGA_SPACE.equals(attributeName);
    }

    protected void postProcess(BeanDefinitionBuilder beanDefinition, Element element) {
        String gigaSpace = element.getAttribute(GIGA_SPACE);
        if (StringUtils.hasLength((String)gigaSpace)) {
            beanDefinition.addPropertyReference("gigaSpace", gigaSpace);
        }
    }
}

