/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import org.openspaces.core.config.CustomCachePolicyFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CustomCachePolicyBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String SIZE_PROPERTY = "size";
    private static final String INITIAL_LOAD_PERCENTAGE_PROPERTY = "initial-load-percentage";
    private static final String SPACE_EVICTION_STRATEGY_PROPERTY = "space-eviction-strategy";

    protected Class<CustomCachePolicyFactoryBean> getBeanClass(Element element) {
        return CustomCachePolicyFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String spaceEvictionStrategyBeanName;
        String initialLoadPercentage;
        String size = element.getAttribute(SIZE_PROPERTY);
        if (StringUtils.hasText((String)size)) {
            builder.addPropertyValue(SIZE_PROPERTY, (Object)size);
        }
        if (StringUtils.hasText((String)(initialLoadPercentage = element.getAttribute(INITIAL_LOAD_PERCENTAGE_PROPERTY)))) {
            builder.addPropertyValue("initialLoadPercentage", (Object)initialLoadPercentage);
        }
        if (!StringUtils.hasText((String)(spaceEvictionStrategyBeanName = element.getAttribute(SPACE_EVICTION_STRATEGY_PROPERTY)))) {
            throw new IllegalArgumentException("A reference to a space eviction strategy bean must be specified using the 'ref' attribute");
        }
        builder.addPropertyReference("spaceEvictionStrategy", spaceEvictionStrategyBeanName);
    }
}

