/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import java.util.List;
import org.openspaces.core.GigaSpaceFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class GigaSpaceBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    public static final String DEFAULT_ISOLATION = "default-isolation";
    public static final String SPACE = "space";
    public static final String TX_MANAGER = "tx-manager";

    protected Class<GigaSpaceFactoryBean> getBeanClass(Element element) {
        return GigaSpaceFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.handleModifierElements(element, parserContext, builder);
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            String name = attribute.getLocalName();
            if ("id".equals(name)) continue;
            String propertyName = this.extractPropertyName(name);
            if (DEFAULT_ISOLATION.equals(name)) {
                builder.addPropertyValue("defaultIsolationLevelName", (Object)("ISOLATION_" + attribute.getValue()));
                continue;
            }
            if (SPACE.equals(name)) {
                builder.addPropertyReference(SPACE, attribute.getValue());
                continue;
            }
            if (TX_MANAGER.equals(name)) {
                builder.addPropertyReference("transactionManager", attribute.getValue());
                continue;
            }
            Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            builder.addPropertyValue(propertyName, (Object)attribute.getValue());
        }
    }

    private void handleModifierElements(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.handleModifierElements(element, parserContext, builder, ModifierElement.Write);
        this.handleModifierElements(element, parserContext, builder, ModifierElement.Read);
        this.handleModifierElements(element, parserContext, builder, ModifierElement.Take);
        this.handleModifierElements(element, parserContext, builder, ModifierElement.Count);
        this.handleModifierElements(element, parserContext, builder, ModifierElement.Clear);
        this.handleModifierElements(element, parserContext, builder, ModifierElement.Change);
    }

    private void handleModifierElements(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, ModifierElement modifierElementEnum) {
        List modifiers = DomUtils.getChildElementsByTagName((Element)element, (String)(modifierElementEnum.name().toLowerCase() + "-modifier"));
        if (modifiers.isEmpty()) {
            return;
        }
        ManagedList managedModifiers = new ManagedList();
        for (Element modifierElement : modifiers) {
            managedModifiers.add(parserContext.getDelegate().parsePropertySubElement(modifierElement, (BeanDefinition)builder.getRawBeanDefinition(), null));
        }
        builder.addPropertyValue("default" + modifierElementEnum.name() + "Modifiers", (Object)managedModifiers);
    }

    protected String extractPropertyName(String attributeName) {
        return Conventions.attributeNameToPropertyName((String)attributeName);
    }

    private static enum ModifierElement {
        Write,
        Read,
        Take,
        Count,
        Clear,
        Change;

    }
}

