/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import com.gigaspaces.metadata.StorageType;
import com.gigaspaces.metadata.index.SpaceIndexType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.openspaces.core.config.BasicIndex;
import org.openspaces.core.config.CompoundIndex;
import org.openspaces.core.config.EqualIndex;
import org.openspaces.core.config.EqualOrderedIndex;
import org.openspaces.core.config.ExtendedIndex;
import org.openspaces.core.config.GigaSpaceDocumentTypeDescriptorFactoryBean;
import org.openspaces.core.config.OrderedIndex;
import org.openspaces.core.config.SpaceIdProperty;
import org.openspaces.core.config.SpaceIndex;
import org.openspaces.core.config.SpaceRoutingProperty;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class GigaSpaceDocumentTypeBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class getBeanClass(Element element) {
        return GigaSpaceDocumentTypeDescriptorFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element fifoGroupingPropertyElem;
        Element routingElem;
        boolean unique;
        String uniques;
        String indexPropertyPath;
        int i;
        super.doParse(element, parserContext, builder);
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            String name = attribute.getLocalName();
            if ("id".equals(name)) continue;
            String propertyName = this.extractPropertyName(name);
            Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            if (propertyName.equals("typeName")) {
                builder.addPropertyValue(propertyName, (Object)attribute.getValue());
            }
            if (propertyName.equals("replicable")) {
                builder.addPropertyValue(propertyName, (Object)attribute.getValue());
            }
            if (propertyName.equals("optimisticLock")) {
                builder.addPropertyValue(propertyName, (Object)attribute.getValue());
            }
            if (propertyName.equals("fifoSupport")) {
                builder.addPropertyValue(propertyName, (Object)attribute.getValue());
            }
            if (propertyName.equals("storageType")) {
                builder.addPropertyValue(propertyName, (Object)Enum.valueOf(StorageType.class, attribute.getValue().toUpperCase()));
            }
            if (!propertyName.equals("blobstoreEnabled")) continue;
            builder.addPropertyValue(propertyName, (Object)attribute.getValue());
        }
        Element documentClassElem = DomUtils.getChildElementByTagName((Element)element, (String)"document-class");
        if (documentClassElem != null) {
            String className = documentClassElem.getTextContent();
            builder.addPropertyValue("documentClass", (Object)className);
        }
        HashMap<String, SpaceIndex> indexes = new HashMap<String, SpaceIndex>();
        List indexedElements = DomUtils.getChildElementsByTagName((Element)element, (String)"basic-index");
        for (i = 0; i < indexedElements.size(); ++i) {
            indexPropertyPath = ((Element)indexedElements.get(i)).getAttribute("path");
            uniques = ((Element)indexedElements.get(i)).getAttribute("unique");
            if (!StringUtils.hasText((String)indexPropertyPath)) continue;
            unique = StringUtils.hasText((String)uniques) && uniques.equalsIgnoreCase("true");
            indexes.put(indexPropertyPath, new BasicIndex(indexPropertyPath, unique));
        }
        indexedElements = DomUtils.getChildElementsByTagName((Element)element, (String)"extended-index");
        for (i = 0; i < indexedElements.size(); ++i) {
            indexPropertyPath = ((Element)indexedElements.get(i)).getAttribute("path");
            uniques = ((Element)indexedElements.get(i)).getAttribute("unique");
            if (!StringUtils.hasText((String)indexPropertyPath)) continue;
            unique = StringUtils.hasText((String)uniques) && uniques.equalsIgnoreCase("true");
            indexes.put(indexPropertyPath, new ExtendedIndex(indexPropertyPath, unique));
        }
        indexedElements = DomUtils.getChildElementsByTagName((Element)element, (String)"equal-index");
        for (i = 0; i < indexedElements.size(); ++i) {
            indexPropertyPath = ((Element)indexedElements.get(i)).getAttribute("path");
            uniques = ((Element)indexedElements.get(i)).getAttribute("unique");
            if (!StringUtils.hasText((String)indexPropertyPath)) continue;
            unique = StringUtils.hasText((String)uniques) && uniques.equalsIgnoreCase("true");
            indexes.put(indexPropertyPath, new EqualIndex(indexPropertyPath, unique));
        }
        indexedElements = DomUtils.getChildElementsByTagName((Element)element, (String)"ordered-index");
        for (i = 0; i < indexedElements.size(); ++i) {
            indexPropertyPath = ((Element)indexedElements.get(i)).getAttribute("path");
            uniques = ((Element)indexedElements.get(i)).getAttribute("unique");
            if (!StringUtils.hasText((String)indexPropertyPath)) continue;
            unique = StringUtils.hasText((String)uniques) && uniques.equalsIgnoreCase("true");
            indexes.put(indexPropertyPath, new OrderedIndex(indexPropertyPath, unique));
        }
        indexedElements = DomUtils.getChildElementsByTagName((Element)element, (String)"equal-ordered-index");
        for (i = 0; i < indexedElements.size(); ++i) {
            indexPropertyPath = ((Element)indexedElements.get(i)).getAttribute("path");
            uniques = ((Element)indexedElements.get(i)).getAttribute("unique");
            if (!StringUtils.hasText((String)indexPropertyPath)) continue;
            unique = StringUtils.hasText((String)uniques) && uniques.equalsIgnoreCase("true");
            indexes.put(indexPropertyPath, new EqualOrderedIndex(indexPropertyPath, unique));
        }
        indexedElements = DomUtils.getChildElementsByTagName((Element)element, (String)"compound-index");
        for (i = 0; i < indexedElements.size(); ++i) {
            String uniques2 = ((Element)indexedElements.get(i)).getAttribute("unique");
            boolean unique2 = StringUtils.hasText((String)uniques2) && uniques2.equalsIgnoreCase("true");
            CompoundIndex cs = this.createCompoundIndexDef(((Element)indexedElements.get(i)).getAttribute("paths"), ((Element)indexedElements.get(i)).getAttribute("type"), unique2);
            if (cs == null) continue;
            indexes.put(cs.getPath(), cs);
        }
        builder.addPropertyValue("indexes", (Object)indexes.values().toArray());
        Element idElem = DomUtils.getChildElementByTagName((Element)element, (String)"id");
        if (idElem != null) {
            String propertyName = idElem.getAttribute("property");
            String idAutogenerate = idElem.getAttribute("auto-generate");
            SpaceIdProperty idProperty = new SpaceIdProperty();
            idProperty.setPropertyName(propertyName);
            if (StringUtils.hasText((String)idAutogenerate)) {
                idProperty.setAutoGenerate(Boolean.parseBoolean(idAutogenerate));
            }
            if (indexes.containsKey(propertyName)) {
                idProperty.setIndex(SpaceIndexType.NONE);
            }
            builder.addPropertyValue("idProperty", (Object)idProperty);
        }
        if ((routingElem = DomUtils.getChildElementByTagName((Element)element, (String)"routing")) != null) {
            String propertyName = routingElem.getAttribute("property");
            SpaceRoutingProperty routingProperty = new SpaceRoutingProperty();
            routingProperty.setPropertyName(propertyName);
            if (indexes.containsKey(propertyName)) {
                routingProperty.setIndex(SpaceIndexType.NONE);
            }
            builder.addPropertyValue("routingProperty", (Object)routingProperty);
        }
        if ((fifoGroupingPropertyElem = DomUtils.getChildElementByTagName((Element)element, (String)"fifo-grouping-property")) != null) {
            String path = fifoGroupingPropertyElem.getAttribute("path");
            builder.addPropertyValue("fifoGroupingPropertyPath", (Object)path);
        }
        LinkedList<String> fifoGroupingIndexes = new LinkedList<String>();
        List fifoGroupingIndexedElements = DomUtils.getChildElementsByTagName((Element)element, (String)"fifo-grouping-index");
        for (int i2 = 0; i2 < fifoGroupingIndexedElements.size(); ++i2) {
            String path = ((Element)fifoGroupingIndexedElements.get(i2)).getAttribute("path");
            fifoGroupingIndexes.add(path);
        }
        builder.addPropertyValue("fifoGroupingIndexesPaths", fifoGroupingIndexes);
        Element sequenceNumberPropertyElem = DomUtils.getChildElementByTagName((Element)element, (String)"sequence-number");
        if (sequenceNumberPropertyElem != null) {
            String name = sequenceNumberPropertyElem.getAttribute("name");
            builder.addPropertyValue("sequenceNumberProperty", (Object)name);
        }
        TreeMap<String, String> fixedProperties = new TreeMap<String, String>();
        List fixedPropertiesElements = DomUtils.getChildElementsByTagName((Element)element, (String)"fixed-property");
        for (int i3 = 0; i3 < fixedPropertiesElements.size(); ++i3) {
            String name = ((Element)fixedPropertiesElements.get(i3)).getAttribute("name");
            String type = ((Element)fixedPropertiesElements.get(i3)).getAttribute("type-name");
            fixedProperties.put(name, type);
        }
        builder.addPropertyValue("fixedProperties", fixedProperties);
    }

    private String extractPropertyName(String attributeName) {
        return Conventions.attributeNameToPropertyName((String)attributeName);
    }

    private CompoundIndex createCompoundIndexDef(String paths, String indexType, boolean unique) {
        if (!StringUtils.hasText((String)paths)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String delim = paths.indexOf(",") != -1 ? "," : " ";
        StringTokenizer st = new StringTokenizer(paths, delim);
        int pnum = st.countTokens();
        if (pnum < 2) {
            return null;
        }
        String[] ps = new String[pnum];
        for (int i = 0; i < pnum; ++i) {
            ps[i] = st.nextToken().trim();
            if (!StringUtils.hasText((String)ps[i])) {
                return null;
            }
            if (i > 0) {
                sb.append("+");
            }
            sb.append(ps[i]);
        }
        return new CompoundIndex(sb.toString(), ps, CompoundIndex.CompoundIndexTypes.BASIC, unique);
    }
}

