/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import com.gigaspaces.annotation.pojo.FifoSupport;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.metadata.SpaceTypeDescriptorBuilder;
import com.gigaspaces.metadata.StorageType;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.openspaces.core.config.BasicIndex;
import org.openspaces.core.config.CompoundIndex;
import org.openspaces.core.config.EqualIndex;
import org.openspaces.core.config.EqualOrderedIndex;
import org.openspaces.core.config.ExtendedIndex;
import org.openspaces.core.config.OrderedIndex;
import org.openspaces.core.config.SpaceIdProperty;
import org.openspaces.core.config.SpaceIndex;
import org.openspaces.core.config.SpaceRoutingProperty;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class GigaSpaceDocumentTypeDescriptorFactoryBean
implements FactoryBean<SpaceTypeDescriptor>,
InitializingBean {
    private SpaceTypeDescriptor typeDescriptor;
    private String _typeName;
    private SpaceTypeDescriptor _superTypeDescriptor;
    private SortedMap<String, String> _fixedProperties;
    private FifoSupport _fifoSupport;
    private Boolean _replicable;
    private Boolean _supportsOptimisticLocking;
    private SpaceIndex[] _indexes;
    private SpaceRoutingProperty _routingProperty;
    private SpaceIdProperty _idProperty;
    private StorageType _storageType;
    private String _fifoGroupingPropertyPath;
    private Set<String> _fifoGroupingIndexesPaths;
    private Boolean _blobstoreEnabled;
    private String _sequenceNumberProperty;
    private String _documentWrapperClassName;

    public SpaceTypeDescriptor getObject() throws Exception {
        return this.typeDescriptor;
    }

    public Class<?> getObjectType() {
        return SpaceTypeDescriptor.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.typeDescriptor == null) {
            SpaceTypeDescriptorBuilder typeDescriptorBuilder = new SpaceTypeDescriptorBuilder(this._typeName, this._superTypeDescriptor);
            if (this._idProperty != null) {
                if (this._idProperty.getIndex() == null) {
                    typeDescriptorBuilder.idProperty(this._idProperty.getPropertyName(), this._idProperty.isAutoGenerate());
                } else {
                    typeDescriptorBuilder.idProperty(this._idProperty.getPropertyName(), this._idProperty.isAutoGenerate(), this._idProperty.getIndex());
                }
            }
            if (this._routingProperty != null) {
                if (this._routingProperty.getIndex() == null) {
                    typeDescriptorBuilder.routingProperty(this._routingProperty.getPropertyName());
                } else {
                    typeDescriptorBuilder.routingProperty(this._routingProperty.getPropertyName(), this._routingProperty.getIndex());
                }
            }
            if (this._fifoSupport != null) {
                typeDescriptorBuilder.fifoSupport(this._fifoSupport);
            }
            if (this._supportsOptimisticLocking != null) {
                typeDescriptorBuilder.supportsOptimisticLocking(this._supportsOptimisticLocking.booleanValue());
            }
            if (this._replicable != null) {
                typeDescriptorBuilder.replicable(this._replicable.booleanValue());
            }
            if (this._blobstoreEnabled != null) {
                typeDescriptorBuilder.setBlobstoreEnabled(this._blobstoreEnabled.booleanValue());
            }
            if (this._documentWrapperClassName != null) {
                this._documentWrapperClassName = this._documentWrapperClassName.trim();
                Class documentWrapperClass = ClassLoaderHelper.loadClass((String)this._documentWrapperClassName);
                typeDescriptorBuilder.documentWrapperClass(documentWrapperClass);
            }
            if (this._indexes != null) {
                for (SpaceIndex index : this._indexes) {
                    if (index instanceof BasicIndex) {
                        BasicIndex basicIndex = (BasicIndex)index;
                        typeDescriptorBuilder.addPathIndex(basicIndex.getPath(), SpaceIndexType.BASIC, index.isUnique());
                        continue;
                    }
                    if (index instanceof ExtendedIndex) {
                        ExtendedIndex extendedIndex = (ExtendedIndex)index;
                        typeDescriptorBuilder.addPathIndex(extendedIndex.getPath(), SpaceIndexType.EXTENDED, index.isUnique());
                        continue;
                    }
                    if (index instanceof EqualIndex) {
                        EqualIndex equalIndex = (EqualIndex)index;
                        typeDescriptorBuilder.addPathIndex(equalIndex.getPath(), SpaceIndexType.EQUAL, index.isUnique());
                        continue;
                    }
                    if (index instanceof OrderedIndex) {
                        OrderedIndex orderedIndex = (OrderedIndex)index;
                        typeDescriptorBuilder.addPathIndex(orderedIndex.getPath(), SpaceIndexType.ORDERED, index.isUnique());
                        continue;
                    }
                    if (index instanceof EqualOrderedIndex) {
                        EqualOrderedIndex equalOrderedIndex = (EqualOrderedIndex)index;
                        typeDescriptorBuilder.addPathIndex(equalOrderedIndex.getPath(), SpaceIndexType.EQUAL_AND_ORDERED, index.isUnique());
                        continue;
                    }
                    if (index instanceof CompoundIndex) {
                        CompoundIndex compoundIndex = (CompoundIndex)index;
                        typeDescriptorBuilder.addCompoundIndex(compoundIndex.getPaths(), compoundIndex.getCompoundIndexType() == CompoundIndex.CompoundIndexTypes.EXTENDED ? SpaceIndexType.EXTENDED : SpaceIndexType.BASIC, index.isUnique());
                        continue;
                    }
                    throw new IllegalArgumentException("Illegal index type " + index);
                }
            }
            if (this._storageType != null) {
                typeDescriptorBuilder.storageType(this._storageType);
            }
            if (this._fifoGroupingPropertyPath != null) {
                typeDescriptorBuilder.fifoGroupingProperty(this._fifoGroupingPropertyPath);
            }
            if (this._fifoGroupingIndexesPaths != null) {
                for (String string : this._fifoGroupingIndexesPaths) {
                    typeDescriptorBuilder.addFifoGroupingIndex(string);
                }
            }
            if (this._sequenceNumberProperty != null) {
                typeDescriptorBuilder.sequenceNumberProperty(this._sequenceNumberProperty, true);
            }
            if (this._fixedProperties != null) {
                for (Map.Entry entry : this._fixedProperties.entrySet()) {
                    typeDescriptorBuilder.addFixedProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            this.typeDescriptor = typeDescriptorBuilder.create();
        }
    }

    public void setTypeName(String typeName) {
        this._typeName = typeName;
    }

    public void setSuperType(SpaceTypeDescriptor superTypeDescriptor) {
        this._superTypeDescriptor = superTypeDescriptor;
    }

    public void setFifoSupport(FifoSupport fifoSupport) {
        this._fifoSupport = fifoSupport;
    }

    public void setReplicable(boolean replicable) {
        this._replicable = replicable;
    }

    public void setOptimisticLock(boolean optimisticLocking) {
        this._supportsOptimisticLocking = optimisticLocking;
    }

    public void setIdProperty(SpaceIdProperty idProperty) {
        this._idProperty = idProperty;
    }

    public void setRoutingProperty(SpaceRoutingProperty routingProperty) {
        this._routingProperty = routingProperty;
    }

    public void setIndexes(SpaceIndex ... indexes) {
        this._indexes = indexes;
    }

    public void setDocumentClass(String documentWrapperClassName) throws ClassNotFoundException {
        this._documentWrapperClassName = documentWrapperClassName;
    }

    public StorageType getStorageType() {
        return this._storageType;
    }

    public void setStorageType(StorageType storageType) {
        this._storageType = storageType;
    }

    public String getFifoGroupingPropertyPath() {
        return this._fifoGroupingPropertyPath;
    }

    public void setFifoGroupingPropertyPath(String fifoGroupingPropertyPath) {
        this._fifoGroupingPropertyPath = fifoGroupingPropertyPath;
    }

    public String getSequenceNumberProperty() {
        return this._sequenceNumberProperty;
    }

    public void setSequenceNumberProperty(String sequenceNumberProperty) {
        this._sequenceNumberProperty = sequenceNumberProperty;
    }

    public Set<String> getFifoGroupingIndexesPaths() {
        return this._fifoGroupingIndexesPaths;
    }

    public void setFifoGroupingIndexesPaths(Set<String> fifoGroupingIndexesPaths) {
        this._fifoGroupingIndexesPaths = fifoGroupingIndexesPaths;
    }

    public boolean getBlobstoreEnabled() {
        return this._blobstoreEnabled;
    }

    public void setBlobstoreEnabled(boolean blobstoreEnabled) {
        this._blobstoreEnabled = blobstoreEnabled;
    }

    public void setFixedProperties(SortedMap<String, String> _fixedProperties) {
        this._fixedProperties = _fixedProperties;
    }

    public SortedMap<String, String> getFixedProperties() {
        return this._fixedProperties;
    }
}

