/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import org.openspaces.core.config.AbstractJiniTxManagerBeanDefinitionParser;
import org.openspaces.core.transaction.manager.LookupJiniTransactionManager;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class LookupJiniTxManagerBeanDefinitionParser
extends AbstractJiniTxManagerBeanDefinitionParser {
    public static final String TX_MANAGER_NAME = "tx-manager-name";
    public static final String GROUPS = "groups";
    public static final String LOCATORS = "locators";

    protected Class<LookupJiniTransactionManager> getBeanClass(Element element) {
        return LookupJiniTransactionManager.class;
    }

    @Override
    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        super.doParse(element, builder);
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            String locators;
            String groups;
            Attr attribute = (Attr)attributes.item(x);
            String name = attribute.getLocalName();
            if ("id".equals(name)) continue;
            String propertyName = this.extractPropertyName(name);
            if (TX_MANAGER_NAME.equals(name)) {
                builder.addPropertyValue("transactionManagerName", (Object)attribute.getValue());
                continue;
            }
            if (GROUPS.equals(name) && StringUtils.hasText((String)(groups = attribute.getValue()))) {
                String[] groupsArr = StringUtils.tokenizeToStringArray((String)groups, (String)",");
                builder.addPropertyValue(GROUPS, (Object)groupsArr);
            }
            if (LOCATORS.equals(name) && StringUtils.hasText((String)(locators = attribute.getValue()))) {
                String[] locatorsArr = StringUtils.tokenizeToStringArray((String)locators, (String)",");
                builder.addPropertyValue(LOCATORS, (Object)locatorsArr);
            }
            Assert.state((boolean)StringUtils.hasText((String)propertyName), (String)"Illegal property name returned from 'extractPropertyName(String)': cannot be null or empty.");
            builder.addPropertyValue(propertyName, (Object)attribute.getValue());
        }
    }

    protected String extractPropertyName(String attributeName) {
        return Conventions.attributeNameToPropertyName((String)attributeName);
    }
}

