/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import java.util.Properties;
import org.openspaces.core.space.UrlSpaceFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedProperties;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MirrorSpaceBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    public static final String DATA_SOURCE = "external-data-source";
    public static final String SOURCE_SPACE = "source-space";
    public static final String OPERATION_GROUPING = "operation-grouping";
    public static final String PROPERTIES = "properties";
    public static final String TRANSACTION_SUPPORT = "tx-support";
    public static final String SPACE_SYNC_ENDPOINT = "space-sync-endpoint";

    protected Class<UrlSpaceFactoryBean> getBeanClass(Element element) {
        return UrlSpaceFactoryBean.class;
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return super.isEligibleAttribute(attributeName) && !DATA_SOURCE.equals(attributeName) && !SPACE_SYNC_ENDPOINT.equals(attributeName) && !OPERATION_GROUPING.equals(attributeName);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element transactionProcessingConfigurationElement;
        Element edsEle;
        Element sourceSpaceEle;
        String spaceSynchronizationEndpoint;
        super.doParse(element, parserContext, builder);
        builder.addPropertyValue("schema", (Object)"mirror");
        String dataSource = element.getAttribute(DATA_SOURCE);
        if (StringUtils.hasLength((String)dataSource)) {
            builder.addPropertyReference("externalDataSource", dataSource);
        }
        if (StringUtils.hasLength((String)(spaceSynchronizationEndpoint = element.getAttribute(SPACE_SYNC_ENDPOINT)))) {
            builder.addPropertyReference("spaceSynchronizationEndpoint", spaceSynchronizationEndpoint);
        }
        Properties properties = new Properties();
        String operationGrouping = element.getAttribute(OPERATION_GROUPING);
        if (StringUtils.hasLength((String)operationGrouping)) {
            properties.put("space-config.mirror-service.operation-grouping", operationGrouping);
        }
        if ((sourceSpaceEle = DomUtils.getChildElementByTagName((Element)element, (String)SOURCE_SPACE)) != null) {
            properties.put("space-config.mirror-service.cluster.name", sourceSpaceEle.getAttribute("name"));
            properties.put("space-config.mirror-service.cluster.partitions", sourceSpaceEle.getAttribute("partitions"));
            properties.put("space-config.mirror-service.cluster.backups-per-partition", sourceSpaceEle.getAttribute("backups"));
        }
        builder.addPropertyValue(PROPERTIES, (Object)properties);
        Element propertiesEle = DomUtils.getChildElementByTagName((Element)element, (String)PROPERTIES);
        ManagedProperties spaceProps = new ManagedProperties();
        if (propertiesEle != null) {
            spaceProps = (ManagedProperties)parserContext.getDelegate().parsePropertyValue(propertiesEle, (BeanDefinition)builder.getRawBeanDefinition(), PROPERTIES);
            spaceProps.setMergeEnabled(true);
            builder.addPropertyValue(PROPERTIES, (Object)spaceProps);
        }
        if ((edsEle = DomUtils.getChildElementByTagName((Element)element, (String)DATA_SOURCE)) != null) {
            Assert.state((!StringUtils.hasText((String)dataSource) ? 1 : 0) != 0, (String)"duplicate definition of external-data-source");
            Object eds = parserContext.getDelegate().parsePropertyValue(edsEle, (BeanDefinition)builder.getRawBeanDefinition(), "externalDataSource");
            builder.addPropertyValue("externalDataSource", eds);
        }
        if ((transactionProcessingConfigurationElement = DomUtils.getChildElementByTagName((Element)element, (String)TRANSACTION_SUPPORT)) != null) {
            Object transactionProcessingConfiguration = parserContext.getDelegate().parsePropertySubElement(transactionProcessingConfigurationElement, (BeanDefinition)builder.getRawBeanDefinition());
            builder.addPropertyValue("distributedTransactionProcessingConfiguration", transactionProcessingConfiguration);
        }
    }
}

