/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import java.util.Properties;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class RestBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String GIGA_SPACE = "giga-space";
    private static final String PORT = "port";
    private static final String SPACE_NAME = "space-name";
    private static final String GROUPS = "lookup-groups";
    private static final String LOCATORS = "lookup-locators";
    private static final String PROPERTIES = "properties";

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element propsEle;
        Element propertiesEle;
        String port;
        String locators;
        String groups;
        String spaceName;
        super.doParse(element, parserContext, builder);
        String gigaSpace = element.getAttribute(GIGA_SPACE);
        if (StringUtils.hasLength((String)gigaSpace)) {
            builder.addPropertyReference("gigaSpace", gigaSpace);
        }
        if (StringUtils.hasLength((String)(spaceName = element.getAttribute(SPACE_NAME)))) {
            builder.addPropertyValue("spaceName", (Object)spaceName);
        }
        if (StringUtils.hasLength((String)(groups = element.getAttribute(GROUPS)))) {
            builder.addPropertyValue("groups", (Object)groups);
        }
        if (StringUtils.hasLength((String)(locators = element.getAttribute(LOCATORS)))) {
            builder.addPropertyValue("locators", (Object)locators);
        }
        if (StringUtils.hasLength((String)(port = element.getAttribute(PORT)))) {
            builder.addPropertyValue(PORT, (Object)port);
        }
        if ((propertiesEle = DomUtils.getChildElementByTagName((Element)element, (String)PROPERTIES)) != null && (propsEle = DomUtils.getChildElementByTagName((Element)propertiesEle, (String)"props")) != null) {
            Properties props = parserContext.getDelegate().parsePropsElement(propsEle);
            builder.addPropertyValue(PROPERTIES, (Object)props);
        }
    }

    protected String getBeanClassName(Element element) {
        return "org.openspaces.core.space.RestBean";
    }
}

