/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import org.openspaces.core.config.SQLQueryFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SQLQueryBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String WHERE = "where";
    private static final String CLASS = "class";
    private static final String CLASS_NAME = "class-name";
    private static final String TEMPLATE = "template";
    private static final String PROJECTIONS = "projections";

    protected Class<? extends SQLQueryFactoryBean> getBeanClass(Element element) {
        return SQLQueryFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element templateEle;
        String projections;
        String className;
        super.doParse(element, parserContext, builder);
        String where = element.getAttribute(WHERE);
        builder.addPropertyValue(WHERE, (Object)where);
        String clazz = element.getAttribute(CLASS);
        if (StringUtils.hasLength((String)clazz)) {
            builder.addPropertyValue("type", (Object)clazz);
        }
        if (StringUtils.hasLength((String)(className = element.getAttribute(CLASS_NAME)))) {
            builder.addPropertyValue("className", (Object)className);
        }
        if (StringUtils.hasLength((String)(projections = element.getAttribute(PROJECTIONS)))) {
            builder.addPropertyValue(PROJECTIONS, (Object)projections);
        }
        if ((templateEle = DomUtils.getChildElementByTagName((Element)element, (String)TEMPLATE)) != null) {
            Object template = parserContext.getDelegate().parsePropertyValue(templateEle, (BeanDefinition)builder.getRawBeanDefinition(), TEMPLATE);
            builder.addPropertyValue(TEMPLATE, template);
        }
    }
}

