/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config;

import com.j_spaces.core.client.SQLQuery;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SQLQueryFactoryBean
implements FactoryBean,
InitializingBean {
    private static final String PROJECTIONS_SEPARATOR = ",";
    private String where;
    private Object template;
    private Class<Object> type;
    private String className;
    private SQLQuery<Object> sqlQuery;
    private String projections;

    public void setWhere(String where) {
        this.where = where;
    }

    protected String getWhere() {
        return this.where;
    }

    public void setTemplate(Object template) {
        this.template = template;
    }

    protected Object getTemplate() {
        return this.template;
    }

    public void setType(Class<Object> clazz) {
        this.type = clazz;
    }

    protected Class<Object> getType() {
        return this.type;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    protected String getClassName() {
        return this.className;
    }

    public String getProjections() {
        return this.projections;
    }

    public void setProjections(String projections) {
        this.projections = projections;
    }

    public void afterPropertiesSet() throws Exception {
        this.validate();
        this.sqlQuery = this.getTemplate() != null ? new SQLQuery(this.getTemplate(), this.getWhere()) : (this.type != null ? new SQLQuery(this.getType(), this.getWhere()) : new SQLQuery(this.getClassName(), this.getWhere()));
        if (this.projections != null) {
            String[] projectionsArray = this.projections.split(PROJECTIONS_SEPARATOR);
            for (int i = 0; i < projectionsArray.length; ++i) {
                projectionsArray[i] = projectionsArray[i].trim();
            }
            this.sqlQuery.setProjections(projectionsArray);
        }
    }

    protected void validate() throws IllegalArgumentException {
        Assert.notNull((Object)this.where, (String)"where property is required");
        if (this.getTemplate() == null && this.getType() == null && this.getClassName() == null) {
            throw new IllegalArgumentException("either template property or type property or className must be set");
        }
    }

    public Object getObject() throws Exception {
        return this.sqlQuery;
    }

    public Class<SQLQuery> getObjectType() {
        return SQLQuery.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

